/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.interfaces.ISpecialTankHandler;
import logisticspipes.interfaces.routing.IFluidProvider;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.FluidRequestTreeNode;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.order.LogisticsFluidOrderManager;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidProvider
extends FluidRoutedPipe
implements IFluidProvider {
    LogisticsFluidOrderManager manager = new LogisticsFluidOrderManager();

    public PipeFluidProvider(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        int attemptedAmount;
        super.enabledUpdateEntity();
        if (!this.manager.hasOrders() || !this.isNthTick(6)) {
            return;
        }
        Triplet<FluidIdentifier, Integer, IRequestFluid> order = this.manager.getFirst();
        int amountToSend = attemptedAmount = Math.min((Integer)order.getValue2(), 5000);
        block0: for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            if (amountToSend <= 0) break;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                FluidStack drained = ((ISpecialTankAccessHandler)handler).drainFrom(pair.getValue1(), (FluidIdentifier)order.getValue1(), amountToSend, false);
                if (drained != null && ((FluidIdentifier)order.getValue1()).equals(FluidIdentifier.get(drained))) {
                    drained = ((ISpecialTankAccessHandler)handler).drainFrom(pair.getValue1(), (FluidIdentifier)order.getValue1(), amountToSend, true);
                    int amount = drained.amount;
                    amountToSend -= amount;
                    ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                    item.setDestination(order.getValue3().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    this.queueRoutedItem(item, pair.getValue2());
                    this.manager.sendAmount(amount);
                    if (amountToSend <= 0) break;
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack addition;
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.fluidID == 0 || !((FluidIdentifier)order.getValue1()).equals(FluidIdentifier.get(liquid))) continue;
                int amount = Math.min(liquid.amount, amountToSend);
                FluidStack drained = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amount, false);
                if (drained == null || !((FluidIdentifier)order.getValue1()).equals(FluidIdentifier.get(drained))) continue;
                drained = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amount, true);
                while (drained.amount < amountToSend && (addition = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amountToSend - drained.amount, false)) != null && ((FluidIdentifier)order.getValue1()).equals(FluidIdentifier.get(addition))) {
                    addition = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amountToSend - drained.amount, true);
                    drained.amount += addition.amount;
                }
                amount = drained.amount;
                amountToSend -= amount;
                ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                item.setDestination(order.getValue3().getRouter().getSimpleID());
                item.setTransportMode(IRoutedItem.TransportMode.Active);
                this.queueRoutedItem(item, pair.getValue2());
                this.manager.sendAmount(amount);
                if (amountToSend <= 0) continue block0;
            }
        }
        if (amountToSend >= attemptedAmount) {
            this.manager.sendFailed();
        }
    }

    @Override
    public Map<FluidIdentifier, Integer> getAvailableFluids() {
        HashMap<FluidIdentifier, Integer> map = new HashMap<FluidIdentifier, Integer>();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> tmp = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                for (Map.Entry<FluidIdentifier, Long> entry : tmp.entrySet()) {
                    if (map.containsKey(entry.getKey())) {
                        long addition = (long)((Integer)map.get(entry.getKey())).intValue() + entry.getValue();
                        map.put(entry.getKey(), addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                        continue;
                    }
                    map.put(entry.getKey(), entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)entry.getValue().longValue());
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.fluidID == 0) continue;
                FluidIdentifier ident = FluidIdentifier.get(liquid);
                if (!((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                if (map.containsKey(ident)) {
                    long addition = (long)((Integer)map.get(ident)).intValue() + (long)tank.fluid.amount;
                    map.put(ident, addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                    continue;
                }
                map.put(ident, tank.fluid.amount);
            }
        }
        for (Triplet triplet : this.manager.getAll()) {
            if (!map.containsKey(triplet.getValue1())) continue;
            int result = (Integer)map.get(triplet.getValue1()) - (Integer)triplet.getValue2();
            if (result > 0) {
                map.put((FluidIdentifier)triplet.getValue1(), result);
                continue;
            }
            map.remove(triplet.getValue1());
        }
        return map;
    }

    @Override
    public boolean disconnectPipe(TileEntity tile, ForgeDirection dir) {
        return SimpleServiceLocator.pipeInformaitonManager.isFluidPipe(tile);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_PROVIDER;
    }

    @Override
    public void canProvide(FluidRequestTreeNode request, int donePromises) {
        if (request.isDone()) {
            return;
        }
        int containedAmount = 0;
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> map = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                if (map.containsKey(request.getFluid())) {
                    long addition = (long)containedAmount + map.get(request.getFluid());
                    int n = containedAmount = addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition;
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.fluidID == 0 || !request.getFluid().equals(FluidIdentifier.get(liquid)) || !((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                long addition = (long)containedAmount + (long)liquid.amount;
                containedAmount = addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition;
            }
        }
        FluidLogisticsPromise promise = new FluidLogisticsPromise();
        promise.liquid = request.getFluid();
        promise.amount = Math.min(request.amountLeft(), containedAmount - donePromises);
        promise.sender = this;
        if (promise.amount > 0) {
            request.addPromise(promise);
        }
    }

    @Override
    public void fullFill(FluidLogisticsPromise promise, IRequestFluid destination) {
        this.manager.add(promise, destination);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> map = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                for (FluidIdentifier ident : map.keySet()) {
                    l1.add(ident.getItemIdentifier());
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.fluidID == 0 || !((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                FluidIdentifier ident = FluidIdentifier.get(liquid);
                l1.add(ident.getItemIdentifier());
            }
        }
        return l1;
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

