/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IRequestWatcher;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.OrderWatchRemovePacket;
import logisticspipes.network.packets.orderer.OrdererWatchPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.SimpleStackInventory;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeBlockRequestTable
extends PipeItemsRequestLogistics
implements ISimpleInventoryEventHandler,
IRequestWatcher,
IGuiOpenControler {
    public SimpleStackInventory diskInv = new SimpleStackInventory(1, "Disk Slot", 1);
    public SimpleStackInventory inv = new SimpleStackInventory(27, "Crafting Resources", 64);
    public ItemIdentifierInventory matrix = new ItemIdentifierInventory(9, "Crafting Matrix", 1);
    public ItemIdentifierInventory resultInv = new ItemIdentifierInventory(1, "Crafting Result", 1);
    public SimpleStackInventory toSortInv = new SimpleStackInventory(1, "Sorting Slot", 64);
    private IRecipe cache;
    private EntityPlayer fake;
    private int delay = 0;
    private int tick = 0;
    private PlayerCollectionList localGuiWatcher = new PlayerCollectionList();
    public Map<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>> watchedRequests = new HashMap<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>>();
    private int localLastUsedWatcherId = 0;

    public PipeBlockRequestTable(Item item) {
        super(item);
        this.matrix.addListener(this);
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isPipeControllerEquipped(entityplayer) && !entityplayer.func_70093_af()) {
            return false;
        }
        if (MainProxy.isServer(this.getWorld())) {
            if (settings == null || settings.openGui) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.permissiondenied", new Object[0]));
            }
        }
        return true;
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        super.ignoreDisableUpdateEntity();
        if (this.tick++ == 5) {
            this.getWorld().func_147479_m(this.getX(), this.getY(), this.getZ());
        }
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        if (this.tick % 2 == 0 && !this.localGuiWatcher.isEmpty()) {
            this.checkForExpired();
            if (this.getUpgradeManager().hasCraftingMonitoringUpgrade()) {
                for (Map.Entry<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>> entry : this.watchedRequests.entrySet()) {
                    MainProxy.sendToPlayerList(PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(entry.getValue().getValue2()).setStack(entry.getValue().getValue1()).setInteger(entry.getKey()).setTilePos(this.container), this.localGuiWatcher);
                }
            }
        } else if (this.tick % 20 == 0) {
            this.checkForExpired();
        }
    }

    private void checkForExpired() {
        Iterator<Map.Entry<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>>> iter = this.watchedRequests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>> entry = iter.next();
            if (!this.isDone(entry.getValue().getValue2())) continue;
            MainProxy.sendToPlayerList(PacketHandler.getPacket(OrderWatchRemovePacket.class).setInteger(entry.getKey()).setTilePos(this.container), this.localGuiWatcher);
            iter.remove();
        }
    }

    private boolean isDone(LinkedLogisticsOrderList orders) {
        boolean isDone = true;
        for (IOrderInfoProvider order : orders) {
            if (!order.isFinished()) {
                isDone = false;
            }
            if (order.getProgresses().isEmpty()) continue;
            isDone = false;
        }
        for (LinkedLogisticsOrderList orderList : orders.getSubOrders()) {
            if (this.isDone(orderList)) continue;
            isDone = false;
        }
        return isDone;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        ItemStack stack = this.toSortInv.func_70301_a(0);
        if (stack != null) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
            SimpleServiceLocator.logisticsManager.assignDestinationFor(itemToSend, this.getRouter().getSimpleID(), false);
            if (itemToSend.getDestinationUUID() != null) {
                ForgeDirection dir = this.getRouteLayer().getOrientationForItem(itemToSend, null);
                super.queueRoutedItem(itemToSend, dir.getOpposite());
                this.spawnParticle(Particles.OrangeParticle, 4);
                this.toSortInv.clearInventorySlotContents(0);
            } else {
                this.delay = 100;
            }
        } else {
            this.delay = 0;
        }
    }

    @Override
    public void openGui(EntityPlayer entityplayer) {
        boolean flag = true;
        if (this.diskInv.func_70301_a(0) == null && entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b().equals((Object)LogisticsPipes.LogisticsItemDisk)) {
            this.diskInv.func_70299_a(0, entityplayer.func_71045_bC());
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            flag = false;
        }
        if (flag) {
            entityplayer.openGui((Object)LogisticsPipes.instance, 38, this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.empty;
    }

    @Override
    public Textures.TextureType getRoutedTexture(ForgeDirection connection) {
        return Textures.empty_1;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        return Textures.empty_2;
    }

    public IIcon getTextureFor(int l) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)l);
        switch (dir) {
            case UP: {
                return Textures.LOGISTICS_REQUEST_TABLE[0];
            }
            case DOWN: {
                return Textures.LOGISTICS_REQUEST_TABLE[1];
            }
        }
        if (this.container.renderState.pipeConnectionMatrix.isConnected(dir)) {
            if (this.container.renderState.textureMatrix.getTextureIndex(dir) == 1) {
                return Textures.LOGISTICS_REQUEST_TABLE[2];
            }
            return Textures.LOGISTICS_REQUEST_TABLE[3];
        }
        return Textures.LOGISTICS_REQUEST_TABLE[4];
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isServer(this.getWorld())) {
            this.inv.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
            this.toSortInv.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
            this.diskInv.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
    }

    public void cacheRecipe() {
        this.cache = null;
        this.resultInv.clearInventorySlotContents(0);
        AutoCraftingInventory craftInv = new AutoCraftingInventory(null);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.getWorld())) continue;
            this.cache = r;
            this.resultInv.func_70299_a(0, r.func_77572_b((InventoryCrafting)craftInv));
            break;
        }
    }

    public ItemStack getOutput() {
        ItemStack left;
        int i;
        int j;
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return null;
            }
        }
        if (this.resultInv.getIDStackInSlot(0) == null) {
            return null;
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemStack item = this.matrix.func_70301_a(i2);
            if (item == null) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = ItemIdentifier.get(item);
            for (j = 0; j < this.inv.func_70302_i_(); ++j) {
                item = this.inv.func_70301_a(j);
                if (item == null || !ident.equalsForCrafting(ItemIdentifier.get(item)) || item.field_77994_a <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return null;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory(null);
        for (int i3 = 0; i3 < 9; ++i3) {
            int j2 = toUse[i3];
            if (j2 == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j2));
        }
        if (!this.cache.func_77569_a((InventoryCrafting)crafter, this.getWorld())) {
            return null;
        }
        ItemStack result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (result == null) {
            return null;
        }
        if (!this.resultInv.getIDStackInSlot(0).getItem().equalsWithoutNBT(ItemIdentifier.get(result))) {
            return null;
        }
        crafter = new AutoCraftingInventory(null);
        for (int i4 = 0; i4 < 9; ++i4) {
            j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer(this.container);
        }
        result = result.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting(this.fake, (IInventory)crafter, (IInventory)this.resultInv, 0, 0, 0);
        craftingSlot.func_82870_a(this.fake, result);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, null);
            if (left == null) continue;
            left.field_77994_a = this.inv.addCompressed(left, false);
            if (left.field_77994_a <= 0) continue;
            ItemIdentifierInventory.dropItems(this.getWorld(), left, this.getX(), this.getY(), this.getZ());
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, null);
            if (left == null) continue;
            left.field_77994_a = this.inv.addCompressed(left, false);
            if (left.field_77994_a <= 0) continue;
            ItemIdentifierInventory.dropItems(this.getWorld(), left, this.getX(), this.getY(), this.getZ());
        }
        return result;
    }

    public ItemStack getResultForClick() {
        ItemStack result = this.getOutput();
        if (result == null) {
            return null;
        }
        result.field_77994_a = this.inv.addCompressed(result, false);
        if (result.field_77994_a > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(ItemStack[] content) {
        for (int i = 0; i < 9; ++i) {
            this.matrix.func_70299_a(i, content[i]);
        }
        this.cacheRecipe();
    }

    @Override
    public void readFromNBT(NBTTagCompound par1nbtTagCompound) {
        super.readFromNBT(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.readFromNBT(par1nbtTagCompound, "toSortInv");
        this.diskInv.readFromNBT(par1nbtTagCompound, "diskInv");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1nbtTagCompound) {
        super.writeToNBT(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.writeToNBT(par1nbtTagCompound, "toSortInv");
        this.diskInv.writeToNBT(par1nbtTagCompound, "diskInv");
    }

    @Override
    public boolean sharesInventoryWith(CoreRoutedPipe other) {
        return false;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new TransportLayer(){

                @Override
                public void handleItem(IRoutedItem item) {
                    PipeBlockRequestTable.this.notifyOfItemArival(item.getInfo());
                    if (item.getItemIdentifierStack() != null) {
                        ItemIdentifierStack stack = item.getItemIdentifierStack();
                        stack.setStackSize(PipeBlockRequestTable.this.inv.addCompressed(stack.makeNormalStack(), false));
                    }
                }

                @Override
                public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection denyed) {
                    return null;
                }

                @Override
                public boolean stillWantItem(IRoutedItem item) {
                    return false;
                }
            };
        }
        return this._transportLayer;
    }

    @Override
    public void handleOrderList(ItemIdentifierStack stack, LinkedLogisticsOrderList orders) {
        if (!this.getUpgradeManager().hasCraftingMonitoringUpgrade()) {
            return;
        }
        orders.setWatched();
        this.watchedRequests.put(++this.localLastUsedWatcherId, new Pair<ItemIdentifierStack, LinkedLogisticsOrderList>(stack, orders));
        MainProxy.sendToPlayerList(PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(orders).setStack(stack).setInteger(this.localLastUsedWatcherId).setTilePos(this.container), this.localGuiWatcher);
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrderWatchRemovePacket.class).setInteger(-1).setTilePos(this.container), player);
        this.localGuiWatcher.add(player);
        for (Map.Entry<Integer, Pair<ItemIdentifierStack, LinkedLogisticsOrderList>> entry : this.watchedRequests.entrySet()) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(entry.getValue().getValue2()).setStack(entry.getValue().getValue1()).setInteger(entry.getKey()).setTilePos(this.container), player);
        }
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.localGuiWatcher.remove(player);
    }

    @Override
    public void handleClientSideListInfo(int id, ItemIdentifierStack stack, LinkedLogisticsOrderList orders) {
        if (MainProxy.isClient(this.getWorld())) {
            this.watchedRequests.put(id, new Pair<ItemIdentifierStack, LinkedLogisticsOrderList>(stack, orders));
        }
    }

    @Override
    public void handleClientSideRemove(int id) {
        if (MainProxy.isClient(this.getWorld())) {
            if (id == -1) {
                this.watchedRequests.clear();
            } else {
                this.watchedRequests.remove(id);
            }
        }
    }

    public ItemStack getDisk() {
        return this.diskInv.func_70301_a(0);
    }
}

