/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logisticspipes.Configs;
import logisticspipes.LPConstants;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.RoutingLaserPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.PathFinder;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RequestRoutingLasersPacket
extends CoordinatesPacket {
    private boolean firstPipe = false;

    public RequestRoutingLasersPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof CoreRoutedPipe) {
            IRouter router = ((CoreRoutedPipe)tile.pipe).getRouter();
            router.forceLsaUpdate();
            List<List<ExitRoute>> exits = router.getRouteTable();
            HashMap routers = new HashMap();
            for (List<ExitRoute> exit : exits) {
                if (exit == null) continue;
                for (ExitRoute e : exit) {
                    if (!routers.containsKey(e.exitOrientation)) {
                        routers.put(e.exitOrientation, new ArrayList());
                    }
                    if (((ArrayList)routers.get(e.exitOrientation)).contains(e)) continue;
                    ((ArrayList)routers.get(e.exitOrientation)).add(e);
                }
            }
            ArrayList<LaserData> lasers = new ArrayList<LaserData>();
            this.firstPipe = true;
            for (final ForgeDirection dir : routers.keySet()) {
                if (dir == ForgeDirection.UNKNOWN) continue;
                this.handleRouteInDirection(tile, dir, (ArrayList)routers.get(dir), lasers, EnumSet.allOf(PipeRoutingConnectionType.class), new Log(){

                    @Override
                    void log(String log) {
                        if (LPConstants.DEBUG) {
                            System.out.println(dir.name() + ": " + log);
                        }
                    }
                });
            }
            lasers = this.compressLasers(lasers);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingLaserPacket.class).setLasers(lasers), player);
        }
    }

    private void handleRouteInDirection(final LogisticsTileGenericPipe pipe, ForgeDirection dir, ArrayList<ExitRoute> connectedRouters, final List<LaserData> lasers, EnumSet<PipeRoutingConnectionType> connectionType, final Log log) {
        if (LPConstants.DEBUG) {
            log.log("Size: " + connectedRouters.size());
        }
        lasers.add(new LaserData(pipe.field_145851_c, pipe.field_145848_d, pipe.field_145849_e, dir, connectionType).setStartPipe(this.firstPipe));
        this.firstPipe = false;
        HashMap<CoreRoutedPipe, ExitRoute> map = PathFinder.paintAndgetConnectedRoutingPipes(pipe, dir, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH, new IPaintPath(){

            @Override
            public void addLaser(World worldObj, LaserData laser) {
                if (pipe.getWorld() == worldObj) {
                    lasers.add(laser);
                }
            }
        }, connectionType);
        for (CoreRoutedPipe connectedPipe : map.keySet()) {
            IRouter iRouter = connectedPipe.getRouter();
            Iterator<ExitRoute> iRoutes = connectedRouters.iterator();
            while (iRoutes.hasNext()) {
                ExitRoute route = iRoutes.next();
                if (route.destination != iRouter) continue;
                iRoutes.remove();
            }
        }
        HashMap sort = new HashMap();
        for (ExitRoute exitRoute : connectedRouters) {
            ExitRoute result = null;
            CoreRoutedPipe resultPipe = null;
            for (Map.Entry<CoreRoutedPipe, ExitRoute> routeCanidate : map.entrySet()) {
                List<ExitRoute> distances = routeCanidate.getValue().destination.getDistanceTo(exitRoute.destination);
                for (ExitRoute distance : distances) {
                    if (!distance.isSameWay(exitRoute) || result != null && result.distanceToDestination <= distance.distanceToDestination) continue;
                    result = distance;
                    resultPipe = routeCanidate.getKey();
                }
            }
            if (result == null) continue;
            if (!sort.containsKey(resultPipe)) {
                sort.put(resultPipe, new ArrayList());
            }
            if (((ArrayList)sort.get(resultPipe)).contains(result)) continue;
            ((ArrayList)sort.get(resultPipe)).add(result);
        }
        for (Map.Entry entry : sort.entrySet()) {
            HashMap routers = new HashMap();
            for (ExitRoute exit : (ArrayList)entry.getValue()) {
                if (!routers.containsKey(exit.exitOrientation)) {
                    routers.put(exit.exitOrientation, new ArrayList());
                }
                if (((ArrayList)routers.get(exit.exitOrientation)).contains(exit)) continue;
                ((ArrayList)routers.get(exit.exitOrientation)).add(exit);
            }
            for (final ForgeDirection exitDir : routers.keySet()) {
                if (exitDir == ForgeDirection.UNKNOWN) continue;
                this.handleRouteInDirection(((CoreRoutedPipe)entry.getKey()).container, exitDir, (ArrayList)routers.get(exitDir), lasers, map.get(entry.getKey()).connectionDetails, new Log(){

                    @Override
                    void log(String logString) {
                        if (LPConstants.DEBUG) {
                            log.log(exitDir.name() + ": " + logString);
                        }
                    }
                });
            }
        }
    }

    private ArrayList<LaserData> compressLasers(ArrayList<LaserData> lasers) {
        ArrayList<LaserData> options = new ArrayList<LaserData>();
        options.addAll(lasers);
        Iterator<LaserData> iLasers = lasers.iterator();
        while (iLasers.hasNext()) {
            boolean compressed = false;
            LaserData data = iLasers.next();
            LPPosition next = new LPPosition(data.getPosX(), data.getPosY(), data.getPosZ());
            next.moveForward(data.getDir(), data.getLength());
            boolean found = false;
            do {
                found = false;
                Iterator iOptions = options.iterator();
                while (iOptions.hasNext()) {
                    LaserData d = (LaserData)iOptions.next();
                    if (d.getPosX() != next.getX() || d.getPosY() != next.getY() || d.getPosZ() != next.getZ()) continue;
                    if (data.getDir().equals((Object)d.getDir()) && data.getConnectionType().equals(d.getConnectionType())) {
                        data.setLength(data.getLength() + d.getLength());
                        next.moveForward(data.getDir(), d.getLength());
                        found = true;
                        iOptions.remove();
                        lasers.remove(d);
                        compressed = true;
                        continue;
                    }
                    if (!data.getDir().equals((Object)d.getDir())) continue;
                    data.setFinalPipe(false);
                }
            } while (found);
            if (!compressed) continue;
            iLasers = lasers.iterator();
        }
        return lasers;
    }

    @Override
    public ModernPacket template() {
        return new RequestRoutingLasersPacket(this.getId());
    }

    private abstract class Log {
        private Log() {
        }

        abstract void log(String var1);
    }
}

