/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import logisticspipes.interfaces.IClientState;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;

public class PipeTileStatePacket
extends CoordinatesPacket {
    private IClientState renderState;
    private IClientState coreState;
    private IClientState bcPluggableState;
    private IClientState pipe;
    private byte[] bytesRenderState;
    private byte[] bytesCoreState;
    private byte[] bytesBCPluggableState;
    private byte[] bytesPipe;

    public PipeTileStatePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_());
        if (tile == null) {
            return;
        }
        try {
            tile.renderState.readData(new LPDataInputStream(this.bytesRenderState));
            tile.coreState.readData(new LPDataInputStream(this.bytesCoreState));
            tile.bcPlugableState.readData(new LPDataInputStream(this.bytesBCPluggableState));
            tile.afterStateUpdated();
            tile.pipe.readData(new LPDataInputStream(this.bytesPipe));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ModernPacket template() {
        return new PipeTileStatePacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        LPDataOutputStream out = new LPDataOutputStream();
        this.renderState.writeData(out);
        byte[] bytes = out.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
        out = new LPDataOutputStream();
        this.coreState.writeData(out);
        bytes = out.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
        out = new LPDataOutputStream();
        this.bcPluggableState.writeData(out);
        bytes = out.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
        out = new LPDataOutputStream();
        this.pipe.writeData(out);
        bytes = out.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.bytesRenderState = new byte[data.readInt()];
        data.read(this.bytesRenderState);
        this.bytesCoreState = new byte[data.readInt()];
        data.read(this.bytesCoreState);
        this.bytesBCPluggableState = new byte[data.readInt()];
        data.read(this.bytesBCPluggableState);
        this.bytesPipe = new byte[data.readInt()];
        data.read(this.bytesPipe);
    }

    public void setRenderState(IClientState renderState) {
        this.renderState = renderState;
    }

    public void setCoreState(IClientState coreState) {
        this.coreState = coreState;
    }

    public void setBcPluggableState(IClientState bcPluggableState) {
        this.bcPluggableState = bcPluggableState;
    }

    public void setPipe(IClientState pipe) {
        this.pipe = pipe;
    }

    public byte[] getBytesRenderState() {
        return this.bytesRenderState;
    }

    public byte[] getBytesCoreState() {
        return this.bytesCoreState;
    }

    public byte[] getBytesBCPluggableState() {
        return this.bytesBCPluggableState;
    }

    public byte[] getBytesPipe() {
        return this.bytesPipe;
    }
}

