/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.transport.PipeFluidTransportLogistics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class PipeFluidUpdate
extends CoordinatesPacket {
    private FluidStack[] renderCache = new FluidStack[ForgeDirection.values().length];
    private BitSet delta;
    private DataInputStream dataStream;

    public PipeFluidUpdate(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.delta = data.readBitSet();
        this.setDataStream(data);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeBitSet(this.delta);
        for (ForgeDirection dir : ForgeDirection.values()) {
            FluidStack liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                if (liquid != null) {
                    data.writeShort(liquid.fluidID);
                } else {
                    data.writeShort(0);
                }
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            if (liquid != null) {
                data.writeShort(liquid.amount);
                continue;
            }
            data.writeShort(0);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeFluidTransportLogistics)) {
            return;
        }
        this.renderCache = ((PipeFluidTransportLogistics)pipe.pipe.transport).renderCache;
        try {
            for (ForgeDirection dir : ForgeDirection.values()) {
                if (this.renderCache[dir.ordinal()] == null) {
                    this.renderCache[dir.ordinal()] = new FluidStack(0, 0);
                }
                if (this.delta.get(dir.ordinal() * 3 + 0)) {
                    this.renderCache[dir.ordinal()] = new FluidStack((int)this.getDataStream().readShort(), this.renderCache[dir.ordinal()].amount);
                }
                if (this.delta.get(dir.ordinal() * 3 + 1)) {
                    this.renderCache[dir.ordinal()] = new FluidStack(this.renderCache[dir.ordinal()].fluidID, this.renderCache[dir.ordinal()].amount);
                }
                if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
                this.renderCache[dir.ordinal()].amount = dir != ForgeDirection.UNKNOWN ? Math.min(((PipeFluidTransportLogistics)pipe.pipe.transport).getSideCapacity(), this.getDataStream().readShort()) : Math.min(((PipeFluidTransportLogistics)pipe.pipe.transport).getInnerCapacity(), this.getDataStream().readShort());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ModernPacket template() {
        return new PipeFluidUpdate(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    private FluidStack[] getRenderCache() {
        return this.renderCache;
    }

    public PipeFluidUpdate setRenderCache(FluidStack[] renderCache) {
        this.renderCache = renderCache;
        return this;
    }

    private BitSet getDelta() {
        return this.delta;
    }

    public PipeFluidUpdate setDelta(BitSet delta) {
        this.delta = delta;
        return this;
    }

    private DataInputStream getDataStream() {
        return this.dataStream;
    }

    private PipeFluidUpdate setDataStream(DataInputStream dataStream) {
        this.dataStream = dataStream;
        return this;
    }
}

