/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.Integer2CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.ItemAmountPipeSign;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemAmountSignUpdatePacket
extends Integer2CoordinatesPacket {
    private ItemIdentifierStack stack = null;

    public ItemAmountSignUpdatePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
        if (pipe == null) {
            return;
        }
        IPipeSign sign = ((CoreRoutedPipe)pipe.pipe).getPipeSign(ForgeDirection.getOrientation((int)this.getInteger()));
        if (sign == null) {
            return;
        }
        ((ItemAmountPipeSign)sign).amount = this.getInteger2();
        ((ItemAmountPipeSign)sign).itemTypeInv.setInventorySlotContents(0, this.stack);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        if (data.readBoolean()) {
            this.stack = data.readItemIdentifierStack();
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.stack == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeItemIdentifierStack(this.stack);
        }
    }

    @Override
    public ModernPacket template() {
        return new ItemAmountSignUpdatePacket(this.getId());
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public ItemAmountSignUpdatePacket setStack(ItemIdentifierStack stack) {
        this.stack = stack;
        return this;
    }
}

