/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import java.io.IOException;
import logisticspipes.interfaces.IRequestWatcher;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.IntegerCoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;

public class OrdererWatchPacket
extends IntegerCoordinatesPacket {
    private ItemIdentifierStack stack;
    private LinkedLogisticsOrderList orders;

    public OrdererWatchPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeItemIdentifierStack(this.stack);
        data.writeLinkedLogisticsOrderList(this.orders);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.stack = data.readItemIdentifierStack();
        this.orders = data.readLinkedLogisticsOrderList();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile.pipe instanceof IRequestWatcher) {
            ((IRequestWatcher)((Object)tile.pipe)).handleClientSideListInfo(this.getInteger(), this.getStack(), this.getOrders());
        }
    }

    @Override
    public ModernPacket template() {
        return new OrdererWatchPacket(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public OrdererWatchPacket setStack(ItemIdentifierStack stack) {
        this.stack = stack;
        return this;
    }

    public LinkedLogisticsOrderList getOrders() {
        return this.orders;
    }

    public OrdererWatchPacket setOrders(LinkedLogisticsOrderList orders) {
        this.orders = orders;
        return this;
    }
}

