/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.Configs;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.orderer.GuiRequestTable;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ComponentList
extends ModernPacket {
    private Collection<ItemIdentifierStack> used = new ArrayList<ItemIdentifierStack>();
    private Collection<ItemIdentifierStack> missing = new ArrayList<ItemIdentifierStack>();

    public ComponentList(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ComponentList(this.getId());
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiRequestTable) {
            ((GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else {
            for (ItemIdentifierStack item : this.used) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Component: " + item.getFriendlyName()));
            }
            for (ItemIdentifierStack item : this.missing) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Missing: " + item.getFriendlyName()));
            }
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        for (ItemIdentifierStack item : this.used) {
            data.write(1);
            data.writeItemIdentifierStack(item);
        }
        data.write(0);
        for (ItemIdentifierStack item : this.missing) {
            data.write(1);
            data.writeItemIdentifierStack(item);
        }
        data.write(0);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        while (data.read() != 0) {
            this.used.add(data.readItemIdentifierStack());
        }
        while (data.read() != 0) {
            this.missing.add(data.readItemIdentifierStack());
        }
    }

    public Collection<ItemIdentifierStack> getUsed() {
        return this.used;
    }

    public ComponentList setUsed(Collection<ItemIdentifierStack> used) {
        this.used = used;
        return this;
    }

    public Collection<ItemIdentifierStack> getMissing() {
        return this.missing;
    }

    public ComponentList setMissing(Collection<ItemIdentifierStack> missing) {
        this.missing = missing;
        return this;
    }
}

