/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.ticks.DebugGuiTickHandler;
import net.minecraft.entity.player.EntityPlayer;

public class DebugTypePacket
extends ModernPacket {
    public DebugGuiTickHandler.VarType toTransmit;
    public Integer[] pos = new Integer[0];

    public DebugTypePacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        int arraySize = data.readInt();
        byte[] bytes = new byte[arraySize];
        data.read(bytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        in = new ObjectInputStream(bis);
        try {
            this.toTransmit = (DebugGuiTickHandler.VarType)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
        int size = data.readInt();
        this.pos = new Integer[size];
        for (int i = 0; i < size; ++i) {
            this.pos[i] = data.readInt();
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        try {
            DebugGuiTickHandler.instance().handleServerGuiSetting(this.toTransmit, this.pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.getToTransmit());
        byte[] bytes = bos.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
        data.writeInt(this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            data.writeInt(this.pos[i]);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugTypePacket(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public DebugGuiTickHandler.VarType getToTransmit() {
        return this.toTransmit;
    }

    public DebugTypePacket setToTransmit(DebugGuiTickHandler.VarType toTransmit) {
        this.toTransmit = toTransmit;
        return this;
    }

    public Integer[] getPos() {
        return this.pos;
    }

    public DebugTypePacket setPos(Integer[] pos) {
        this.pos = pos;
        return this;
    }
}

