/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.ticks.DebugGuiTickHandler;
import net.minecraft.entity.player.EntityPlayer;

public class DebugSetVarContent
extends ModernPacket {
    private String content;
    private Integer[] path;

    public DebugSetVarContent(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.content = data.readUTF();
        int size = data.readInt();
        this.path = new Integer[size];
        for (int i = 0; i < size; ++i) {
            this.path[i] = data.readInt();
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        try {
            DebugGuiTickHandler.instance().handleVarChangePacket(this.path, this.content, player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeUTF(this.content);
        data.writeInt(this.path.length);
        for (int i = 0; i < this.path.length; ++i) {
            data.writeInt(this.path[i]);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugSetVarContent(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public String getContent() {
        return this.content;
    }

    public DebugSetVarContent setContent(String content) {
        this.content = content;
        return this;
    }

    public Integer[] getPath() {
        return this.path;
    }

    public DebugSetVarContent setPath(Integer[] path) {
        this.path = path;
        return this;
    }
}

