/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class CoordinatesPacket
extends ModernPacket {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
    }

    public CoordinatesPacket setTilePos(TileEntity tile) {
        this.setPosX(tile.field_145851_c);
        this.setPosY(tile.field_145848_d);
        this.setPosZ(tile.field_145849_e);
        return this;
    }

    public CoordinatesPacket setPacketPos(CoordinatesPacket packet) {
        this.posX = packet.posX;
        this.posY = packet.posY;
        this.posZ = packet.posZ;
        return this;
    }

    public <T> T getTile(World world, Class<T> clazz) {
        if (world == null) {
            this.targetNotFound("World was null");
            return null;
        }
        if (!world.func_72899_e(this.getPosX(), this.getPosY(), this.getPosZ())) {
            this.targetNotFound("Couldn't find " + clazz.getName());
            return null;
        }
        TileEntity tile = world.func_147438_o(this.getPosX(), this.getPosY(), this.getPosZ());
        if (tile != null) {
            if (!clazz.isAssignableFrom(tile.getClass())) {
                this.targetNotFound("Couldn't find " + clazz.getName() + ", found " + tile.getClass());
                return null;
            }
        } else {
            this.targetNotFound("Couldn't find " + clazz.getName());
        }
        return (T)tile;
    }

    public LogisticsTileGenericPipe getPipe(World world) {
        return this.getPipe(world, LTGPCompletionCheck.NONE);
    }

    public LogisticsTileGenericPipe getPipe(World world, LTGPCompletionCheck check) {
        LogisticsTileGenericPipe pipe = this.getTile(world, LogisticsTileGenericPipe.class);
        if ((check == LTGPCompletionCheck.PIPE || check == LTGPCompletionCheck.TRANSPORT) && pipe.pipe == null) {
            this.targetNotFound("The found pipe didn't have a loaded pipe field");
        }
        if (check == LTGPCompletionCheck.TRANSPORT && pipe.pipe.transport == null) {
            this.targetNotFound("The found pipe didn't have a loaded transport field");
        }
        return pipe;
    }

    protected void targetNotFound(String message) {
        throw new TargetNotFoundException(message, this);
    }

    public String toString() {
        return "CoordinatesPacket(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesPacket setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesPacket setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesPacket setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }

    public static enum LTGPCompletionCheck {
        NONE,
        PIPE,
        TRANSPORT;

    }
}

