/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import logisticspipes.gui.hud.modules.HUDSimpleFilterModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.modules.abstractmodules.LogisticsSimpleFilterModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModulePassiveSupplier
extends LogisticsSimpleFilterModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Requested items", 64);
    private IHUDModuleRenderer HUD = new HUDSimpleFilterModule(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.PassiveSupplier, 0, true, false, 2, 0);

    public ModulePassiveSupplier() {
        this._filterInventory.addListener(this);
    }

    @Override
    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        int haveCount;
        if (bestPriority > ModulePassiveSupplier._sinkReply.fixedPriority.ordinal() || bestPriority == ModulePassiveSupplier._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModulePassiveSupplier._sinkReply.customPriority) {
            return null;
        }
        IInventoryUtil targetUtil = this._service.getSneakyInventory(false);
        if (targetUtil == null) {
            return null;
        }
        if (!this._filterInventory.containsItem(item)) {
            return null;
        }
        int targetCount = this._filterInventory.itemCount(item);
        if (targetCount <= (haveCount = targetUtil.itemCount(item))) {
            return null;
        }
        if (this._service.canUseEnergy(2)) {
            return new SinkReply(_sinkReply, targetCount - haveCount);
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer(this._world.getWorld())) {
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        Map<ItemIdentifier, Integer> mapIC = this._filterInventory.getItemsAndCount();
        ArrayList<ItemIdentifier> li = new ArrayList<ItemIdentifier>(mapIC.size());
        li.addAll(mapIC.keySet());
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModulePassiveSupplier");
    }
}

