/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.gui.hud.modules.HUDOreDictItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.module.inhand.OreDictItemSinkModuleInHand;
import logisticspipes.network.guis.module.inpipe.OreDictItemSinkModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.OreDictItemSinkList;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleOreDictItemSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    public final List<String> oreList = new LinkedList<String>();
    private Map<Item, Set<Integer>> oreItemIdMap;
    private IHUDModuleRenderer HUD = new HUDOreDictItemSink(this);
    private List<ItemIdentifierStack> oreHudList;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.OreDictItemSink, 0, true, false, 5, 0);

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        Set<Integer> damageSet;
        if (bestPriority > ModuleOreDictItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleOreDictItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleOreDictItemSink._sinkReply.customPriority) {
            return null;
        }
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        if ((damageSet = this.oreItemIdMap.get(item.item)) == null) {
            return null;
        }
        if (damageSet.isEmpty() || damageSet.contains(item.itemDamage)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return NewGuiHandler.getGui(OreDictItemSinkModuleSlot.class).setNbt(nbt);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(OreDictItemSinkModuleInHand.class);
    }

    public List<ItemIdentifierStack> getHudItemList() {
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        return this.oreHudList;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    private void buildOreItemIdMap() {
        this.oreItemIdMap = new HashMap<Item, Set<Integer>>();
        this.oreHudList = new ArrayList<ItemIdentifierStack>(this.oreList.size());
        for (String orename : this.oreList) {
            ArrayList items = OreDictionary.getOres((String)orename);
            ItemStack stackForHud = null;
            for (ItemStack stack : items) {
                if (stack == null) continue;
                if (stackForHud == null) {
                    stackForHud = stack;
                }
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    this.oreItemIdMap.put(stack.func_77973_b(), new TreeSet());
                    continue;
                }
                Set<Integer> damageSet = this.oreItemIdMap.get(stack.func_77973_b());
                if (damageSet == null) {
                    damageSet = new TreeSet<Integer>();
                    damageSet.add(stack.func_77960_j());
                    this.oreItemIdMap.put(stack.func_77973_b(), damageSet);
                    continue;
                }
                if (damageSet.isEmpty()) continue;
                damageSet.add(stack.func_77960_j());
            }
            if (stackForHud != null) {
                ItemStack t = stackForHud.func_77946_l();
                if (t.func_77960_j() == Short.MAX_VALUE) {
                    t.func_77964_b(0);
                }
                this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(t), 1));
                continue;
            }
            this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(Item.func_150898_a((Block)Blocks.field_150480_ab), 0, null), 1));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.oreList.clear();
        int limit = nbttagcompound.func_74762_e("listSize");
        for (int i = 0; i < limit; ++i) {
            String oreName = nbttagcompound.func_74779_i("Ore" + i);
            if (oreName.equals("")) continue;
            this.oreList.add(nbttagcompound.func_74779_i("Ore" + i));
        }
        this.oreItemIdMap = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("listSize", this.oreList.size());
        for (int i = 0; i < this.oreList.size(); ++i) {
            nbttagcompound.func_74778_a("Ore" + i, this.oreList.get(i));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Ores: ");
        list.addAll(this.oreList);
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void OreListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(OreDictItemSinkList.class).setTag(nbt).setModulePos(this));
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleOreDictItemSink");
    }
}

