/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.gui.hud.modules.HUDElectricManager;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.module.inhand.ElectricModuleInHand;
import logisticspipes.network.guis.module.inpipe.ElectricModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ElectricManagetMode;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleElectricManager
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Electric Items", 1);
    private boolean _dischargeMode;
    private int ticksToAction = 100;
    private int currentTick = 0;
    private IHUDModuleRenderer HUD = new HUDElectricManager(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricManager, 0, true, false, 1, 1);

    public ModuleElectricManager() {
        this._filterInventory.addListener(this);
    }

    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDischargeMode() {
        return this._dischargeMode;
    }

    public void setDischargeMode(boolean isDischargeMode) {
        this._dischargeMode = isDischargeMode;
        if (!this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ElectricManagetMode.class).setFlag(this.isDischargeMode()).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stackID, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricManager.ordinal()) {
            return null;
        }
        if (!this._service.canUseEnergy(1)) {
            return null;
        }
        ItemStack stack = stackID.makeNormalStack(1);
        if (this.isOfInterest(stack)) {
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyCharged(stack)) {
                return this._sinkReply;
            }
            if (!this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                return this._sinkReply;
            }
            if (SimpleServiceLocator.IC2Proxy.isPartiallyCharged(stack)) {
                return this._sinkReply;
            }
        }
        return null;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ElectricModuleSlot.class).setFlag(this.isDischargeMode());
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ElectricModuleInHand.class);
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDischargeMode(nbttagcompound.func_74767_n("discharge"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("discharge", this.isDischargeMode());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction) {
            return;
        }
        this.currentTick = 0;
        IInventoryUtil inv = this._service.getSneakyInventory(true);
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            Triplet<Integer, SinkReply, List<IFilter>> reply;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) {
                return;
            }
            if (!this.isOfInterest(stack)) continue;
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._service.getSourceID(), true, SinkReply.FixedPriority.ElectricBuffer);
                if (reply == null) continue;
                if (this._service.useEnergy(10)) {
                    this._service.spawnParticle(Particles.OrangeParticle, 2);
                    this._service.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
                    return;
                }
            }
            if (this._dischargeMode || !SimpleServiceLocator.IC2Proxy.isFullyCharged(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._service.getSourceID(), true, SinkReply.FixedPriority.ElectricBuffer)) == null || !this._service.useEnergy(10)) continue;
            this._service.spawnParticle(Particles.OrangeParticle, 2);
            this._service.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    private boolean isOfInterest(ItemStack stack) {
        if (!SimpleServiceLocator.IC2Proxy.isElectricItem(stack)) {
            return false;
        }
        for (int i = 0; i < this._filterInventory.func_70302_i_(); ++i) {
            ItemStack fStack = this._filterInventory.func_70301_a(i);
            if (fStack == null || !SimpleServiceLocator.IC2Proxy.isSimilarElectricItem(stack, fStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mode: " + (this.isDischargeMode() ? "Discharge Items" : "Charge Items"));
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ElectricManagetMode.class).setFlag(this.isDischargeMode()).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer(this._world.getWorld())) {
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleElectricManager");
    }
}

