/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.utils.SinkReply;
import net.minecraftforge.common.util.ForgeDirection;

public class ChassiTransportLayer
extends TransportLayer {
    private final PipeLogisticsChassi _chassiPipe;

    public ChassiTransportLayer(PipeLogisticsChassi chassiPipe) {
        this._chassiPipe = chassiPipe;
    }

    @Override
    public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection blocked) {
        if (item.getItemIdentifierStack() != null) {
            this._chassiPipe.recievedItem(item.getItemIdentifierStack().getStackSize());
        }
        return this._chassiPipe.getPointedOrientation();
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        LogisticsModule module = this._chassiPipe.getLogisticsModule();
        if (module == null) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (!this._chassiPipe.isEnabled()) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        SinkReply reply = module.sinksItem(item.getItemIdentifierStack().getItem(), -1, 0, true, false);
        if (reply == null) {
            this._chassiPipe.notifyOfItemArival(item.getInfo());
            return false;
        }
        if (reply.maxNumberOfItems != 0 && item.getItemIdentifierStack().getStackSize() > reply.maxNumberOfItems) {
            ForgeDirection o = this._chassiPipe.getPointedOrientation();
            if (o == null || o == ForgeDirection.UNKNOWN) {
                o = ForgeDirection.UP;
            }
            item.split(reply.maxNumberOfItems, o);
        }
        return true;
    }
}

