/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class RequestMonitorPopup
extends SubGuiScreen {
    private static final ResourceLocation achievementTextures = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private final PipeBlockRequestTable _table;
    private final int orderId;
    private final RenderItem renderitem = new RenderItem();
    private int isMouseButtonDown;
    private int mouseX;
    private int mouseY;
    private double guiMapX;
    private double guiMapY;
    private int minY = -230;
    private int maxY = 0;
    private int minX = -800;
    private int maxX = 800;
    private ZOOM_LEVEL zoom = ZOOM_LEVEL.NORMAL;
    private Object[] tooltip = null;

    public RequestMonitorPopup(PipeBlockRequestTable table, int orderId) {
        super(256, 202, 0, 0);
        this._table = table;
        this.orderId = orderId;
        this.guiMapY = -200.0;
        Mouse.getDWheel();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 74, 80, 20, "Close"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 10, this.field_146295_m / 2 + 74, 80, 20, "Save as Image"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.exitGui();
        } else if (button.field_146127_k == 1) {
            this.saveTreeToImage();
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        int dWheel;
        if (!this._table.watchedRequests.containsKey(this.orderId)) {
            this.exitGui();
            return;
        }
        if (Mouse.isButtonDown((int)0)) {
            int k = (this.field_146294_l - this.xSize) / 2;
            int l = (this.field_146295_m - this.ySize) / 2;
            int i1 = k + 8;
            int j1 = l + 17;
            if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && par1 >= i1 && par1 < i1 + 224 && par2 >= j1 && par2 < j1 + 155) {
                if (this.isMouseButtonDown == 0) {
                    this.isMouseButtonDown = 1;
                } else {
                    this.guiMapX -= (double)(par1 - this.mouseX) * 1.0 / (double)this.zoom.zoom;
                    this.guiMapY -= (double)(par2 - this.mouseY) * 1.0 / (double)this.zoom.zoom;
                }
                this.mouseX = par1;
                this.mouseY = par2;
            }
        } else {
            this.isMouseButtonDown = 0;
        }
        if (this.guiMapY < (double)this.minY) {
            this.guiMapY = this.minY;
        }
        if (this.guiMapY > (double)this.maxY) {
            this.guiMapY = this.maxY;
        }
        if (this.guiMapX > (double)this.maxX) {
            this.guiMapX = this.maxX;
        }
        if (this.guiMapX < (double)this.minX) {
            this.guiMapX = this.minX;
        }
        if ((dWheel = Mouse.getDWheel()) < 0) {
            this.zoom = this.zoom.next();
        } else if (dWheel > 0) {
            this.zoom = this.zoom.prev();
        }
        this.createBoundary();
        this.drawTransparentBack();
        this.drawMap(par1, par2);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        super.func_73863_a(par1, par2, par3);
        if (this.tooltip != null) {
            BasicGuiHelper.displayItemToolTip(this.tooltip, this.field_73735_i, this.guiLeft, this.guiTop, false, true);
        }
    }

    private void createBoundary() {
        int size = this._table.watchedRequests.get(this.orderId).getValue2().getTreeRootSize();
        this.minX = -size * 20 + (int)(75.0f * this.zoom.zoom);
        this.maxX = -this.minX + this.zoom.maxX;
        this.maxY = -100;
        this.findLowest(this._table.watchedRequests.get(this.orderId).getValue2(), -200);
    }

    private void drawTransparentBack() {
        GL11.glEnable((int)2929);
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, 0);
    }

    private void findLowest(LinkedLogisticsOrderList list, int lowerLimit) {
        lowerLimit += 48;
        for (LinkedLogisticsOrderList sub : list.getSubOrders()) {
            this.findLowest(sub, lowerLimit);
        }
        if ((float)this.maxY < (float)(lowerLimit + 10) * this.zoom.zoom) {
            this.maxY = (int)((float)(lowerLimit + 10) * this.zoom.zoom) + this.zoom.maxY;
        }
    }

    private void saveTreeToImage() {
        int useWidth = this.field_146297_k.field_71443_c;
        int useHeight = this.field_146297_k.field_71440_d;
        int left = this.minX - this.field_146294_l / 2;
        int top = this.minY;
        int right = this.maxX - this.field_146294_l / 2;
        int bottom = this.maxY;
        int k = useWidth * useHeight;
        IntBuffer pixels = BufferUtils.createIntBuffer((int)k);
        int[] intArray = new int[k];
        int imgPosX = 0;
        int imgPosY = 0;
        for (int x = left; x < right + this.field_146294_l; x += this.field_146294_l) {
            imgPosY = 0;
            for (int y = top; y < bottom + this.field_146295_m; y += this.field_146295_m) {
                imgPosY += useHeight;
            }
            imgPosX += useWidth;
        }
        BufferedImage bufferedimage = new BufferedImage(imgPosX, imgPosY, 1);
        imgPosX = 0;
        imgPosY = 0;
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        this.field_146297_k.field_71460_t.func_78478_c();
        this.drawForSreenShot(0, 0);
        for (int x = left; x < right + this.field_146294_l; x += this.field_146294_l) {
            imgPosY = 0;
            for (int y = top; y < bottom + this.field_146295_m; y += this.field_146295_m) {
                GL11.glClear((int)16640);
                this.field_146297_k.field_71460_t.func_78478_c();
                this.drawForSreenShot(y, x);
                pixels.clear();
                GL11.glReadPixels((int)0, (int)0, (int)useWidth, (int)useHeight, (int)32993, (int)33639, (IntBuffer)pixels);
                pixels.get(intArray);
                RequestMonitorPopup.mirror(intArray, useWidth, useHeight);
                bufferedimage.setRGB(imgPosX, imgPosY, Math.min(useWidth, bufferedimage.getWidth() - imgPosX), Math.min(useHeight, bufferedimage.getHeight() - imgPosY), intArray, 0, useWidth);
                imgPosY += useHeight;
            }
            imgPosX += useWidth;
        }
        this.saveImage(bufferedimage);
    }

    private void saveImage(BufferedImage bufferedimage) {
        File screenShotsFolder = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        String s = dateFormat.format(new Date()).toString();
        int i = 1;
        while (true) {
            File canidate;
            if (!(canidate = new File(screenShotsFolder, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
                try {
                    ImageIO.write((RenderedImage)bufferedimage, "png", canidate);
                    Minecraft.func_71410_x().field_71439_g.func_71165_d("Saved tree view as " + canidate.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            ++i;
        }
    }

    private static void mirror(int[] par0ArrayOfInteger, int width, int height) {
        int[] aint1 = new int[width];
        int k = height / 2;
        for (int l = 0; l < k; ++l) {
            System.arraycopy(par0ArrayOfInteger, l * width, aint1, 0, width);
            System.arraycopy(par0ArrayOfInteger, (height - 1 - l) * width, par0ArrayOfInteger, l * width, width);
            System.arraycopy(aint1, 0, par0ArrayOfInteger, (height - 1 - l) * width, width);
        }
    }

    private void drawForSreenShot(int top, int left) {
        left *= -1;
        top *= -1;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
        RequestMonitorPopup.func_73734_a((int)0, (int)0, (int)10000, (int)10000, (int)-16777216);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        int yVar = 0;
        while (yVar * 16 < this.field_146295_m) {
            int xVar = 0;
            while (xVar * 16 < this.field_146294_l) {
                IIcon icon = Blocks.field_150348_b.func_149691_a(0, 0);
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.func_94065_a(xVar * 16, yVar * 16, icon, 16, 16);
                ++xVar;
            }
            ++yVar;
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)600.0);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3553);
        LinkedLogisticsOrderList list = this._table.watchedRequests.get(this.orderId).getValue2();
        if (!list.isEmpty()) {
            this.func_73728_b(left + 8, top + 0, top + 17, -16711936);
        }
        this.renderLinkedOrderListLines(list, left, top + 17);
        for (Float progress : list.getProgresses()) {
            int pos = (int)(29.0f * progress.floatValue());
            this.drawProgressPoint(left + 8, top + pos, -16711936);
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        String s = Integer.toString(this.orderId);
        if (!list.isEmpty()) {
            this.func_73729_b(left - 5, top - 40 + 17, 0, 202, 26, 26);
            this.field_146297_k.field_71466_p.func_78261_a(s, left + 9 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, top - 30 + 17, 0xFFFFFF);
        } else {
            this.func_73729_b(left - 5, top - 18 + 17, 0, 202, 26, 26);
            this.field_146297_k.field_71466_p.func_78261_a(s, left + 9 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, top - 18 + 10 + 17, 0xFFFFFF);
        }
        this.renderLinkedOrderListItems(list, left, top + 17, 0, 0);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74518_a();
    }

    private void drawMap(int par1, int par2) {
        this.tooltip = null;
        int mapX = MathHelper.func_76128_c((double)this.guiMapX);
        int mapY = MathHelper.func_76128_c((double)(this.guiMapY - (double)this.zoom.moveY));
        int leftSide = (this.field_146294_l - this.xSize) / 2;
        int topSide = (this.field_146295_m - this.ySize) / 2;
        this.guiTop = (int)((float)this.guiTop * (1.0f / this.zoom.zoom));
        this.guiLeft = (int)((float)this.guiLeft * (1.0f / this.zoom.zoom));
        this.xSize = (int)((float)this.xSize * (1.0f / this.zoom.zoom));
        this.ySize = (int)((float)this.ySize * (1.0f / this.zoom.zoom));
        leftSide = (int)((float)leftSide * (1.0f / this.zoom.zoom));
        topSide = (int)((float)topSide * (1.0f / this.zoom.zoom));
        par1 = (int)((float)par1 * (1.0f / this.zoom.zoom));
        par2 = (int)((float)par2 * (1.0f / this.zoom.zoom));
        int innerLeftSide = leftSide + 16;
        int innerTopSide = topSide + 17;
        this.field_73735_i = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        this.func_73729_b(leftSide, topSide, 0, 0, this.xSize, this.ySize);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.zoom.zoom, (float)this.zoom.zoom, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        int moveBackgroundX = (mapX - this.minX) % 16;
        int moveBackgroundY = (mapY - this.minY) % 16;
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        int yVar = 0;
        while (yVar * 16 - moveBackgroundY < this.zoom.bottomRenderBorder) {
            int xVar = 0;
            while (xVar * 16 - moveBackgroundX < this.zoom.rightRenderBorder) {
                IIcon icon = Blocks.field_150348_b.func_149691_a(0, 0);
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.func_94065_a(innerLeftSide + xVar * 16 - moveBackgroundX, innerTopSide + yVar * 16 - moveBackgroundY, icon, 16, 16);
                ++xVar;
            }
            ++yVar;
        }
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3553);
        LinkedLogisticsOrderList list = this._table.watchedRequests.get(this.orderId).getValue2();
        if (!list.isEmpty()) {
            this.func_73728_b(innerLeftSide - mapX + 110, innerTopSide - mapY - 197, innerTopSide - mapY - 180, -16711936);
        }
        this.renderLinkedOrderListLines(list, innerLeftSide - mapX + 102, innerTopSide - mapY - 180);
        for (Float progress : list.getProgresses()) {
            int pos = (int)(29.0f * progress.floatValue());
            this.drawProgressPoint(innerLeftSide - mapX + 110, innerTopSide - mapY - 197 + pos, -16711936);
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        String s = Integer.toString(this.orderId);
        if (!list.isEmpty()) {
            this.func_73729_b(innerLeftSide - mapX + 97, innerTopSide - mapY - 220, 0, 202, 26, 26);
            this.field_146297_k.field_71466_p.func_78261_a(s, innerLeftSide - mapX + 111 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, innerTopSide - mapY - 210, 0xFFFFFF);
        } else {
            this.func_73729_b(innerLeftSide - mapX + 97, innerTopSide - mapY - 162, 0, 202, 26, 26);
            this.field_146297_k.field_71466_p.func_78261_a(s, innerLeftSide - mapX + 111 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, innerTopSide - mapY - 152, 0xFFFFFF);
        }
        this.renderLinkedOrderListItems(list, innerLeftSide - mapX + 102, innerTopSide - mapY - 180, par1, par2);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        this.guiTop = (int)((float)this.guiTop * this.zoom.zoom);
        this.guiLeft = (int)((float)this.guiLeft * this.zoom.zoom);
        this.xSize = (int)((float)this.xSize * this.zoom.zoom);
        this.ySize = (int)((float)this.ySize * this.zoom.zoom);
        leftSide = (int)((float)leftSide * this.zoom.zoom);
        topSide = (int)((float)topSide * this.zoom.zoom);
        GL11.glScalef((float)(1.0f / this.zoom.zoom), (float)(1.0f / this.zoom.zoom), (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
        this.func_73729_b(leftSide, topSide, 0, 0, this.xSize, this.ySize);
        GL11.glPopMatrix();
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74518_a();
    }

    private void renderLinkedOrderListItems(LinkedLogisticsOrderList list, int xPos, int yPos, int par1, int par2) {
        int i;
        int size = list.size();
        int startLeft = -(size - 1) * 15 + xPos;
        yPos += 13;
        for (i = 0; i < list.size(); ++i) {
            if (((IOrderInfoProvider)list.get(i)).isInProgress()) {
                GL11.glColor4f((float)0.1f, (float)0.9f, (float)0.1f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            GL11.glEnable((int)2896);
            this.field_146297_k.func_110434_K().func_110577_a(achievementTextures);
            this.func_73729_b(startLeft - 5, yPos - 5, 0, 202, 26, 26);
            GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            this.renderItemAt(((IOrderInfoProvider)list.get(i)).getItem(), startLeft, yPos);
            if (((IOrderInfoProvider)list.get(i)).isInProgress() && ((IOrderInfoProvider)list.get(i)).getMachineProgress() != 0) {
                RequestMonitorPopup.func_73734_a((int)(startLeft - 4), (int)(yPos + 20), (int)(startLeft + 20), (int)(yPos + 24), (int)-16777216);
                RequestMonitorPopup.func_73734_a((int)(startLeft - 3), (int)(yPos + 21), (int)(startLeft + 19), (int)(yPos + 23), (int)-1);
                RequestMonitorPopup.func_73734_a((int)(startLeft - 3), (int)(yPos + 21), (int)(startLeft - 3 + 22 * ((IOrderInfoProvider)list.get(i)).getMachineProgress() / 100), (int)(yPos + 23), (int)-65536);
            }
            if (startLeft - 10 < par1 && par1 < startLeft + 20 && yPos - 6 < par2 && par2 < yPos + 20 && this.guiLeft < par1 && par1 < this.guiLeft + this.xSize - 16 && this.guiTop < par2 && par2 < this.guiTop + this.ySize - 16) {
                IOrderInfoProvider order = (IOrderInfoProvider)list.get(i);
                ArrayList<String> tooltipList = new ArrayList<String>();
                tooltipList.add((Object)((Object)ChatColor.BLUE) + "Request Type: " + (Object)((Object)ChatColor.YELLOW) + order.getType().name());
                tooltipList.add((Object)((Object)ChatColor.BLUE) + "Send to Router ID: " + (Object)((Object)ChatColor.YELLOW) + order.getRouterId());
                this.tooltip = new Object[]{(int)((float)par1 * this.zoom.zoom - 10.0f), (int)((float)par2 * this.zoom.zoom), order.getItem().makeNormalStack(), true, tooltipList};
            }
            startLeft += 30;
        }
        startLeft = xPos + 20 - list.getSubTreeRootSize() * 20;
        if (!list.getSubOrders().isEmpty()) {
            for (i = 0; i < list.getSubOrders().size(); ++i) {
                this.renderLinkedOrderListItems(list.getSubOrders().get(i), (startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20) - 20, yPos + 48, par1, par2);
                startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20;
            }
        }
    }

    private void renderLinkedOrderListLines(LinkedLogisticsOrderList list, int xPos, int yPos) {
        int i;
        int size = list.size();
        if (list.isEmpty()) {
            size = 1;
        }
        int startLeft = -(size - 1) * 15 + xPos;
        yPos += 13;
        int left = startLeft;
        for (i = 0; i < list.size(); ++i) {
            this.func_73728_b(startLeft + 8, yPos - 13, yPos - 3, -16711936);
            if (!list.getSubOrders().isEmpty()) {
                this.func_73728_b(startLeft + 8, yPos + 18, yPos + 28, -16711936);
            }
            startLeft += 30;
        }
        if (!list.isEmpty()) {
            this.func_73730_a(left + 8, startLeft - 22, yPos - 13, -16711936);
        }
        if (!list.getSubOrders().isEmpty()) {
            if (!list.isEmpty()) {
                this.func_73730_a(left + 8, startLeft - 22, yPos + 28, -16711936);
                startLeft -= 30;
            }
            this.func_73728_b(left + (startLeft - left) / 2 + 8, yPos + 28, yPos + 38, -16711936);
            left = startLeft = xPos + 20 - list.getSubTreeRootSize() * 20;
            for (i = 0; i < list.getSubOrders().size(); ++i) {
                this.func_73728_b((startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20) - 12, yPos + 38, yPos + 48, -16711936);
                this.drawPointFor(list, xPos, yPos, i, startLeft);
                this.renderLinkedOrderListLines(list.getSubOrders().get(i), startLeft - 20, yPos + 48);
                startLeft += list.getSubOrders().get(i).getTreeRootSize() * 20;
            }
            if (!list.getSubOrders().isEmpty()) {
                left += list.getSubOrders().get(0).getTreeRootSize() * 20;
                startLeft -= list.getSubOrders().get(list.getSubOrders().size() - 1).getTreeRootSize() * 20;
            }
            this.func_73730_a(left - 12, startLeft - 12, yPos + 38, -16711936);
        }
    }

    private void drawPointFor(LinkedLogisticsOrderList list, int xPos, int yPos, int i, int startLeft) {
        float totalLine = 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10;
        for (Float point : list.getSubOrders().get(i).getProgresses()) {
            int j;
            int newStartLeft;
            int newSize;
            int pos = (int)(totalLine * (1.0f - point.floatValue()));
            if (pos < 13) {
                newSize = list.getSubOrders().get(i).size();
                newStartLeft = -(newSize - 1) * 15 + startLeft - 20;
                for (j = 0; j < newSize; ++j) {
                    this.drawProgressPoint(newStartLeft + 8, yPos + 48 + 12 - pos, -16711936);
                    newStartLeft += 30;
                }
                continue;
            }
            if (pos < 22) {
                this.drawProgressPoint(startLeft - 20 + 8, yPos + 38 + 12 - (pos -= 10), -16711936);
                continue;
            }
            if (pos < Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1) {
                pos -= 22;
                if (startLeft < xPos + 20) {
                    pos *= -1;
                }
                this.drawProgressPoint(startLeft - 12 - pos, yPos + 38, -16711936);
                continue;
            }
            if (pos < Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1 + 10 + 1) {
                this.drawProgressPoint(xPos + 8, yPos + 27 - (pos -= 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1), -16711936);
                continue;
            }
            if (pos >= Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1 + 10 + 1 + 10 + 1) continue;
            pos -= 22 + Math.abs(startLeft - (xPos + 20)) + 10 + 1 + 10 + 1;
            newSize = list.size();
            newStartLeft = -(newSize - 1) * 15 + xPos;
            for (j = 0; j < newSize; ++j) {
                this.drawProgressPoint(newStartLeft + 8, yPos + 16 - pos, -16711936);
                newStartLeft += 30;
            }
        }
    }

    private void renderItemAt(ItemIdentifierStack item, int x, int y) {
        this.renderitem.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), item.makeNormalStack(), x, y);
        if (this.guiLeft < x && x < this.guiLeft + this.xSize - 16 && this.guiTop < y && y < this.guiTop + this.ySize - 16) {
            this.renderitem.func_94148_a(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, item.makeNormalStack(), x, y, "");
            String s = StringUtil.getFormatedStackSize(item.getStackSize());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.renderitem.field_77023_b = 0.0f;
            this.field_146297_k.field_71466_p.func_78261_a(s, x + 17 - this.field_146297_k.field_71466_p.func_78256_a(s), y + 9, 0xFFFFFF);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)2896);
        }
    }

    protected void func_73730_a(int par1, int par2, int par3, int par4) {
        if (par2 < par1) {
            int i1 = par1;
            par1 = par2;
            par2 = i1;
        }
        int line = this.zoom.line;
        RequestMonitorPopup.func_73734_a((int)par1, (int)par3, (int)(par2 + 1), (int)(par3 + line), (int)par4);
    }

    protected void func_73728_b(int par1, int par2, int par3, int par4) {
        if (par3 < par2) {
            int i1 = par2;
            par2 = par3;
            par3 = i1;
        }
        int line = this.zoom.line;
        RequestMonitorPopup.func_73734_a((int)par1, (int)(par2 + 1), (int)(par1 + line), (int)par3, (int)par4);
    }

    protected void drawProgressPoint(int x, int y, int color) {
        int line = this.zoom.line + 1;
        RequestMonitorPopup.func_73734_a((int)(x - line + 1), (int)(y - line + 1), (int)(x + line), (int)(y + line), (int)color);
    }

    private static enum ZOOM_LEVEL {
        NORMAL(1.0f, 165, 224, 1, 0, 0, 0),
        LEVEL_1(0.5f, 330, 465, 1, 50, -200, 100),
        LEVEL_2(0.25f, 660, 950, 2, 100, -400, -100);

        final float zoom;
        final int bottomRenderBorder;
        final int rightRenderBorder;
        final int line;
        final int moveY;
        final int maxX;
        final int maxY;

        private ZOOM_LEVEL(float zoom, int bottom, int right, int line, int moveY, int maxX, int maxY) {
            this.zoom = zoom;
            this.bottomRenderBorder = bottom;
            this.rightRenderBorder = right;
            this.line = line;
            this.moveY = moveY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        ZOOM_LEVEL next() {
            int id = this.ordinal();
            if (id + 1 >= ZOOM_LEVEL.values().length) {
                return this;
            }
            return ZOOM_LEVEL.values()[id + 1];
        }

        ZOOM_LEVEL prev() {
            int id = this.ordinal();
            if (id - 1 < 0) {
                return this;
            }
            return ZOOM_LEVEL.values()[id - 1];
        }
    }
}

