/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IPowerLevelDisplay;
import logisticspipes.utils.gui.BasicGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class HUDPowerLevel
extends BasicHUDGui
implements IHeadUpDisplayRenderer {
    private final IPowerLevelDisplay junction;
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/power_junction.png");

    public HUDPowerLevel(IPowerLevelDisplay junction) {
        this.junction = junction;
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, Minecraft mc, IHUDConfig config) {
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)32);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)32);
        }
        BasicGuiHelper.drawGuiBackGround(mc, -60, -40, 60, 40, 0.0f, false);
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
        super.renderHeadUpDisplay(distance, day, mc, config);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
        mc.field_71446_o.func_110577_a(TEXTURE);
        this.drawTexturedModalRect(-50, -30, 9, 10, 7, 61);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
        int level = 100 - this.junction.getChargeState();
        this.drawTexturedModalRect(-49, -29 + level * 59 / 100, 176, level * 59 / 100, 5, 59 - level * 59 / 100);
        mc.field_71466_p.func_78276_b("Stored Energy:", -30, -15, 0x404040);
        mc.field_71466_p.func_78276_b(BasicGuiHelper.getStringWithSpacesFromInteger(this.junction.getDisplayPowerLevel()) + " " + this.junction.getBrand(), -30, -5, 0x404040);
        mc.field_71466_p.func_78276_b("/ " + BasicGuiHelper.getStringWithSpacesFromInteger(this.junction.getMaxStorage()) + " " + this.junction.getBrand(), -30, 5, 0x404040);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0015f);
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + par6), 0.0, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + par6), 0.0, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + 0), 0.0, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + 0), 0.0, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78381_a();
    }

    @Override
    public boolean display(IHUDConfig config) {
        return !this.junction.isHUDInvalid() && config.isHUDPowerLevel();
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        return -60 < x && x < 60 && -40 < y && y < 40;
    }
}

