/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.modules.ChassiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class HUDChassiePipe
extends BasicHUDGui {
    private final PipeLogisticsChassi pipe;
    private final ChassiModule module;
    private final ItemIdentifierInventory moduleInventory;
    private int selected = -1;
    private int modulePage = 0;
    private int xCursor;
    private int yCursor;

    public HUDChassiePipe(PipeLogisticsChassi pipeLogisticsChassi, ChassiModule _module, ItemIdentifierInventory _moduleInventory) {
        this.pipe = pipeLogisticsChassi;
        this.module = _module;
        this.moduleInventory = _moduleInventory;
        for (int i = 0; i < this.pipe.getChassiSize(); ++i) {
            this.addButton(new ItemButton(this.moduleInventory, i, -45, -35 + i % 3 * 27, 20, 25));
        }
        this.addButton(new BasicHUDButton("<", -45, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return !HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.modulePage--;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDChassiePipe.this.modulePage > 0;
            }
        });
        this.addButton(new BasicHUDButton(">", -33, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return !HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.modulePage++;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDChassiePipe.this.modulePage < (HUDChassiePipe.this.pipe.getChassiSize() - 1) / 3;
            }
        });
        this.addButton(new BasicHUDButton("x", 37, -45, 8, 8){

            @Override
            public boolean shouldRenderButton() {
                return HUDChassiePipe.this.isSlotSelected();
            }

            @Override
            public void clicked() {
                HUDChassiePipe.this.resetSelection();
            }

            @Override
            public boolean buttonEnabled() {
                return true;
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, Minecraft mc, IHUDConfig config) {
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
        }
        BasicGuiHelper.drawGuiBackGround(mc, -50, -50, 50, 50, 0.0f, false);
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-5.0E-5f * distance)));
        super.renderHeadUpDisplay(distance, day, mc, config);
        if (this.selected != -1) {
            LogisticsModule selectedmodule = this.module.getSubModule(this.selected);
            if (selectedmodule == null) {
                return;
            }
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            BasicGuiHelper.drawGuiBackGround(mc, -23, -35, 45, 45, 0.0f, false);
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            if (selectedmodule instanceof IHUDModuleHandler && ((IHUDModuleHandler)((Object)selectedmodule)).getHUDRenderer() != null) {
                GL11.glTranslatef((float)11.0f, (float)5.0f, (float)((float)((double)-5.0E-5f * distance)));
                ((IHUDModuleHandler)((Object)selectedmodule)).getHUDRenderer().renderContent();
                if (((IHUDModuleHandler)((Object)selectedmodule)).getHUDRenderer().getButtons() != null) {
                    for (IHUDButton button : ((IHUDModuleHandler)((Object)selectedmodule)).getHUDRenderer().getButtons()) {
                        button.renderAlways();
                        if (button.shouldRenderButton()) {
                            button.renderButton(button.isFocused(), button.isblockFocused());
                        }
                        if (!button.buttonEnabled() || !button.shouldRenderButton()) continue;
                        if (button.getX() - 1 < this.xCursor - 11 && this.xCursor - 11 < button.getX() + button.sizeX() + 1 && button.getY() - 1 < this.yCursor - 5 && this.yCursor - 5 < button.getY() + button.sizeY() + 1) {
                            if (!button.isFocused() && !button.isblockFocused()) {
                                button.setFocused();
                                continue;
                            }
                            if (button.focusedTime() <= 400 || button.isblockFocused()) continue;
                            button.clicked();
                            button.blockFocused();
                            continue;
                        }
                        if (!button.isFocused() && !button.isblockFocused()) continue;
                        button.clearFocused();
                    }
                }
                GL11.glTranslatef((float)-11.0f, (float)-5.0f, (float)((float)((double)5.0E-5f * distance)));
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-5.0E-5f * distance)));
                mc.field_71466_p.func_78276_b("Nothing", -5, -15, 0);
                mc.field_71466_p.func_78276_b("to", 9, -5, 0);
                mc.field_71466_p.func_78276_b("display", -5, 5, 0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)5.0E-5f * distance)));
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)-0.005f * distance)));
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0E-4f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
            BasicGuiHelper.renderItemIdentifierStackListIntoGui(this.pipe.displayList, null, 0, -15, -35, 3, 12, 18, 18, mc, true, true, true, true);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)((double)5.0E-5f * distance)));
    }

    @Override
    public boolean display(IHUDConfig config) {
        if (!config.isHUDChassie()) {
            return false;
        }
        for (int i = 0; i < this.moduleInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.moduleInventory.func_70301_a(i);
            if (stack == null) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        return -50 < x && x < 50 && -50 < y && y < 50;
    }

    @Override
    public void handleCursor(int x, int y) {
        super.handleCursor(x, y);
        this.xCursor = x;
        this.yCursor = y;
    }

    private void moduleClicked(int number) {
        LogisticsModule selectedmodule;
        this.selected = number;
        if (this.selected != -1 && (selectedmodule = this.module.getSubModule(this.selected)) instanceof IHUDModuleHandler) {
            ((IHUDModuleHandler)((Object)selectedmodule)).startHUDWatching();
        }
    }

    private void resetSelection() {
        LogisticsModule selectedmodule;
        if (this.selected != -1 && (selectedmodule = this.module.getSubModule(this.selected)) instanceof IHUDModuleHandler) {
            ((IHUDModuleHandler)((Object)selectedmodule)).stopHUDWatching();
        }
        this.selected = -1;
    }

    private boolean isSlotSelected() {
        return this.selected != -1;
    }

    private boolean isSlotSelected(int number) {
        return this.selected == number;
    }

    private boolean shouldDisplayButton(int number) {
        return this.modulePage * 3 <= number && number < (this.modulePage + 1) * 3;
    }

    public void stopWatching() {
        this.resetSelection();
    }

    private class ItemButton
    extends BasicHUDButton {
        private ItemIdentifierInventory inv;
        private int position;

        public ItemButton(ItemIdentifierInventory inv, int position, int x, int y, int width, int heigth) {
            super("item." + position, x, y, width, heigth);
            this.inv = inv;
            this.position = position;
        }

        @Override
        public void clicked() {
            HUDChassiePipe.this.moduleClicked(this.position);
        }

        @Override
        public void renderButton(boolean hover, boolean clicked) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-5f);
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (hover && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
                if (!clicked) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
                }
            } else if (!this.buttonEnabled() && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)32);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            if (HUDChassiePipe.this.isSlotSelected(this.position)) {
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2 + 19, (this.posY + this.sizeY) * 2, 0.0f, false, true, true, true, false);
            } else {
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2, (this.posY + this.sizeY) * 2, 0.0f, false);
            }
            GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
            if (clicked) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            }
            ItemStack module = this.inv.func_70301_a(this.position);
            ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>();
            list.add(ItemIdentifierStack.getFromStack(module));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-5f);
            if (!this.buttonEnabled() && !HUDChassiePipe.this.isSlotSelected(this.position)) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)32);
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
            }
            BasicGuiHelper.renderItemIdentifierStackListIntoGui(list, null, 0, this.posX + (this.sizeX - 16) / 2, this.posY + (this.sizeY - 16) / 2, 1, 1, 18, 18, mc, false, false, this.buttonEnabled() || HUDChassiePipe.this.isSlotSelected(this.position), true);
            if (hover) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0E-4f);
        }

        @Override
        public void renderAlways() {
            if (this.inv.func_70301_a(this.position) == null && HUDChassiePipe.this.shouldDisplayButton(this.position)) {
                GL11.glPushMatrix();
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
                GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                Minecraft mc = FMLClientHandler.instance().getClient();
                BasicGuiHelper.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2, (this.posY + this.sizeY) * 2, 0.0f, false);
                GL11.glPopMatrix();
            }
        }

        @Override
        public boolean shouldRenderButton() {
            boolean result = this.inv.func_70301_a(this.position) != null && HUDChassiePipe.this.shouldDisplayButton(this.position);
            return result;
        }

        @Override
        public boolean buttonEnabled() {
            return !HUDChassiePipe.this.isSlotSelected();
        }
    }
}

