/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.chathelper;

import java.util.ArrayList;
import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MorePageDisplay {
    private ArrayList<String> header = new ArrayList();
    private ArrayList<StringConnected> content = new ArrayList();
    private final int row = 20;
    private final int colum = 55;
    private int currentpage = 0;
    private int currentpagecount = 0;
    private boolean terminated = false;

    public MorePageDisplay(ArrayList<String> header, ICommandSender name) {
        if (header.size() <= 18) {
            this.header = header;
        }
        LPChatListener.register(this, name.func_70005_c_());
        name.func_70005_c_();
        name.func_145747_a((IChatComponent)new ChatComponentText("%LPSTORESENDMESSAGE%"));
    }

    public MorePageDisplay(String[] header, ICommandSender name) {
        if (header.length <= 18) {
            this.header = new ArrayList();
            for (int i = 0; i < header.length; ++i) {
                this.header.add(header[i]);
            }
        }
        LPChatListener.register(this, name.func_70005_c_());
        name.func_70005_c_();
        name.func_145747_a((IChatComponent)new ChatComponentText("%LPSTORESENDMESSAGE%"));
    }

    public int getRow() {
        return 20;
    }

    public int getColum() {
        return 55;
    }

    public void append(String input) {
        this.append(input, false);
    }

    public void append(String input, boolean flag) {
        this.content.add(new StringConnected(input, flag));
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void display(ICommandSender sender) {
        this.display(sender, 1);
    }

    public void display(ICommandSender player, int page) {
        this.display(player, page, false);
    }

    private String replaceMeta(String input, int page, int count) {
        String output = "";
        int pagecount = this.getPageCount(count);
        if (count == -1) {
            pagecount = 0;
        }
        if (count == -2) {
            pagecount = 1;
        }
        block10: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '%': {
                    output = output + String.valueOf(page);
                    continue block10;
                }
                case '$': {
                    output = output + String.valueOf(pagecount);
                    continue block10;
                }
                default: {
                    output = output + c;
                }
            }
        }
        boolean LeftDone = false;
        boolean RightDone = false;
        String output2 = "";
        block11: for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            switch (c) {
                case '<': {
                    int j;
                    if (LeftDone) continue block11;
                    LeftDone = true;
                    output2 = output2 + (Object)((Object)ChatColor.AQUA);
                    for (j = 0; j < (55 - output.length()) / 2; ++j) {
                        output2 = output2 + "=";
                    }
                    output2 = output2 + (Object)((Object)ChatColor.WHITE);
                    continue block11;
                }
                case '>': {
                    int j;
                    if (RightDone) continue block11;
                    RightDone = true;
                    output2 = output2 + (Object)((Object)ChatColor.AQUA);
                    for (j = 0; j < (55 - output.length()) / 2; ++j) {
                        output2 = output2 + "=";
                    }
                    output2 = output2 + (Object)((Object)ChatColor.WHITE);
                    continue block11;
                }
                case '(': {
                    int j;
                    if (LeftDone) continue block11;
                    LeftDone = true;
                    for (j = 0; j < (55 - output.length()) / 2; ++j) {
                        output2 = output2 + " ";
                    }
                    continue block11;
                }
                case ')': {
                    int j;
                    if (RightDone) continue block11;
                    RightDone = true;
                    for (j = 0; j < (55 - output.length()) / 2; ++j) {
                        output2 = output2 + " ";
                    }
                    continue block11;
                }
                default: {
                    output2 = output2 + c;
                }
            }
        }
        return output2;
    }

    public boolean handleChat(String input, ICommandSender sender) {
        if (this.terminated) {
            return false;
        }
        if (input.equalsIgnoreCase("exit") || input.equalsIgnoreCase("quit") || input.equalsIgnoreCase("q") || input.equalsIgnoreCase("e")) {
            this.terminated = true;
            sender.func_145747_a((IChatComponent)new ChatComponentText("%LPCLEARCHAT%"));
            for (Object zeilenobject : this.header.toArray()) {
                if (!(zeilenobject instanceof String)) continue;
                sender.func_145747_a((IChatComponent)new ChatComponentText(this.replaceMeta((String)zeilenobject, 0, -1)));
            }
            this.clearscreen(sender, 19 - this.header.size());
            sender.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Pageview: " + (Object)((Object)ChatColor.RED) + "Exit."));
            sender.func_145747_a((IChatComponent)new ChatComponentText("%LPRESTORESENDMESSAGE%"));
        } else if (input.equalsIgnoreCase("next") || input.equalsIgnoreCase("nex") || input.equalsIgnoreCase("n")) {
            if (this.currentpage > this.currentpagecount - 1) {
                this.display(sender, 0);
            } else {
                ++this.currentpage;
                this.display(sender, this.currentpage);
            }
            if (sender instanceof EntityPlayer) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)sender);
            }
        } else if (input.equalsIgnoreCase("previous") || input.equalsIgnoreCase("prev") || input.equalsIgnoreCase("pre") || input.equalsIgnoreCase("p")) {
            if (this.currentpage < 2) {
                this.display(sender, this.currentpagecount);
            } else {
                --this.currentpage;
                this.display(sender, this.currentpage);
            }
        } else if (MorePageDisplay.isNumber(input)) {
            if (MorePageDisplay.toNumber(input) <= this.currentpagecount && MorePageDisplay.toNumber(input) > 0) {
                this.display(sender, MorePageDisplay.toNumber(input));
            } else {
                this.display(sender, this.currentpage, true);
                sender.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Pageview:" + (Object)((Object)ChatColor.RED) + " Not a valid number."));
            }
        } else if (input.equalsIgnoreCase("reprint")) {
            this.display(sender, this.currentpage);
        } else if (input.equalsIgnoreCase("all")) {
            this.display(sender, this.currentpage, false, true, 0);
        } else if (input.startsWith("save ")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("%LPADDTOSENDMESSAGE%" + input.substring(5)));
            this.display(sender, this.currentpage, true, false, 1);
            sender.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Added '" + (Object)((Object)ChatColor.YELLOW) + input.substring(5) + (Object)((Object)ChatColor.AQUA) + "' to your chat history."));
            this.printLastLine(sender, false);
            if (sender instanceof EntityPlayer) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)sender);
            }
        } else if (input.equals("save")) {
            this.display(sender, this.currentpage, true, false, 2);
            sender.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Add an command after the '" + (Object)((Object)ChatColor.YELLOW) + "save " + (Object)((Object)ChatColor.AQUA) + "' and it will be added to your chat history."));
            this.printLastLine(sender, false);
            if (sender instanceof EntityPlayer) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)sender);
            }
        } else {
            this.printLastLine(sender, true);
            if (sender instanceof EntityPlayer) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)sender);
            }
        }
        return true;
    }

    public static boolean isNumber(String input) {
        try {
            int number = Integer.parseInt(input);
            String numstring = String.valueOf(number);
            if (numstring.equalsIgnoreCase(input)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int toNumber(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void clearscreen(ICommandSender sender, int count) {
        for (int i = 0; i < count; ++i) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(""));
        }
    }

    public void display(ICommandSender sender, int page, boolean flag) {
        this.display(sender, page, flag, false, 0);
    }

    public void printLastLine(ICommandSender sender) {
        this.printLastLine(sender, false);
    }

    public void printLastLine(ICommandSender sender, boolean flag) {
        sender.func_145747_a((IChatComponent)new ChatComponentText((flag ? "! " : "") + (Object)((Object)ChatColor.AQUA) + "Pageview:" + (Object)((Object)ChatColor.WHITE) + " Enter " + (Object)((Object)ChatColor.RED) + "Pre" + (Object)((Object)ChatColor.WHITE) + "/" + (Object)((Object)ChatColor.GREEN) + "Next" + (Object)((Object)ChatColor.WHITE) + ", a " + (Object)((Object)ChatColor.AQUA) + "number" + (Object)((Object)ChatColor.WHITE) + ", " + (Object)((Object)ChatColor.AQUA) + "all" + (Object)((Object)ChatColor.WHITE) + ", " + (Object)((Object)ChatColor.AQUA) + "reprint" + (Object)((Object)ChatColor.WHITE) + ", " + (Object)((Object)ChatColor.AQUA) + "save" + (Object)((Object)ChatColor.WHITE) + " or " + (Object)((Object)ChatColor.RED) + "exit" + (Object)((Object)ChatColor.WHITE) + (flag ? " !" : ".")));
    }

    public int getPageCount(int count) {
        int currentPage = 0;
        int lineOnCurentPage = 0;
        int i = 0;
        while (i < this.content.size()) {
            int I;
            for (I = i; I < this.content.size() - 1 && this.content.get((int)(I + 1)).connected; ++I) {
            }
            int needed = I - i;
            if (lineOnCurentPage + needed > count - 1) {
                ++currentPage;
                lineOnCurentPage = 0;
            }
            ++i;
            ++lineOnCurentPage;
        }
        return currentPage + 1;
    }

    public void display(ICommandSender sender, int page, boolean flag, boolean all, int linesub) {
        int pagecount;
        if (this.terminated) {
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("%LPCLEARCHAT%"));
        int count = 20 - this.header.size() - 1 - linesub;
        this.currentpage = page = page > 0 && !all ? page : 1;
        this.currentpagecount = pagecount = this.getPageCount(count);
        if (all) {
            count = -2;
        }
        for (Object zeilenobject : this.header.toArray()) {
            if (!(zeilenobject instanceof String)) continue;
            sender.func_145747_a((IChatComponent)new ChatComponentText(this.replaceMeta((String)zeilenobject, page, count)));
        }
        int currentPage = 0;
        int lineOnCurentPage = 0;
        int doneLines = 0;
        int i = 0;
        while (i < this.content.size()) {
            if (all) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(this.content.get((int)i).content));
            } else {
                int I;
                for (I = i; I < this.content.size() - 1 && this.content.get((int)(I + 1)).connected; ++I) {
                }
                int needed = I - i;
                if (lineOnCurentPage + needed > count - 1) {
                    ++currentPage;
                    lineOnCurentPage = 0;
                }
                if (page == currentPage + 1) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(this.content.get((int)i).content));
                    doneLines = lineOnCurentPage;
                }
            }
            ++i;
            ++lineOnCurentPage;
        }
        if (!all) {
            this.clearscreen(sender, 18 - this.header.size() - doneLines - linesub);
        }
        if (all && count > this.content.size()) {
            this.clearscreen(sender, count - this.content.size());
        }
        if (!flag) {
            this.printLastLine(sender);
        }
        if (sender instanceof EntityPlayer) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)sender);
        }
    }

    private class StringConnected {
        public String content;
        public boolean connected;

        StringConnected(String s, boolean b) {
            this.content = s;
            this.connected = b;
        }
    }
}

