/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSolderingTileEntity;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.blocks.powertile.LogisticsIC2PowerProviderTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.blocks.powertile.LogisticsRFPowerProviderTileEntity;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.proxy.MainProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogisticsSolidBlock
extends BlockContainer {
    public static final int SOLDERING_STATION = 0;
    public static final int LOGISTICS_POWER_JUNCTION = 1;
    public static final int LOGISTICS_SECURITY_STATION = 2;
    public static final int LOGISTICS_AUTOCRAFTING_TABLE = 3;
    public static final int LOGISTICS_FUZZYCRAFTING_TABLE = 4;
    public static final int LOGISTICS_RF_POWERPROVIDER = 11;
    public static final int LOGISTICS_IC2_POWERPROVIDER = 12;
    private static final IIcon[] icons = new IIcon[17];

    public LogisticsSolidBlock() {
        super(Material.field_151573_f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(6.0f);
    }

    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        super.func_149699_a(par1World, par2, par3, par4, par5EntityPlayer);
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity tile;
        if (!par5EntityPlayer.func_70093_af() && (tile = par1World.func_147438_o(par2, par3, par4)) instanceof IGuiTileEntity) {
            if (MainProxy.isServer(par5EntityPlayer.field_70170_p)) {
                ((IGuiTileEntity)tile).getGuiProvider().setTilePos(tile).open(par5EntityPlayer);
            }
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int posX, int posY, int posZ, EntityLivingBase entity, ItemStack itemStack) {
        super.func_149689_a(world, posX, posY, posZ, entity, itemStack);
        TileEntity tile = world.func_147438_o(posX, posY, posZ);
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).placedBy(entity);
        }
        if (tile instanceof IRotationProvider) {
            double x = (double)tile.field_145851_c - entity.field_70165_t;
            double z = (double)tile.field_145849_e - entity.field_70161_v;
            double w = Math.atan2(x, z);
            double halfPI = 1.5707963267948966;
            double halfhalfPI = halfPI / 2.0;
            if ((w -= halfhalfPI) < 0.0) {
                w += Math.PI * 2;
            }
            if (0.0 < w && w <= halfPI) {
                ((IRotationProvider)tile).setRotation(1);
            } else if (halfPI < w && w <= 2.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(2);
            } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(0);
            } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(3);
            }
        }
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntity tile = par1World.func_147438_o(par2, par3, par4);
        if (tile instanceof LogisticsSolderingTileEntity) {
            ((LogisticsSolderingTileEntity)tile).onBlockBreak();
        }
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).onBlockBreak();
        }
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getRotatedTexture(meta, side, 2, 0);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new LogisticsSolderingTileEntity();
            }
            case 1: {
                return new LogisticsPowerJunctionTileEntity();
            }
            case 2: {
                return new LogisticsSecurityTileEntity();
            }
            case 3: 
            case 4: {
                return new LogisticsCraftingTableTileEntity();
            }
            case 11: {
                return new LogisticsRFPowerProviderTileEntity();
            }
            case 12: {
                return new LogisticsIC2PowerProviderTileEntity();
            }
        }
        return null;
    }

    public int func_149692_a(int par1) {
        switch (par1) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                return par1;
            }
        }
        return super.func_149692_a(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof IRotationProvider) {
            return this.getRotatedTexture(meta, side, ((IRotationProvider)tile).getRotation(), ((IRotationProvider)tile).getFrontTexture());
        }
        return this.getRotatedTexture(meta, side, 3, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        for (int i = 0; i < 17; ++i) {
            LogisticsSolidBlock.icons[i] = par1IIconRegister.func_94245_a("logisticspipes:lpsolidblock/" + i);
        }
    }

    private IIcon getRotatedTexture(int meta, int side, int rotation, int front) {
        switch (meta) {
            case 0: {
                if (front == 0) {
                    front = 8;
                }
                switch (side) {
                    case 1: {
                        return icons[1];
                    }
                    case 0: {
                        return icons[2];
                    }
                    case 2: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 3: 
                        }
                        return icons[front];
                    }
                    case 3: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 2: 
                        }
                        return icons[front];
                    }
                    case 4: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 1: 
                        }
                        return icons[front];
                    }
                    case 5: {
                        switch (rotation) {
                            case 0: {
                                return icons[front];
                            }
                        }
                        return icons[7];
                    }
                }
                return icons[0];
            }
            case 1: {
                switch (side) {
                    case 1: {
                        return icons[4];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
            case 2: {
                switch (side) {
                    case 1: {
                        return icons[9];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
            case 3: {
                switch (side) {
                    case 1: {
                        return icons[11];
                    }
                    case 0: {
                        return icons[12];
                    }
                }
                return icons[10];
            }
            case 4: {
                switch (side) {
                    case 1: {
                        return icons[16];
                    }
                    case 0: {
                        return icons[12];
                    }
                }
                return icons[10];
            }
            case 11: {
                switch (side) {
                    case 1: {
                        return icons[14];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
            case 12: {
                switch (side) {
                    case 1: {
                        return icons[15];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
        }
        return icons[0];
    }
}

