/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.wrapper;

import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.wrapper.WrapperState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.ChatColor;

public abstract class AbstractWrapper {
    protected WrapperState state = WrapperState.Enabled;
    private Throwable reason;
    private String modId;

    public void handleException(Throwable e) {
        if (!this.isEnabled()) {
            if (LPConstants.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
        if (LPConstants.DEBUG) {
            throw e;
        }
        e.printStackTrace();
        this.state = WrapperState.Exception;
        this.reason = e;
        String message = "Disabled " + this.getName() + this.getTypeName() + (this.modId != null ? " for Mod: " + this.modId : "") + ". Cause was an Exception";
        LogisticsPipes.log.fatal(message);
        MainProxy.proxy.sendBroadCast((Object)((Object)ChatColor.RED) + message);
    }

    public void reEnable() {
        if (this.state != WrapperState.Exception) {
            return;
        }
        this.state = WrapperState.Enabled;
        this.reason = null;
    }

    protected final boolean isEnabled() {
        return this.state == WrapperState.Enabled;
    }

    protected final boolean canTryAnyway() {
        return this.state != WrapperState.ModMissing;
    }

    public abstract String getName();

    public abstract String getTypeName();

    public WrapperState getState() {
        return this.state;
    }

    void setState(WrapperState state) {
        this.state = state;
    }

    public Throwable getReason() {
        return this.reason;
    }

    void setReason(Throwable reason) {
        this.reason = reason;
    }

    public String getModId() {
        return this.modId;
    }

    void setModId(String modId) {
        this.modId = modId;
    }
}

