/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.bc;

import buildcraft.BuildCraftTransport;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.pipes.events.PipeEvent;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InjectItemHook {
    public static void handleInjectItem(PipeTransportItems pipe, TravelingItem item, ForgeDirection inputOrientation) {
        if (item.isCorrupted()) {
            return;
        }
        item.reset();
        item.input = inputOrientation;
        pipe.readjustSpeed(item);
        InjectItemHook.readjustPosition(pipe, item);
        if (!pipe.container.func_145831_w().field_72995_K) {
            item.output = pipe.resolveDestination(item);
        }
        PipeEventItem.Entered event = new PipeEventItem.Entered(item);
        pipe.container.pipe.eventBus.handleEvent(PipeEventItem.Entered.class, (PipeEvent)event);
        if (event.cancelled) {
            return;
        }
        pipe.items.add(item);
        if (!pipe.container.func_145831_w().field_72995_K) {
            ItemStack stack;
            InjectItemHook.sendTravelerPacket(pipe, item, false);
            int stackCount = 0;
            int numItems = 0;
            for (TravelingItem travellingItem : pipe.items) {
                if (travellingItem instanceof LPRoutedBCTravelingItem || (stack = travellingItem.getItemStack()) == null || stack.field_77994_a <= 0) continue;
                numItems += stack.field_77994_a;
                ++stackCount;
            }
            if (stackCount > BuildCraftTransport.groupItemsTrigger) {
                pipe.groupEntities();
            }
            stackCount = 0;
            numItems = 0;
            for (TravelingItem travellingItem : pipe.items) {
                if (travellingItem instanceof LPRoutedBCTravelingItem || (stack = travellingItem.getItemStack()) == null || stack.field_77994_a <= 0) continue;
                numItems += stack.field_77994_a;
                ++stackCount;
            }
            if (stackCount > 64) {
                SimpleServiceLocator.buildCraftProxy.logWarning(String.format("Pipe exploded at %d,%d,%d because it had too many stacks: %d", pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e, stackCount));
                InjectItemHook.destroyPipe(pipe);
                return;
            }
            if (numItems > 1024) {
                SimpleServiceLocator.buildCraftProxy.logWarning(String.format("Pipe exploded at %d,%d,%d because it had too many items: %d", pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e, numItems));
                InjectItemHook.destroyPipe(pipe);
            }
        }
    }

    private static void destroyPipe(PipeTransportItems pipe) {
        BlockUtils.explodeBlock((World)pipe.container.func_145831_w(), (int)pipe.container.field_145851_c, (int)pipe.container.field_145848_d, (int)pipe.container.field_145849_e);
        pipe.container.func_145831_w().func_147468_f(pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e);
    }

    private static void sendTravelerPacket(PipeTransportItems pipe, TravelingItem data, boolean forceStackRefresh) {
        PacketPipeTransportTraveler packet = new PacketPipeTransportTraveler(data, forceStackRefresh);
        BuildCraftTransport.instance.sendToPlayers((BuildCraftPacket)packet, pipe.container.func_145831_w(), pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
    }

    private static void readjustPosition(PipeTransportItems pipe, TravelingItem item) {
        double x = MathUtils.clamp((double)item.xCoord, (double)((double)pipe.container.field_145851_c + 0.01), (double)((double)pipe.container.field_145851_c + 0.99));
        double y = MathUtils.clamp((double)item.yCoord, (double)((double)pipe.container.field_145848_d + 0.01), (double)((double)pipe.container.field_145848_d + 0.99));
        double z = MathUtils.clamp((double)item.zCoord, (double)((double)pipe.container.field_145849_e + 0.01), (double)((double)pipe.container.field_145849_e + 0.99));
        if (item.input != ForgeDirection.UP && item.input != ForgeDirection.DOWN) {
            y = (float)pipe.container.field_145848_d + TransportUtils.getPipeFloorOf((ItemStack)item.getItemStack());
        }
        item.setPosition(x, y, z);
    }
}

