/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import logisticspipes.LPConstants;
import logisticspipes.asm.bc.ClassPipeTransportItemsHandler;
import logisticspipes.asm.bc.PipeEventBusHandler;
import logisticspipes.utils.ModStatusHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class LogisticsClassTransformer
implements IClassTransformer {
    public List<String> interfacesToClearA = new ArrayList<String>();
    public List<String> interfacesToClearB = new ArrayList<String>();
    private LaunchClassLoader cl = (LaunchClassLoader)LogisticsClassTransformer.class.getClassLoader();
    private Field negativeResourceCache;
    private Field invalidClasses;
    public static LogisticsClassTransformer instance;

    public LogisticsClassTransformer() {
        instance = this;
        try {
            this.negativeResourceCache = LaunchClassLoader.class.getDeclaredField("negativeResourceCache");
            this.negativeResourceCache.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.invalidClasses = LaunchClassLoader.class.getDeclaredField("invalidClasses");
            this.invalidClasses.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("Minecraft main thread") || thread.getName().equals("main") || thread.getName().equals("Server thread")) {
            this.clearNegativeInterfaceCache();
        }
        if (bytes == null) {
            return null;
        }
        if (name.startsWith("logisticspipes.") || name.startsWith("net.minecraft") || LPConstants.DEBUG) {
            return this.applyLPTransforms(name, bytes);
        }
        byte[] tmp = (byte[])bytes.clone();
        if (!Arrays.equals(bytes = this.applyLPTransforms(name, bytes), tmp)) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            node.sourceFile = "[LP|ASM] " + node.sourceFile;
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
        }
        return bytes;
    }

    private byte[] applyLPTransforms(String name, byte[] bytes) {
        try {
            if (name.equals("buildcraft.transport.PipeTransportItems")) {
                return ClassPipeTransportItemsHandler.handlePipeTransportItems(bytes);
            }
            if (name.equals("buildcraft.transport.PipeEventBus")) {
                return PipeEventBusHandler.handleBCPipeEventBusClass(bytes);
            }
            if (name.equals("net.minecraft.crash.CrashReport")) {
                return this.handleCrashReportClass(bytes);
            }
            if (name.equals("dan200.computercraft.core.lua.LuaJLuaMachine")) {
                return this.handleCCLuaJLuaMachine(bytes);
            }
            if (!name.startsWith("logisticspipes.")) {
                return bytes;
            }
            return this.handleLPTransformation(bytes);
        }
        catch (Exception e) {
            if (LPConstants.DEBUG) {
                e.printStackTrace();
                return bytes;
            }
            throw new RuntimeException(e);
        }
    }

    public void clearNegativeInterfaceCache() {
        if (this.negativeResourceCache != null && !this.interfacesToClearA.isEmpty()) {
            this.handleField(this.negativeResourceCache, this.interfacesToClearA);
        }
        if (this.invalidClasses != null && !this.interfacesToClearB.isEmpty()) {
            this.handleField(this.invalidClasses, this.interfacesToClearB);
        }
    }

    private void handleField(Field field, List<String> toClear) {
        block3: {
            try {
                Set set = (Set)field.get(this.cl);
                Iterator<String> it = toClear.iterator();
                while (it.hasNext()) {
                    String content = it.next();
                    if (!set.contains(content)) continue;
                    set.remove(content);
                    it.remove();
                }
            }
            catch (Exception e) {
                if (!LPConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private byte[] handleLPTransformation(byte[] bytes) {
        final ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        boolean changed = false;
        if (node.visibleAnnotations != null) {
            for (AnnotationNode a : node.visibleAnnotations) {
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentInterface;")) continue;
                if (a.values.size() == 4 && a.values.get(0).equals("modId") && a.values.get(2).equals("interfacePath")) {
                    List modId = (List)a.values.get(1);
                    List interfacePath = (List)a.values.get(3);
                    if (modId.size() != interfacePath.size()) {
                        throw new RuntimeException("The Arrays have to be of the same size.");
                    }
                    block1: for (int i = 0; i < modId.size(); ++i) {
                        if (ModStatusHelper.isModLoaded((String)modId.get(i))) continue;
                        this.interfacesToClearA.add((String)interfacePath.get(i));
                        this.interfacesToClearB.add((String)interfacePath.get(i));
                        for (String inter : node.interfaces) {
                            if (!inter.replace("/", ".").equals(interfacePath.get(i))) continue;
                            node.interfaces.remove(inter);
                            changed = true;
                            continue block1;
                        }
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Can't parse the annotations correctly");
            }
        }
        ArrayList<MethodNode> methodsToRemove = new ArrayList<MethodNode>();
        block3: for (MethodNode m : node.methods) {
            if (m.visibleAnnotations == null) continue;
            for (AnnotationNode a : m.visibleAnnotations) {
                String modId;
                if (a.desc.equals("Llogisticspipes/asm/ModDependentMethod;")) {
                    if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                        modId = a.values.get(1).toString();
                        if (ModStatusHelper.isModLoaded(modId)) continue;
                        methodsToRemove.add(m);
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Can't parse the annotation correctly");
                }
                if (a.desc.equals("Llogisticspipes/asm/ClientSideOnlyMethodContent;")) {
                    if (!FMLCommonHandler.instance().getSide().equals((Object)Side.SERVER)) continue;
                    m.instructions.clear();
                    m.localVariables.clear();
                    m.tryCatchBlocks.clear();
                    m.visitCode();
                    Label l0 = new Label();
                    m.visitLabel(l0);
                    m.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "callingClearedMethod", "()V");
                    Label l1 = new Label();
                    m.visitLabel(l1);
                    m.visitInsn(177);
                    Label l2 = new Label();
                    m.visitLabel(l2);
                    m.visitLocalVariable("this", "Llogisticspipes/network/packets/DummyPacket;", null, l0, l2, 0);
                    m.visitLocalVariable("player", "Lnet/minecraft/entity/player/EntityPlayer;", null, l0, l2, 1);
                    m.visitMaxs(0, 2);
                    m.visitEnd();
                    changed = true;
                    continue block3;
                }
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentMethodName;")) continue;
                if (a.values.size() == 6 && a.values.get(0).equals("modId") && a.values.get(2).equals("newName") && a.values.get(4).equals("version")) {
                    modId = a.values.get(1).toString();
                    final String newName = a.values.get(3).toString();
                    String version = a.values.get(5).toString();
                    boolean loaded = ModStatusHelper.isModLoaded(modId);
                    if (loaded && !version.equals("")) {
                        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modId);
                        if (mod != null) {
                            VersionRange range = VersionParser.parseRange((String)version);
                            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion("Version", mod.getVersion());
                            loaded = range.containsVersion((ArtifactVersion)artifactVersion);
                        } else {
                            loaded = false;
                        }
                    }
                    if (!loaded) continue;
                    final String oldName = m.name;
                    m.name = newName;
                    MethodNode newM = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (name.equals(oldName) && owner.equals(node.superName)) {
                                super.visitMethodInsn(opcode, owner, newName, desc);
                            } else {
                                super.visitMethodInsn(opcode, owner, name, desc);
                            }
                        }
                    };
                    m.accept((MethodVisitor)newM);
                    node.methods.set(node.methods.indexOf(m), newM);
                    changed = true;
                    continue block3;
                }
                throw new UnsupportedOperationException("Can't parse the annotation correctly");
            }
        }
        for (MethodNode m : methodsToRemove) {
            node.methods.remove(m);
        }
        ArrayList<FieldNode> fieldsToRemove = new ArrayList<FieldNode>();
        block6: for (FieldNode f : node.fields) {
            if (f.visibleAnnotations == null) continue;
            for (AnnotationNode a : f.visibleAnnotations) {
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentField;")) continue;
                if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                    String modId = a.values.get(1).toString();
                    if (ModStatusHelper.isModLoaded(modId)) continue;
                    fieldsToRemove.add(f);
                    continue block6;
                }
                throw new UnsupportedOperationException("Can't parse the annotation correctly");
            }
        }
        for (FieldNode f : fieldsToRemove) {
            node.fields.remove(f);
        }
        if (!changed && methodsToRemove.isEmpty() && fieldsToRemove.isEmpty()) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleCrashReportClass(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode m : node.methods) {
            if (!m.name.equals("getCompleteReport") && !m.name.equals("func_71502_e")) continue;
            MethodNode mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){
                private STATE state;
                {
                    this.state = STATE.SEARCHING;
                }

                public void visitLdcInsn(Object cst) {
                    super.visitLdcInsn(cst);
                    if ("\n\n".equals(cst) && this.state == STATE.SEARCHING) {
                        this.state = STATE.INSERTING;
                    }
                }

                public void visitLabel(Label label) {
                    if (this.state == STATE.INSERTING) {
                        Label l0 = new Label();
                        super.visitLabel(l0);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "getCrashReportAddition", "()Ljava/lang/String;");
                        super.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        super.visitInsn(87);
                        this.state = STATE.DONE;
                    }
                    super.visitLabel(label);
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleCCLuaJLuaMachine(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode m : node.methods) {
            MethodNode mv;
            if (m.name.equals("wrapLuaObject") && m.desc.equals("(Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;")) {
                mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                    public void visitInsn(int opcode) {
                        if (opcode == 176) {
                            super.visitVarInsn(25, 1);
                            super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "onCCWrappedILuaObject", "(Lorg/luaj/vm2/LuaTable;Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;");
                        }
                        super.visitInsn(opcode);
                    }

                    public void visitCode() {
                        super.visitCode();
                        Label l0 = new Label();
                        super.visitLabel(l0);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "handleCCWrappedILuaObject", "(Ldan200/computercraft/api/lua/ILuaObject;)Z");
                        Label l1 = new Label();
                        super.visitJumpInsn(153, l1);
                        Label l2 = new Label();
                        super.visitLabel(l2);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "returnCCWrappedILuaObject", "(Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;");
                        super.visitInsn(176);
                        super.visitLabel(l1);
                    }
                };
                m.accept((MethodVisitor)mv);
                node.methods.set(node.methods.indexOf(m), mv);
            }
            if (!m.name.equals("toObject") || !m.desc.equals("(Lorg/luaj/vm2/LuaValue;)Ljava/lang/Object;")) continue;
            mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){
                boolean added;
                {
                    this.added = false;
                }

                public void visitLineNumber(int line, Label start) {
                    if (!this.added) {
                        this.added = true;
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "handleCCToObject", "(Lorg/luaj/vm2/LuaValue;)Z");
                        start = new Label();
                        super.visitJumpInsn(153, start);
                        Label l5 = new Label();
                        super.visitLabel(l5);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "returnCCToObject", "(Lorg/luaj/vm2/LuaValue;)Ljava/lang/Object;");
                        super.visitInsn(176);
                        super.visitLabel(start);
                    }
                    super.visitLineNumber(line, start);
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static enum STATE {
        SEARCHING,
        INSERTING,
        DONE;

    }
}

