/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.common.asm.transformers.ModAccessTransformer;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.FileListHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import logisticspipes.LPConstants;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import scala.actors.threadpool.Arrays;

public class DevEnvHelper {
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detectCoreModInEclipseSettings() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException, IOException {
        if (!LPConstants.DEBUG || !new File(".classpath").exists()) {
            return;
        }
        Method handleCascadingTweak = CoreModManager.class.getDeclaredMethod("handleCascadingTweak", File.class, JarFile.class, String.class, LaunchClassLoader.class, Integer.class);
        handleCascadingTweak.setAccessible(true);
        Method loadCoreMod = CoreModManager.class.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
        loadCoreMod.setAccessible(true);
        Method setupCoreModDir = CoreModManager.class.getDeclaredMethod("setupCoreModDir", File.class);
        setupCoreModDir.setAccessible(true);
        Field loadedCoremods = CoreModManager.class.getDeclaredField("loadedCoremods");
        loadedCoremods.setAccessible(true);
        Field reparsedCoremods = CoreModManager.class.getDeclaredField("reparsedCoremods");
        reparsedCoremods.setAccessible(true);
        Field mcDir = CoreModManager.class.getDeclaredField("mcDir");
        mcDir.setAccessible(true);
        Field transformers = LaunchClassLoader.class.getDeclaredField("transformers");
        transformers.setAccessible(true);
        LaunchClassLoader classLoader = Launch.classLoader;
        FMLRelaunchLog.fine((String)"Discovering coremods", (Object[])new Object[0]);
        File coreMods = (File)setupCoreModDir.invoke(null, mcDir.get(null));
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] FMLcoreModListArray = coreMods.listFiles(ff);
        File versionedModDir = new File(coreMods, "1.7.10");
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = versionedModDir.listFiles(ff);
            FMLcoreModListArray = (File[])ObjectArrays.concat((Object[])FMLcoreModListArray, (Object[])versionedCoreMods, File.class);
        }
        ArrayList<String> FMLcoreModList = new ArrayList<String>();
        for (Object f : FMLcoreModListArray) {
            FMLcoreModList.add(((File)f).getName());
        }
        List<File> coreModList = new ArrayList();
        for (URL path : classLoader.getURLs()) {
            File file = new File(URLDecoder.decode(path.getFile()));
            if (FMLcoreModList.contains(file.getName()) || !file.getName().endsWith(".jar")) continue;
            coreModList.add(file);
        }
        coreModList = Arrays.asList((Object[])FileListHelper.sortFileList((File[])coreModList.toArray(new File[coreModList.size()])));
        for (File coreMod : coreModList) {
            String cascadedTweaker;
            Attributes mfAttributes;
            FMLRelaunchLog.fine((String)"Examining for coremod candidacy %s", (Object[])new Object[]{coreMod.getName()});
            JarFile jar = null;
            try {
                jar = new JarFile(coreMod);
                if (jar.getManifest() == null) continue;
                ModAccessTransformer.addJar((JarFile)jar);
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{coreMod.getName()});
                continue;
            }
            finally {
                if (jar == null) continue;
                try {
                    jar.close();
                }
                catch (IOException e) {}
                continue;
            }
            if (mfAttributes.getValue("AccessTransformer") != null) {
                String cfg = mfAttributes.getValue("AccessTransformer");
                ((List)transformers.get(classLoader)).add(new AccessTransformer(cfg){});
            }
            if ((cascadedTweaker = mfAttributes.getValue("TweakClass")) != null) {
                FMLRelaunchLog.info((String)"Loading tweaker %s from %s", (Object[])new Object[]{cascadedTweaker, coreMod.getName()});
                Integer sortOrder = Ints.tryParse((String)Strings.nullToEmpty((String)mfAttributes.getValue("TweakOrder")));
                sortOrder = sortOrder == null ? Integer.valueOf(0) : sortOrder;
                handleCascadingTweak.invoke(null, coreMod, jar, cascadedTweaker, classLoader, sortOrder);
                ((List)loadedCoremods.get(null)).add(coreMod.getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.fine((String)"Not found coremod data in %s", (Object[])new Object[]{coreMod.getName()});
                continue;
            }
            if (!mfAttributes.containsKey(COREMODCONTAINSFMLMOD)) {
                FMLRelaunchLog.finer((String)"Adding %s to the list of known coremods, it will not be examined again", (Object[])new Object[]{coreMod.getName()});
                ((List)loadedCoremods.get(null)).add(coreMod.getName());
            } else {
                FMLRelaunchLog.finer((String)"Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", (Object[])new Object[]{coreMod.getName()});
            }
            loadCoreMod.invoke(null, classLoader, fmlCorePlugin, coreMod);
        }
    }
}

