/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.IOException;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.ConfigModule;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import tterrag.wailaplugins.WailaPlugins;
import tterrag.wailaplugins.api.IPlugin;
import tterrag.wailaplugins.config.WPConfigHandler;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugins {
    public static final Plugins INSTANCE = new Plugins();

    private Plugins() {
    }

    public void preInit() {
        ClassPath classpath;
        try {
            classpath = ClassPath.from((ClassLoader)WailaPlugins.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("tterrag.wailaplugins.plugins");
        ConfigHandler cfg = ConfigHandler.instance();
        cfg.addModule("wailaplugins", new ConfigModule("wailaplugins"));
        for (ClassPath.ClassInfo info : classes) {
            if (info.getName().equals(this.getClass().getName()) || info.getName().equals(PluginBase.class.getName())) continue;
            boolean failed = false;
            String modid = Plugins.getModid(info);
            if (WPConfigHandler.INSTANCE.isPluginEnabled(modid) && Loader.isModLoaded((String)modid)) {
                WailaPlugins.logger.info("Attempting to load plugin for " + modid + ".");
                Class clazz = info.load();
                if (IPlugin.class.isAssignableFrom(clazz)) {
                    try {
                        IPlugin inst = (IPlugin)clazz.newInstance();
                        cfg.addConfig("WAILA Plugins", modid, Plugins.getModContainerFromID(modid).getName());
                        inst.load((IWailaRegistrar)ModuleRegistrar.instance());
                    }
                    catch (IllegalAccessException e) {
                        WailaPlugins.logger.error("Construtor for class " + info.getName() + " could not be accessed.");
                        failed = true;
                    }
                    catch (InstantiationException e) {
                        WailaPlugins.logger.error("Class " + info.getName() + " does not have a default constructor");
                        failed = true;
                    }
                } else {
                    WailaPlugins.logger.error("Class " + info.getName() + " does not implement IPlugin and could not be loaded.");
                }
                if (failed) {
                    WailaPlugins.logger.fatal("Failed to load plugin for " + modid + ".");
                    continue;
                }
                WailaPlugins.logger.info("Successfully loaded plugin for " + modid + ".");
                continue;
            }
            WailaPlugins.logger.info("Skipping over plugin " + info.getName() + " as its dependency was not found.");
        }
    }

    public static String getModid(Class<?> c) {
        return Plugins.getModid(c.getSimpleName());
    }

    public static String getModid(ClassPath.ClassInfo c) {
        return Plugins.getModid(c.getSimpleName());
    }

    public static String getModName(Class<?> c) {
        return Plugins.getModContainerFromID(Plugins.getModid(c)).getName();
    }

    public static String getModName(ClassPath.ClassInfo c) {
        return Plugins.getModContainerFromID(Plugins.getModid(c)).getName();
    }

    private static String getModid(String className) {
        return className.replace("Plugin_", "");
    }

    private static ModContainer getModContainerFromID(String modid) {
        for (ModContainer c : Loader.instance().getModList()) {
            if (!c.getModId().equals(modid)) continue;
            return c;
        }
        return null;
    }
}

