/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mekanism.api.gas.GasStack;
import mekanism.common.IFactory;
import mekanism.common.Tier;
import mekanism.common.block.BlockMachine;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityPortableTank;
import mekanism.common.tile.TileEntitySalinationController;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_Mekanism
extends PluginBase {
    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TileEntitySalinationController.class, TileEntityPortableTank.class, TileEntityGasTank.class, TileEntityElectricBlock.class);
        this.syncNBT(TileEntityElectricBlock.class);
        this.addConfig("salination");
        this.addConfig("portableTank");
        this.addConfig("gas");
        this.addConfig("factoryType");
        this.addConfig("energy");
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        TileEntity tile = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (tile instanceof TileEntitySalinationController) {
            currenttip.add(EnumChatFormatting.GREEN.toString() + (float)Math.round(((TileEntitySalinationController)tile).getTempMultiplier() * 10.0f) / 10.0f + "x");
        }
        if (tile instanceof TileEntityPortableTank) {
            FluidStack fluid = ((TileEntityPortableTank)tile).getFluidStack(new Object[0]);
            this.addFluidTooltip(currenttip, fluid);
        }
        if (tile instanceof TileEntityGasTank) {
            GasStack gas = ((TileEntityGasTank)tile).gasTank.getGas();
            currenttip.add(EnumChatFormatting.GOLD.toString() + gas.amount + " " + gas.getGas().getLocalizedName());
        }
        if (tile instanceof TileEntityFactory) {
            IFactory.RecipeType type = IFactory.RecipeType.values()[tag.func_74762_e("recipeType")];
            currenttip.add(EnumChatFormatting.AQUA + type.getName());
        }
        if (tile instanceof TileEntityElectricBlock) {
            double power = tag.func_74769_h("electricityStored");
            BlockMachine.MachineType type = BlockMachine.MachineType.get((Block)accessor.getBlock(), (int)accessor.getMetadata());
            double maxPower = type == null ? (tile instanceof TileEntityEnergyCube ? Tier.EnergyCubeTier.getFromName((String)tag.func_74779_i((String)"tier")).MAX_ELECTRICITY : ((TileEntityElectricBlock)tile).getMaxEnergy()) : type.baseEnergy;
            currenttip.add(String.format("%s%s %s/ %s%s", EnumChatFormatting.WHITE, MekanismUtils.getEnergyDisplay((double)power), EnumChatFormatting.GRAY, EnumChatFormatting.WHITE, MekanismUtils.getEnergyDisplay((double)maxPower)));
        }
    }

    private void addFluidTooltip(List<String> tt, FluidStack fluid) {
        if (fluid != null) {
            tt.add(EnumChatFormatting.AQUA.toString() + fluid.amount + " " + fluid.getLocalizedName());
        }
    }
}

