/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import WayofTime.alchemicalWizardry.common.tileEntity.TETeleposer;
import WayofTime.alchemicalWizardry.common.tileEntity.TEWritingTable;
import com.google.common.base.Strings;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import tterrag.wailaplugins.config.WPConfigHandler;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_AWWayofTime
extends PluginBase {
    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TEAltar.class, TEWritingTable.class, TEMasterStone.class, TETeleposer.class);
        this.syncNBT(TEAltar.class, TEWritingTable.class, TEMasterStone.class, TETeleposer.class);
        this.addConfig("altar");
        this.addConfig("chemistrySet");
        this.addConfig("masterStone");
        this.addConfig("teleposer");
    }

    @Override
    public void getBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor) {
        boolean hasSeer = false;
        boolean hasSigil = false;
        switch (WPConfigHandler.sigilBehavior) {
            case 0: {
                hasSigil = true;
                hasSeer = true;
                break;
            }
            case 1: {
                hasSeer = this.searchInventory(ModItems.itemSeerSigil, accessor.getPlayer()) != null;
                hasSigil = hasSeer || this.searchInventory(ModItems.divinationSigil, accessor.getPlayer()) != null;
                break;
            }
            case 2: {
                hasSeer = accessor.getPlayer().func_70694_bm() != null && accessor.getPlayer().func_70694_bm().func_77973_b() == ModItems.itemSeerSigil;
                hasSigil = hasSeer || accessor.getPlayer().func_70694_bm() != null && accessor.getPlayer().func_70694_bm().func_77973_b() == ModItems.divinationSigil;
                break;
            }
        }
        hasSeer |= !WPConfigHandler.seerBenefit;
        TileEntity te = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (te instanceof TEAltar && this.getConfig("altar")) {
            TEAltar altar = (TEAltar)te;
            te.func_145839_a(tag);
            if (hasSigil) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                currenttip.add(lang.localize("currentLP") + (fluid == null ? "0" : Integer.valueOf(fluid.amount)));
                currenttip.add(lang.localize("capacity") + tag.func_74762_e("capacity"));
                currenttip.add(lang.localize("tier") + tag.func_74762_e("upgradeLevel"));
                if (hasSeer && altar.func_70301_a(0) != null) {
                    int cur = tag.func_74762_e("progress");
                    int max = tag.func_74762_e("liquidRequired") * altar.func_70301_a((int)0).field_77994_a;
                    currenttip.add(lang.localize("progress") + (int)((double)cur / (double)max * 100.0) + "%");
                }
            }
        }
        if (te instanceof TEWritingTable && this.getConfig("chemistrySet")) {
            TEWritingTable chemistrySet = (TEWritingTable)te;
            te.func_145839_a(tag);
            currenttip.add(lang.localize("progress") + tag.func_74762_e("progress") + "%");
            if (chemistrySet.getResultingItemStack() != null) {
                currenttip.add(chemistrySet.getResultingItemStack().func_82833_r());
            }
        }
        if (te instanceof TEMasterStone && this.getConfig("masterStone")) {
            String ritualName;
            String owner = tag.func_74779_i("owner");
            if (!Strings.isNullOrEmpty((String)owner)) {
                currenttip.add(lang.localize("owner") + tag.func_74779_i("owner"));
            }
            if (!Strings.isNullOrEmpty((String)(ritualName = tag.func_74779_i("currentRitualString")))) {
                currenttip.add(Rituals.getNameOfRitual((String)ritualName));
            }
        }
        if (te instanceof TETeleposer && this.getConfig("teleposer")) {
            TETeleposer teleposer = (TETeleposer)te;
            te.func_145839_a(tag);
            if (teleposer.func_70301_a(0) != null) {
                currenttip.add(teleposer.func_70301_a(0).func_82833_r());
            }
        }
    }

    private ItemStack searchInventory(Item item, EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            return stack.func_77946_l();
        }
        return null;
    }
}

