/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import thermalexpansion.ThermalExpansion;
import thermalfoundation.item.TFItems;

public class FurnaceManager {
    private static Map<ComparableItemStackSafe, RecipeFurnace> recipeMap = new THashMap();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;
    private static Set<Block> handledBlocks = new THashSet();

    public static RecipeFurnace getRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        RecipeFurnace recipeFurnace = recipeMap.get(query.set(itemStack));
        if (recipeFurnace == null) {
            FurnaceManager.query.metadata = Short.MAX_VALUE;
            recipeFurnace = recipeMap.get(query);
        }
        return recipeFurnace;
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return FurnaceManager.getRecipe(itemStack) != null;
    }

    public static RecipeFurnace[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeFurnace[0]);
    }

    public static void addDefaultRecipes() {
        int n;
        FurnaceManager.addTERecipe(800, new ItemStack(Blocks.field_150434_aF), new ItemStack(Items.field_151100_aR, 1, 2));
        FurnaceManager.addTERecipe(400, new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am));
        FurnaceManager.addTERecipe(400, new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be));
        FurnaceManager.addTERecipe(400, new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg));
        FurnaceManager.addTERecipe(400, new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH));
        for (n = 0; n < 2; ++n) {
            FurnaceManager.addTERecipe(400, new ItemStack(Items.field_151115_aP, 1, n), new ItemStack(Items.field_151101_aQ, 1, n));
        }
        n = 1600;
        FurnaceManager.addOreDictRecipe("oreIron", TFItems.ingotIron);
        FurnaceManager.addOreDictRecipe("oreGold", TFItems.ingotGold);
        FurnaceManager.addOreDictRecipe("oreCopper", TFItems.ingotCopper);
        FurnaceManager.addOreDictRecipe("oreTin", TFItems.ingotTin);
        FurnaceManager.addOreDictRecipe("oreSilver", TFItems.ingotSilver);
        FurnaceManager.addOreDictRecipe("oreLead", TFItems.ingotLead);
        FurnaceManager.addOreDictRecipe("oreNickel", TFItems.ingotNickel);
        FurnaceManager.addOreDictRecipe("orePlatinum", TFItems.ingotPlatinum);
        FurnaceManager.addOreDictRecipe("oreCoal", new ItemStack(Items.field_151044_h, 1, 0));
        FurnaceManager.addOreDictRecipe("oreDiamond", new ItemStack(Items.field_151045_i, 1, 0));
        FurnaceManager.addOreDictRecipe("oreEmerald", new ItemStack(Items.field_151166_bC, 1, 0));
        FurnaceManager.addOreDictRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 6, 4));
        FurnaceManager.addOreDictRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, 4, 0));
        FurnaceManager.addOreDictRecipe("oreQuartz", new ItemStack(Items.field_151128_bU, 1, 0));
        n = 1000;
        FurnaceManager.addOreDictRecipe(n, "dustIron", TFItems.ingotIron);
        FurnaceManager.addOreDictRecipe(n, "dustGold", TFItems.ingotGold);
        FurnaceManager.addOreDictRecipe(n, "dustCopper", TFItems.ingotCopper);
        FurnaceManager.addOreDictRecipe(n, "dustTin", TFItems.ingotTin);
        FurnaceManager.addOreDictRecipe(n, "dustSilver", TFItems.ingotSilver);
        FurnaceManager.addOreDictRecipe(n, "dustLead", TFItems.ingotLead);
        FurnaceManager.addOreDictRecipe(n, "dustNickel", TFItems.ingotNickel);
        FurnaceManager.addOreDictRecipe(n, "dustPlatinum", TFItems.ingotPlatinum);
        FurnaceManager.addOreDictRecipe(n, "dustElectrum", TFItems.ingotElectrum);
        FurnaceManager.addOreDictRecipe(n, "dustInvar", TFItems.ingotInvar);
        FurnaceManager.addOreDictRecipe(n, "dustBronze", TFItems.ingotBronze);
    }

    public static void loadRecipes() {
        Map map = FurnaceRecipes.func_77602_a().func_77599_b();
        for (ItemStack itemStack : map.keySet()) {
            ItemStack itemStack2;
            if (itemStack == null || FurnaceManager.recipeExists(itemStack) || (itemStack2 = (ItemStack)map.get(itemStack)) == null || handledBlocks.contains(Block.func_149634_a((Item)itemStack.func_77973_b()))) continue;
            int n = 1600;
            if (itemStack.func_77973_b() instanceof ItemFood) {
                n /= 2;
            }
            if (itemStack2.func_77973_b() instanceof ItemFood) {
                n /= 2;
            }
            if (ItemHelper.isDust((ItemStack)itemStack) && ItemHelper.isIngot((ItemStack)itemStack2)) {
                FurnaceManager.addRecipe(n * 10 / 16, itemStack, itemStack2, false);
                continue;
            }
            FurnaceManager.addRecipe(n, itemStack, itemStack2, false);
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSafe, RecipeFurnace> entry : recipeMap.entrySet()) {
            RecipeFurnace recipeFurnace = entry.getValue();
            tHashMap.put(new ComparableItemStackSafe(recipeFurnace.input), recipeFurnace);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeFurnace recipeFurnace = new RecipeFurnace(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeFurnace);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && recipeMap.get(query.set(itemStack)) != null) {
            return false;
        }
        RecipeFurnace recipeFurnace = new RecipeFurnace(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeFurnace);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove(new ComparableItemStackSafe(itemStack)) != null;
    }

    public static void addOreDictRecipe(String string, ItemStack itemStack) {
        FurnaceManager.addOreDictRecipe(1600, string, itemStack);
    }

    public static void addOreDictRecipe(int n, String string, ItemStack itemStack) {
        if (ItemHelper.oreNameExists((String)string)) {
            FurnaceManager.addRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionaryArbiter.getOres((String)string).get(0)), (int)1), itemStack, false);
        }
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Furnace.AllowRecipeOverwrite", false);
        handledBlocks.add(Blocks.field_150352_o);
        handledBlocks.add(Blocks.field_150366_p);
        handledBlocks.add(Blocks.field_150365_q);
        handledBlocks.add(Blocks.field_150482_ag);
        handledBlocks.add(Blocks.field_150412_bA);
        handledBlocks.add(Blocks.field_150369_x);
        handledBlocks.add(Blocks.field_150450_ax);
        handledBlocks.add(Blocks.field_150449_bY);
    }

    public static class RecipeFurnace {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        RecipeFurnace(ItemStack itemStack, ItemStack itemStack2, int n) {
            this.input = itemStack;
            this.output = itemStack2;
            this.energy = n;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

