/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.light.BlockLight;
import thermalexpansion.block.light.TileLight;
import thermalexpansion.core.TEProps;

public class RenderLight
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderLight instance = new RenderLight();
    static final int NUM_RENDERS = 2;
    static IIcon[] textureFrame = new IIcon[2];
    static IIcon[] textureCenter = new IIcon[2];
    static IIcon textureHalo;
    static CCModel[] modelFrame;
    static CCModel[] modelCenter;
    static CCModel[] modelHalo;

    public static void initialize() {
        for (int i = 0; i < 2; ++i) {
            RenderLight.textureFrame[i] = IconRegistry.getIcon((String)"Light", (int)i);
        }
        RenderLight.textureCenter[0] = IconRegistry.getIcon((String)"FluidGlowstone");
        RenderLight.textureCenter[1] = IconRegistry.getIcon((String)"LightEffect");
        textureHalo = IconRegistry.getIcon((String)"LightHalo");
    }

    private static void generateModels() {
        double d = 9.765625E-4;
        double d2 = 2.0 * d;
        double d3 = 0.0625;
        RenderLight.modelFrame[0] = CCModel.quadModel((int)24).generateBlock(0, d, d, d, 1.0 - d, 1.0 - d, 1.0 - d).computeNormals();
        RenderLight.modelFrame[1] = CCModel.quadModel((int)24).generateBlock(0, d, d, d, 1.0 - d, 1.0 - d, 1.0 - d).computeNormals();
        RenderLight.modelCenter[0] = CCModel.quadModel((int)24).generateBlock(0, d2, d2, d2, 1.0 - d2, 1.0 - d2, 1.0 - d2).computeNormals();
        RenderLight.modelHalo[1] = CCModel.quadModel((int)24).generateBlock(0, -d3, -d3, -d3, 1.0 + d3, 1.0 + d3, 1.0 + d3).computeNormals().shrinkUVs(d3);
    }

    public void renderCenter(int n, boolean bl, double d, double d2, double d3) {
        if (bl) {
            modelCenter[n].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureCenter[1]));
        } else {
            modelCenter[n].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureCenter[0]));
        }
    }

    public void renderFrame(int n, double d, double d2, double d3) {
        modelFrame[n].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureFrame[n]));
    }

    public void renderHalo(int n, double d, double d2, double d3) {
        modelHalo[n].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureHalo));
    }

    public boolean renderWorldIlluminator(int n, boolean bl, double d, double d2, double d3) {
        if (BlockCoFHBase.renderPass == 0) {
            return false;
        }
        modelCenter[0].setColour(n);
        this.renderCenter(0, bl, d, d2, d3);
        modelCenter[0].setColour(-1);
        this.renderFrame(0, d, d2, d3);
        return true;
    }

    public boolean renderWorldLampHalo(int n, boolean bl, double d, double d2, double d3) {
        if (BlockCoFHBase.renderPass == 0) {
            modelFrame[1].setColour(n);
            this.renderFrame(1, d, d2, d3);
            modelFrame[1].setColour(-1);
            return true;
        }
        if (bl) {
            modelHalo[1].setColour(n - 128);
            this.renderHalo(1, d, d2, d3);
            modelHalo[1].setColour(-1);
        }
        return bl;
    }

    public boolean renderWorldLampBasic(int n, boolean bl, double d, double d2, double d3) {
        if (BlockCoFHBase.renderPass == 0) {
            modelFrame[1].setColour(n);
            this.renderFrame(1, d, d2, d3);
            modelFrame[1].setColour(-1);
            return true;
        }
        return BlockCoFHBase.renderPass == 0;
    }

    public void renderItemIlluminator(int n, boolean bl, double d) {
        CCRenderState.startDrawing();
        modelCenter[0].setColour(n);
        this.renderCenter(0, bl, d, d, d);
        modelCenter[0].setColour(-1);
        CCRenderState.draw();
        CCRenderState.startDrawing();
        this.renderFrame(0, d, d, d);
        CCRenderState.draw();
    }

    public void renderItemLampBasic(int n, double d) {
        CCRenderState.startDrawing();
        modelFrame[1].setColour(n);
        this.renderFrame(1, d, d, d);
        modelFrame[1].setColour(-1);
        CCRenderState.draw();
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileLight)) {
            return false;
        }
        TileLight tileLight = (TileLight)tileEntity;
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        int n6 = tileLight.getColorMultiplier();
        boolean bl = tileLight.modified;
        boolean bl2 = tileLight.getInternalLight() > 0;
        switch (BlockLight.Types.values()[n5]) {
            case ILLUMINATOR: 
            case ILLUMINATOR_DIM: {
                return this.renderWorldIlluminator(n6, bl, n, n2, n3);
            }
            case LAMP_HALO: 
            case LAMP_HALO_DIM: {
                return this.renderWorldLampHalo(n6, bl2, n, n2, n3);
            }
            case LAMP_BASIC: 
            case LAMP_BASIC_DIM: {
                return this.renderWorldLampBasic(n6, bl2, n, n2, n3);
            }
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int n) {
        return false;
    }

    public int getRenderId() {
        return TEProps.renderIdLight;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        }
        int n = itemStack.func_77960_j();
        int n2 = -1;
        if (itemStack.func_77942_o()) {
            n2 = itemStack.func_77978_p().func_74762_e("Color");
            n2 = (n2 << 8) + 255;
        }
        RenderUtils.preItemRender();
        RenderHelper.setBlockTextureSheet();
        switch (BlockLight.Types.values()[n]) {
            case ILLUMINATOR: 
            case ILLUMINATOR_DIM: {
                this.renderItemIlluminator(n2, itemStack.func_77942_o(), d);
                break;
            }
            case LAMP_HALO: 
            case LAMP_HALO_DIM: 
            case LAMP_BASIC: 
            case LAMP_BASIC_DIM: {
                this.renderItemLampBasic(n2, d);
            }
        }
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    static {
        modelFrame = new CCModel[2];
        modelCenter = new CCModel[2];
        modelHalo = new CCModel[2];
        TEProps.renderIdLight = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TEBlocks.blockLight), (IItemRenderer)instance);
        RenderLight.generateModels();
    }
}

