/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Translation;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.cell.BlockCell;
import thermalexpansion.block.cell.TileCell;
import thermalexpansion.core.TEProps;

@SideOnly(value=Side.CLIENT)
public class RenderCell
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderCell instance = new RenderCell();
    static IIcon[] textureCenter = new IIcon[2];
    static IIcon[] textureFrame = new IIcon[BlockCell.Types.values().length * 2];
    static CCModel modelCenter = CCModel.quadModel((int)24);
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public static void initialize() {
        RenderCell.textureCenter[0] = IconRegistry.getIcon((String)"StorageRedstone");
        RenderCell.textureCenter[1] = IconRegistry.getIcon((String)"FluidRedstone");
        for (int i = 0; i < textureFrame.length; ++i) {
            RenderCell.textureFrame[i] = IconRegistry.getIcon((String)"Cell", (int)i);
        }
    }

    public void renderCenter(int n, double d, double d2, double d3) {
        if (n == 1 || n == 2) {
            modelCenter.render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureCenter[0]));
        } else {
            modelCenter.render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)textureCenter[1]));
        }
    }

    public void renderFrame(int n, TileCell tileCell, double d, double d2, double d3) {
        int n2;
        Translation translation = RenderUtils.getRenderVector((double)d, (double)d2, (double)d3).translation();
        for (n2 = 0; n2 < 6; ++n2) {
            modelFrame.render(n2 * 4, n2 * 4 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureFrame[2 * n])});
            modelFrame.render(n2 * 4 + 24, n2 * 4 + 28, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureFrame[2 * n + 1])});
        }
        if (tileCell != null) {
            for (n2 = 0; n2 < 6; ++n2) {
                modelFrame.render(n2 * 4, n2 * 4 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)tileCell.getTexture(n2, 2))});
            }
            n2 = tileCell.getFacing();
            modelFrame.render(n2 * 4, n2 * 4 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)tileCell.getTexture(n2, 3))});
        }
    }

    private int getScaledEnergyStored(ItemStack itemStack, int n) {
        IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)itemStack.func_77973_b();
        return iEnergyContainerItem.getEnergyStored(itemStack) * n / iEnergyContainerItem.getMaxEnergyStored(itemStack);
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileCell)) {
            return false;
        }
        TileCell tileCell = (TileCell)tileEntity;
        int n5 = Math.min(15, tileCell.getScaledEnergyStored(16));
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(tileCell.type, tileCell, n, n2, n3);
        } else {
            CCRenderState.setBrightness((int)(165 + n5 * 5));
            this.renderCenter(tileCell.type, n, n2, n3);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdCell;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        }
        int n = 0;
        if (itemStack.field_77990_d != null) {
            n = Math.min(15, this.getScaledEnergyStored(itemStack, 16));
        }
        int n2 = itemStack.func_77960_j();
        RenderUtils.preItemRender();
        CCRenderState.startDrawing();
        this.renderFrame(n2, null, d, d, d);
        CCRenderState.draw();
        CCRenderState.startDrawing();
        CCRenderState.setBrightness((int)(165 + n * 5));
        this.renderCenter(n2, d, d, d);
        CCRenderState.draw();
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    static {
        TEProps.renderIdCell = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TEBlocks.blockCell), (IItemRenderer)instance);
        modelCenter.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        Cuboid6 cuboid6 = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        double d = 0.1875;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, cuboid6);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            RenderCell.modelFrame.verts[i].vec.add(modelFrame.normals()[i].copy().multiply(d));
        }
        modelFrame.computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
    }
}

