/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.container;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.util.CoreUtils;
import cofh.core.util.SocialRegistry;
import cofh.lib.gui.container.ContainerInventoryItem;
import cofh.lib.gui.slot.ISlotValidator;
import cofh.lib.gui.slot.SlotValidated;
import cofh.lib.gui.slot.SlotViewOnly;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cpw.mods.fml.common.Optional;
import gnu.trove.map.hash.THashMap;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thermalexpansion.item.ItemSatchel;
import thermalexpansion.network.PacketTEBase;

@ChestContainer
public class ContainerSatchel
extends ContainerInventoryItem
implements ISecurable,
ISlotValidator {
    int storageIndex;
    int rowSize;

    public ContainerSatchel(ItemStack itemStack, InventoryPlayer inventoryPlayer) {
        super(itemStack, inventoryPlayer);
        this.storageIndex = ItemSatchel.getStorageIndex(itemStack);
        this.rowSize = MathHelper.clampI((int)(this.storageIndex + 1), (int)9, (int)13);
        int n = MathHelper.clampI((int)this.storageIndex, (int)2, (int)8);
        int n2 = this.rowSize * n;
        int n3 = 17;
        this.addPlayerSlotsToContainer(inventoryPlayer, 8 + 9 * (this.rowSize - 9), n);
        if (this.storageIndex == 0) {
            this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, 0, 80, 26));
            this.rowSize = 1;
        } else if (this.storageIndex == 1) {
            n3 += 9;
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, n3 + i / this.rowSize * 18));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, n3 + i / this.rowSize * 18));
            }
        }
    }

    private void addPlayerSlotsToContainer(InventoryPlayer inventoryPlayer, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 3; ++n3) {
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, i + n3 * 9 + 9, n + i * 18, 30 + 18 * n2 + n3 * 18));
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            if (n3 == inventoryPlayer.field_70461_c) {
                this.func_75146_a((Slot)new SlotViewOnly((IInventory)inventoryPlayer, n3, n + n3 * 18, 88 + 18 * n2));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, n3, n + n3 * 18, 88 + 18 * n2));
        }
    }

    @Optional.Method(modid="inventorytweaks")
    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return this.rowSize;
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        THashMap tHashMap = new THashMap();
        tHashMap.put(ContainerSection.INVENTORY, ((Container)this).field_75151_b.subList(0, 36));
        tHashMap.put(ContainerSection.INVENTORY_NOT_HOTBAR, ((Container)this).field_75151_b.subList(0, 27));
        tHashMap.put(ContainerSection.INVENTORY_HOTBAR, ((Container)this).field_75151_b.subList(27, 36));
        tHashMap.put(ContainerSection.CHEST, ((Container)this).field_75151_b.subList(36, ((Container)this).field_75151_b.size()));
        return tHashMap;
    }

    public boolean setAccess(ISecurable.AccessMode accessMode) {
        if (SecurityHelper.setAccess((ItemStack)this.getContainerStack(), (ISecurable.AccessMode)accessMode)) {
            this.onSlotChanged();
            if (CoreUtils.isClient()) {
                PacketTEBase.sendSecurityPacketToServer(this);
            }
            return true;
        }
        return false;
    }

    public boolean setOwnerName(String string) {
        if (SecurityHelper.setOwnerName((ItemStack)this.getContainerStack(), (String)string)) {
            this.onSlotChanged();
            return true;
        }
        return false;
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.getContainerStack());
    }

    public String getOwnerName() {
        return SecurityHelper.getOwnerName((ItemStack)this.getContainerStack());
    }

    public boolean canPlayerAccess(String string) {
        ISecurable.AccessMode accessMode = this.getAccess();
        String string2 = this.getOwnerName();
        return accessMode.isPublic() || CoFHProps.enableOpSecureAccess && CoreUtils.isOp((String)string) || string2.equals("[None]") || string2.equals(string) || accessMode.isRestricted() && SocialRegistry.playerHasAccess((String)string, (String)string2);
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.containerWrapper.func_94041_b(0, itemStack);
    }
}

