/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiCharger;
import thermalexpansion.gui.container.machine.ContainerCharger;

public class TileCharger
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.CHARGER.ordinal();
    int outputTracker;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileCharger.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].numGroup = 3;
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}};
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].allowExtraction = new boolean[]{false, true, true};
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].sideTex = new int[]{0, 1, 4};
        TileMachineBase.defaultSideConfig[TileCharger.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Charger.BasePower", 10000), (int)100, (int)20000);
        ThermalExpansion.config.set("block.tweak", "Machine.Charger.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileCharger.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParams(1, n, Math.max(480000, n * 60));
        GameRegistry.registerTileEntity(TileCharger.class, (String)"thermalexpansion.Charger");
    }

    public TileCharger() {
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        if (this.isActive) {
            int n = Math.min(this.energyStorage.getEnergyStored(), this.calcEnergy());
            if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
                IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)this.inventory[0].func_77973_b();
                this.energyStorage.extractEnergy(iEnergyContainerItem.receiveEnergy(this.inventory[0], n, false), false);
                if (iEnergyContainerItem.getEnergyStored(this.inventory[0]) >= iEnergyContainerItem.getMaxEnergyStored(this.inventory[0]) || this.energyStorage.getEnergyStored() > 0 && n <= 0) {
                    this.processFinish();
                    this.transferProducts();
                    if (!this.redstoneControlOrDisable() || !this.canStart()) {
                        this.isActive = false;
                        this.wasActive = true;
                        this.tracker.markTime(((TileEntity)this).field_145850_b);
                    }
                }
            } else if (this.energyStorage.getEnergyStored() <= 0 || this.inventory[1] == null) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.canStart()) {
                this.isActive = true;
            }
        }
        this.updateIfChanged(bl);
    }

    @Override
    protected int calcEnergy() {
        if (!this.isActive || this.inventory[0] == null) {
            return 0;
        }
        int n = 0;
        n = this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel ? this.energyConfig.maxPower : (this.energyStorage.getEnergyStored() < this.energyConfig.energyRamp ? this.energyConfig.minPower : this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp);
        return Math.min(n, ((IEnergyContainerItem)this.inventory[0].func_77973_b()).receiveEnergy(this.inventory[0], n, true));
    }

    @Override
    protected boolean canStart() {
        return this.inventory[1] == null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0]) && this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    public boolean hasChargeSlot() {
        return false;
    }

    @Override
    protected void processFinish() {
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
        if (--this.inventory[0].field_77994_a < 1) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(1, 1, n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        return itemStack == null ? false : itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCharger(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerCharger(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
    }

    @Override
    public int getInfoEnergyPerTick() {
        return this.calcEnergy();
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }
}

