/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.machine.ItemBlockMachine;
import thermalexpansion.block.machine.TileAccumulator;
import thermalexpansion.block.machine.TileAssembler;
import thermalexpansion.block.machine.TileCharger;
import thermalexpansion.block.machine.TileCrucible;
import thermalexpansion.block.machine.TileExtruder;
import thermalexpansion.block.machine.TileFurnace;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TilePrecipitator;
import thermalexpansion.block.machine.TilePulverizer;
import thermalexpansion.block.machine.TileSawmill;
import thermalexpansion.block.machine.TileSmelter;
import thermalexpansion.block.machine.TileTransposer;
import thermalexpansion.block.simple.BlockFrame;
import thermalexpansion.item.TEAugments;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.ReconfigurableHelper;
import thermalexpansion.util.crafting.RecipeMachine;
import thermalexpansion.util.crafting.TECraftingHandler;

public class BlockMachine
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"furnace", "pulverizer", "sawmill", "smelter", "crucible", "transposer", "precipitator", "extruder", "accumulator", "assembler", "charger"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static boolean[] creativeTiers = new boolean[4];
    public static ItemStack[] defaultAugments = new ItemStack[3];
    public static boolean defaultAutoTransfer = true;
    public static boolean defaultRedstoneControl = true;
    public static boolean defaultReconfigSides = true;
    public static ItemStack furnace;
    public static ItemStack pulverizer;
    public static ItemStack sawmill;
    public static ItemStack smelter;
    public static ItemStack crucible;
    public static ItemStack transposer;
    public static ItemStack precipitator;
    public static ItemStack extruder;
    public static ItemStack accumulator;
    public static ItemStack assembler;
    public static ItemStack charger;

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.machine");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case FURNACE: {
                return new TileFurnace();
            }
            case PULVERIZER: {
                return new TilePulverizer();
            }
            case SAWMILL: {
                return new TileSawmill();
            }
            case SMELTER: {
                return new TileSmelter();
            }
            case CRUCIBLE: {
                return new TileCrucible();
            }
            case TRANSPOSER: {
                return new TileTransposer();
            }
            case PRECIPITATOR: {
                return new TilePrecipitator();
            }
            case EXTRUDER: {
                return new TileExtruder();
            }
            case ACCUMULATOR: {
                return new TileAccumulator();
            }
            case ASSEMBLER: {
                return new TileAssembler();
            }
            case CHARGER: {
                return new TileCharger();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        int n;
        for (n = 0; n < Types.values().length - 4; ++n) {
            if (!enable[n]) continue;
            for (int i = 0; i < 4; ++i) {
                if (!creativeTiers[i]) continue;
                list.add(ItemBlockMachine.setDefaultTag(new ItemStack(item, 1, n), (byte)i));
            }
        }
        for (n = Types.values().length - 4; n < Types.values().length; ++n) {
            if (!enable[n]) continue;
            list.add(ItemBlockMachine.setDefaultTag(new ItemStack(item, 1, n), (byte)0));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            TileMachineBase tileMachineBase = (TileMachineBase)world.func_147438_o(n, n2, n3);
            tileMachineBase.readAugmentsFromNBT(itemStack.field_77990_d);
            tileMachineBase.installAugments();
            tileMachineBase.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            int n4 = BlockHelper.determineXZPlaceFacing((EntityLivingBase)entityLivingBase);
            byte by = ReconfigurableHelper.getFacing(itemStack);
            byte[] byArray = ReconfigurableHelper.getSideCache(itemStack, tileMachineBase.getDefaultSides());
            tileMachineBase.sideCache[0] = byArray[0];
            tileMachineBase.sideCache[1] = byArray[1];
            tileMachineBase.sideCache[n4] = 0;
            tileMachineBase.sideCache[BlockHelper.getLeftSide((int)n4)] = byArray[BlockHelper.getLeftSide((int)by)];
            tileMachineBase.sideCache[BlockHelper.getRightSide((int)n4)] = byArray[BlockHelper.getRightSide((int)by)];
            tileMachineBase.sideCache[BlockHelper.getOppositeSide((int)n4)] = byArray[BlockHelper.getOppositeSide((int)by)];
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    @Override
    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if ((tileEntity instanceof TileExtruder || tileEntity instanceof TilePrecipitator) && FluidHelper.fillHandlerWithContainer((World)world, (IFluidHandler)((IFluidHandler)tileEntity), (EntityPlayer)entityPlayer)) {
            return true;
        }
        return super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isNormalCube(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        ISidedTexture iSidedTexture = (ISidedTexture)iBlockAccess.func_147438_o(n, n2, n3);
        return iSidedTexture == null ? null : iSidedTexture.getTexture(n4, BlockCoFHBase.renderPass);
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        if (n == 0) {
            return IconRegistry.getIcon((String)"MachineBottom");
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"MachineTop");
        }
        return n != 3 ? IconRegistry.getIcon((String)"MachineSide") : IconRegistry.getIcon((String)("MachineFace" + n2));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"MachineBottom", (String)"thermalexpansion:machine/Machine_Bottom", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"MachineTop", (String)"thermalexpansion:machine/Machine_Top", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"MachineSide", (String)"thermalexpansion:machine/Machine_Side", (IIconRegister)iIconRegister);
        for (int i = 0; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("MachineFace" + i), (String)("thermalexpansion:machine/Machine_Face_" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("MachineActive" + i), (String)("thermalexpansion:machine/Machine_Active_" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)iIconRegister);
        }
        IconRegistry.addIcon((String)"Config_0", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_1", (String)"thermalexpansion:config/Config_Blue", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_2", (String)"thermalexpansion:config/Config_Red", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_3", (String)"thermalexpansion:config/Config_Yellow", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_4", (String)"thermalexpansion:config/Config_Orange", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_5", (String)"thermalexpansion:config/Config_Green", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_6", (String)"thermalexpansion:config/Config_Purple", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_0", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_1", (String)"thermalexpansion:config/Config_Blue_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_2", (String)"thermalexpansion:config/Config_Red_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_3", (String)"thermalexpansion:config/Config_Yellow_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_4", (String)"thermalexpansion:config/Config_Orange_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_5", (String)"thermalexpansion:config/Config_Green_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Config_CB_6", (String)"thermalexpansion:config/Config_Purple_CB", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileMachineBase tileMachineBase = (TileMachineBase)world.func_147438_o(n, n2, n3);
        if (tileMachineBase != null) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileMachineBase);
            nBTTagCompound.func_74768_a("Energy", tileMachineBase.getEnergyStored(ForgeDirection.UNKNOWN));
            tileMachineBase.writeAugmentsToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public boolean initialize() {
        TileMachineBase.configure();
        TileFurnace.initialize();
        TilePulverizer.initialize();
        TileSawmill.initialize();
        TileSmelter.initialize();
        TileCrucible.initialize();
        TileTransposer.initialize();
        TilePrecipitator.initialize();
        TileExtruder.initialize();
        TileAccumulator.initialize();
        TileAssembler.initialize();
        TileCharger.initialize();
        if (defaultAutoTransfer) {
            BlockMachine.defaultAugments[0] = ItemHelper.cloneStack((ItemStack)TEAugments.generalAutoTransfer);
        }
        if (defaultRedstoneControl) {
            BlockMachine.defaultAugments[1] = ItemHelper.cloneStack((ItemStack)TEAugments.generalRedstoneControl);
        }
        if (defaultReconfigSides) {
            BlockMachine.defaultAugments[2] = ItemHelper.cloneStack((ItemStack)TEAugments.generalReconfigSides);
        }
        furnace = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.FURNACE.ordinal()));
        pulverizer = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.PULVERIZER.ordinal()));
        sawmill = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.SAWMILL.ordinal()));
        smelter = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.SMELTER.ordinal()));
        crucible = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.CRUCIBLE.ordinal()));
        transposer = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.TRANSPOSER.ordinal()));
        precipitator = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.PRECIPITATOR.ordinal()));
        extruder = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.EXTRUDER.ordinal()));
        accumulator = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.ACCUMULATOR.ordinal()));
        assembler = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.ASSEMBLER.ordinal()));
        charger = ItemBlockMachine.setDefaultTag(new ItemStack((Block)this, 1, Types.CHARGER.ordinal()));
        GameRegistry.registerCustomItemStack((String)"furnace", (ItemStack)furnace);
        GameRegistry.registerCustomItemStack((String)"pulverizer", (ItemStack)pulverizer);
        GameRegistry.registerCustomItemStack((String)"sawmill", (ItemStack)sawmill);
        GameRegistry.registerCustomItemStack((String)"smelter", (ItemStack)smelter);
        GameRegistry.registerCustomItemStack((String)"crucible", (ItemStack)crucible);
        GameRegistry.registerCustomItemStack((String)"transposer", (ItemStack)transposer);
        GameRegistry.registerCustomItemStack((String)"precipitator", (ItemStack)precipitator);
        GameRegistry.registerCustomItemStack((String)"extruder", (ItemStack)extruder);
        GameRegistry.registerCustomItemStack((String)"accumulator", (ItemStack)accumulator);
        GameRegistry.registerCustomItemStack((String)"assembler", (ItemStack)assembler);
        GameRegistry.registerCustomItemStack((String)"charger", (ItemStack)charger);
        String string = "tweak.recipe";
        String string2 = "If enabled, Machines use ingots instead of gears in their default recipes.";
        String string3 = ThermalExpansion.config.get(string, "Machines.UseIngots", false, string2) ? "ingot" : "gear";
        for (String string4 : Arrays.asList("Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Mithril", "Electrum", "Invar", "Bronze", "Signalum", "Lumium", "Enderium")) {
            String string5 = "thermalexpansion:machine";
            ArrayList arrayList = OreDictionary.getOres((String)(string3 + string4));
            for (int i = 0; i < arrayList.size(); ++i) {
                OreDictionary.registerOre((String)(string5 + string4), (ItemStack)((ItemStack)arrayList.get(i)));
            }
        }
        return true;
    }

    public boolean postInit() {
        String string = "thermalexpansion:machineFrame";
        String string2 = "thermalexpansion:machineCopper";
        if (enable[Types.FURNACE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(furnace, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), Blocks.field_150336_V}));
        }
        if (enable[Types.PULVERIZER.ordinal()]) {
            String string3 = "tweak.recipe";
            String string4 = "If enabled, The pulverizer will use diamonds instead of flint.";
            Item item = ThermalExpansion.config.get(string3, "Pulverizer.AddDiamonds", false, string4) ? Items.field_151045_i : Items.field_151145_ak;
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(pulverizer, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), item}));
        }
        if (enable[Types.SAWMILL.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(sawmill, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Items.field_151036_c, Character.valueOf('Y'), "plankWood"}));
        }
        if (enable[Types.SMELTER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(smelter, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "ingotInvar"}));
        }
        if (enable[Types.CRUCIBLE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(crucible, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), BlockFrame.frameCellBasic, Character.valueOf('Y'), Blocks.field_150385_bj}));
        }
        if (enable[Types.TRANSPOSER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(transposer, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"}));
        }
        if (enable[Types.PRECIPITATOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(precipitator, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), string, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), Blocks.field_150433_aE}));
        }
        if (enable[Types.EXTRUDER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(extruder, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), BlockFrame.frameMachineBasic, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "blockGlass"}));
        }
        if (enable[Types.ACCUMULATOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(accumulator, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), BlockFrame.frameMachineBasic, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"}));
        }
        if (enable[Types.ASSEMBLER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(assembler, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), BlockFrame.frameMachineBasic, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Blocks.field_150486_ae, Character.valueOf('Y'), "gearTin"}));
        }
        if (enable[Types.CHARGER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeMachine(charger, defaultAugments, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), BlockFrame.frameMachineBasic, Character.valueOf('I'), string2, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), BlockFrame.frameCellBasic, Character.valueOf('Y'), TEItems.powerCoilSilver}));
        }
        TECraftingHandler.addMachineUpgradeRecipes(furnace);
        TECraftingHandler.addMachineUpgradeRecipes(pulverizer);
        TECraftingHandler.addMachineUpgradeRecipes(sawmill);
        TECraftingHandler.addMachineUpgradeRecipes(smelter);
        TECraftingHandler.addMachineUpgradeRecipes(crucible);
        TECraftingHandler.addMachineUpgradeRecipes(transposer);
        TECraftingHandler.addMachineUpgradeRecipes(precipitator);
        TECraftingHandler.addSecureRecipe(furnace);
        TECraftingHandler.addSecureRecipe(pulverizer);
        TECraftingHandler.addSecureRecipe(sawmill);
        TECraftingHandler.addSecureRecipe(smelter);
        TECraftingHandler.addSecureRecipe(crucible);
        TECraftingHandler.addSecureRecipe(transposer);
        TECraftingHandler.addSecureRecipe(precipitator);
        TECraftingHandler.addSecureRecipe(extruder);
        TECraftingHandler.addSecureRecipe(accumulator);
        TECraftingHandler.addSecureRecipe(assembler);
        TECraftingHandler.addSecureRecipe(charger);
        return true;
    }

    public static void refreshItemStacks() {
        furnace = ItemBlockMachine.setDefaultTag(furnace);
        pulverizer = ItemBlockMachine.setDefaultTag(pulverizer);
        sawmill = ItemBlockMachine.setDefaultTag(sawmill);
        smelter = ItemBlockMachine.setDefaultTag(smelter);
        crucible = ItemBlockMachine.setDefaultTag(crucible);
        transposer = ItemBlockMachine.setDefaultTag(transposer);
        precipitator = ItemBlockMachine.setDefaultTag(precipitator);
        extruder = ItemBlockMachine.setDefaultTag(extruder);
        accumulator = ItemBlockMachine.setDefaultTag(accumulator);
        assembler = ItemBlockMachine.setDefaultTag(assembler);
        charger = ItemBlockMachine.setDefaultTag(charger);
    }

    static {
        String string = "block.feature";
        BlockMachine.enable[Types.FURNACE.ordinal()] = ThermalExpansion.config.get(string, "Machine.Furnace", true);
        BlockMachine.enable[Types.PULVERIZER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Pulverizer", true);
        BlockMachine.enable[Types.SAWMILL.ordinal()] = ThermalExpansion.config.get(string, "Machine.Sawmill", true);
        BlockMachine.enable[Types.SMELTER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Smelter", true);
        BlockMachine.enable[Types.CRUCIBLE.ordinal()] = ThermalExpansion.config.get(string, "Machine.Crucible", true);
        BlockMachine.enable[Types.TRANSPOSER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Transposer", true);
        BlockMachine.enable[Types.PRECIPITATOR.ordinal()] = ThermalExpansion.config.get(string, "Machine.Precipitator", true);
        BlockMachine.enable[Types.EXTRUDER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Extruder", true);
        BlockMachine.enable[Types.ACCUMULATOR.ordinal()] = ThermalExpansion.config.get(string, "Machine.Accumulator", true);
        BlockMachine.enable[Types.ASSEMBLER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Assembler", true);
        BlockMachine.enable[Types.CHARGER.ordinal()] = ThermalExpansion.config.get(string, "Machine.Charger", true);
        string = "block.tweak";
        defaultAutoTransfer = ThermalExpansion.config.get(string, "Machines.DefaultAugments.AutoTransfer", true);
        defaultRedstoneControl = ThermalExpansion.config.get(string, "Machines.DefaultAugments.RedstoneControl", true);
        defaultReconfigSides = ThermalExpansion.config.get(string, "Machines.DefaultAugments.ReconfigSides", true);
        BlockMachine.creativeTiers[0] = ThermalExpansion.config.get(string, "CreativeTab.Machines.Tier0", false);
        BlockMachine.creativeTiers[1] = ThermalExpansion.config.get(string, "CreativeTab.Machines.Tier1", false);
        BlockMachine.creativeTiers[2] = ThermalExpansion.config.get(string, "CreativeTab.Machines.Tier2", false);
        BlockMachine.creativeTiers[3] = ThermalExpansion.config.get(string, "CreativeTab.Machines.Tier3", true);
    }

    public static enum Types {
        FURNACE,
        PULVERIZER,
        SAWMILL,
        SMELTER,
        CRUCIBLE,
        TRANSPOSER,
        PRECIPITATOR,
        EXTRUDER,
        ACCUMULATOR,
        ASSEMBLER,
        CHARGER;

    }
}

