/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.EnergyHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import thermalexpansion.block.TileRSControl;

public abstract class TilePowered
extends TileRSControl
implements IEnergyReceiver {
    protected EnergyStorage energyStorage = new EnergyStorage(0);

    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    public boolean hasChargeSlot() {
        return true;
    }

    protected void chargeEnergy() {
        int n = this.getChargeSlot();
        if (this.hasChargeSlot() && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[n])) {
            int n2 = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory[n].func_77973_b()).extractEnergy(this.inventory[n], n2, false), false);
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
        }
    }

    public final void setEnergyStored(int n) {
        this.energyStorage.setEnergyStored(n);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getScaledEnergyStored(int n) {
        return this.energyStorage.getEnergyStored() * n / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.energyStorage.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.energyStorage.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        int n = packetCoFHBase.getInt();
        if (!bl) {
            this.energyStorage.setEnergyStored(n);
        }
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.energyStorage.receiveEnergy(n, bl);
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }
}

