/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions.gui;

import brad16840.common.CustomPacket;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import java.util.ArrayList;

public class ClientState {

    public static class PermissionPlayerData
    implements CustomPacket.Serializable {
        public int allowState;
        public PermissionGroupState player;
        public ArrayList<PermissionGroupState> owner;
        public ArrayList<PermissionGroupState> admin;
        public ArrayList<PermissionGroupState> member;

        public PermissionPlayerData(int allowState, PermissionGroupState player) {
            this.allowState = allowState;
            this.player = player;
            this.owner = new ArrayList();
            this.admin = new ArrayList();
            this.member = new ArrayList();
        }

        public PermissionPlayerData(CustomPacket.CustomPacketReader reader) {
            this(reader.readInt(), reader.readSerializable(PermissionGroupState.class));
            int i;
            int size = reader.readInt();
            for (i = 0; i < size; ++i) {
                this.owner.add(reader.readSerializable(PermissionGroupState.class));
            }
            size = reader.readInt();
            for (i = 0; i < size; ++i) {
                this.admin.add(reader.readSerializable(PermissionGroupState.class));
            }
            size = reader.readInt();
            for (i = 0; i < size; ++i) {
                this.member.add(reader.readSerializable(PermissionGroupState.class));
            }
        }

        @Override
        public void write(CustomPacket packet) {
            packet.write(this.allowState).write(this.player).write(this.owner.size());
            for (PermissionGroupState group : this.owner) {
                packet.write(group);
            }
            packet.write(this.admin.size());
            for (PermissionGroupState group : this.admin) {
                packet.write(group);
            }
            packet.write(this.member.size());
            for (PermissionGroupState group : this.member) {
                packet.write(group);
            }
        }
    }

    public static class PermissionGroups
    implements CustomPacket.Serializable {
        public int allowState;
        public PermissionGroupState player;
        public ArrayList<PermissionGroupState> groups;
        public ArrayList<PermissionGroupState> players;
        public PermissionGroupState defaultGroup;

        public PermissionGroups() {
            this.groups = new ArrayList();
            this.players = new ArrayList();
        }

        public PermissionGroups(int allowState, PermissionGroupState player, PermissionGroupState defaultGroup) {
            this.allowState = allowState;
            this.player = player;
            this.defaultGroup = defaultGroup;
            this.groups = new ArrayList();
            this.players = new ArrayList();
        }

        public PermissionGroups(CustomPacket.CustomPacketReader reader) {
            this(reader.readInt(), reader.readSerializable(PermissionGroupState.class), reader.readSerializable(PermissionGroupState.class));
            int i;
            int size = reader.readInt();
            for (i = 0; i < size; ++i) {
                this.groups.add(reader.readSerializable(PermissionGroupState.class));
            }
            size = reader.readInt();
            for (i = 0; i < size; ++i) {
                this.players.add(reader.readSerializable(PermissionGroupState.class));
            }
        }

        @Override
        public void write(CustomPacket packet) {
            packet.write(this.allowState).write(this.player).write(this.defaultGroup).write(this.groups.size());
            for (PermissionGroupState group : this.groups) {
                packet.write(group);
            }
            packet.write(this.players.size());
            for (PermissionGroupState player : this.players) {
                packet.write(player);
            }
        }
    }

    public static class PermissionState
    extends PermissionGroupState
    implements CustomPacket.Serializable {
        public PermissionGroupState owner;
        public PermissionGroupState parent;
        public ArrayList<PermissionRuleState> rules;
        public int adminLevel;
        public int visibility;

        public PermissionState(String name, String id, int tempId, boolean canOpen, int visibility, PermissionGroupState owner, PermissionGroupState parent, int adminLevel) {
            super(name, id, tempId, canOpen);
            this.owner = owner;
            this.parent = parent;
            this.visibility = visibility;
            this.rules = new ArrayList();
            this.adminLevel = adminLevel;
        }

        public PermissionState(CustomPacket.CustomPacketReader reader) {
            this(reader.readString(), reader.readString(), reader.readInt(), reader.readBoolean(), reader.readInt(), reader.readSerializable(PermissionGroupState.class), reader.readSerializable(PermissionGroupState.class), reader.readInt());
            int ruleCount = reader.readInt();
            this.rules = new ArrayList();
            for (int i = 0; i < ruleCount; ++i) {
                this.rules.add(reader.readSerializable(PermissionRuleState.class));
            }
        }

        @Override
        public void write(CustomPacket packet) {
            super.write(packet);
            packet.write(this.visibility).write(this.owner).write(this.parent).write(this.adminLevel).write(this.rules.size());
            for (PermissionRuleState rule : this.rules) {
                packet.write(rule);
            }
        }
    }

    public static class PermissionRuleState
    implements CustomPacket.Serializable {
        public PermissionGroupState group;
        public static int clientTempId = -325;
        public boolean allowed;
        public int tempId;

        public PermissionRuleState(PermissionGroupState group, boolean allowed) {
            this.group = group;
            this.allowed = allowed;
            this.tempId = clientTempId--;
        }

        public PermissionRuleState(PermissionGroupState group, boolean allowed, int tempId) {
            this.group = group;
            this.allowed = allowed;
            this.tempId = tempId;
        }

        public PermissionRuleState(CustomPacket.CustomPacketReader reader) {
            this(reader.readSerializable(PermissionGroupState.class), reader.readBoolean(), reader.readInt());
        }

        @Override
        public void write(CustomPacket packet) {
            packet.write(this.group).write(this.allowed).write(this.tempId);
        }
    }

    public static class PermissionGroupState
    implements CustomPacket.Serializable,
    Comparable<Object> {
        public static int clientTempId = -325;
        public String name;
        public String id;
        public int tempId;
        public boolean canView;

        public PermissionGroupState(String name, boolean player) {
            this.name = name;
            this.id = (player ? "P_" : "G_") + name;
            this.tempId = clientTempId--;
        }

        public PermissionGroupState(String name, String id, int tempId, boolean canView) {
            this.name = name;
            this.id = id;
            this.tempId = tempId;
            this.canView = canView;
        }

        public PermissionGroupState(PermissionGroup group, boolean canView) {
            this.name = group.name;
            this.id = group.getId();
            this.tempId = group.tempId;
            this.canView = canView;
            if (group instanceof PermissionGroup.SpecialPermissionGroup || group instanceof PermissionPlayer) {
                this.canView = false;
            }
        }

        public PermissionGroupState(CustomPacket.CustomPacketReader reader) {
            this(reader.readString(), reader.readString(), reader.readInt(), reader.readBoolean());
        }

        @Override
        public void write(CustomPacket packet) {
            packet.write(this.name);
            packet.write(this.id);
            packet.write(this.tempId);
            packet.write(this.canView);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionGroupState)) {
                return false;
            }
            PermissionGroupState s = (PermissionGroupState)o;
            return this.name.equals(s.name) && this.id.equals(s.id);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof PermissionGroupState) {
                return this.name.compareToIgnoreCase(((PermissionGroupState)o).name);
            }
            return -1;
        }
    }
}

