/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions;

import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PermissionGroup;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PermissionData
extends WorldSavedData {
    private static final String identifier = "BCMod-Permissions";
    public HashMap<String, NBTTagCompound> permissions = new HashMap();
    public HashMap<String, NBTTagCompound> items = new HashMap();
    public static HashMap<String, PermissionGroup> groups = new HashMap();

    public PermissionData(String par1Str) {
        super(par1Str);
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagCompound element;
        Object[] keys;
        this.permissions.clear();
        this.items.clear();
        NBTTagCompound elements = tag.func_74775_l("permissions");
        for (Object key : keys = elements.func_150296_c().toArray()) {
            element = elements.func_74775_l((String)key);
            if (!element.func_74764_b("id")) continue;
            this.permissions.put(element.func_74779_i("id"), element);
        }
        elements = tag.func_74775_l("items");
        for (Object key : keys = elements.func_150296_c().toArray()) {
            element = elements.func_74775_l((String)key);
            if (!element.func_74764_b("id")) continue;
            this.items.put(element.func_74779_i("id"), element);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        if (!tag.func_74764_b("permissions")) {
            tag.func_74782_a("permissions", (NBTBase)new NBTTagCompound());
        }
        if (!tag.func_74764_b("items")) {
            tag.func_74782_a("items", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound pTag = tag.func_74775_l("permissions");
        for (Map.Entry<String, NBTTagCompound> entry : this.permissions.entrySet()) {
            pTag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
        NBTTagCompound iTag = tag.func_74775_l("items");
        for (Map.Entry<String, NBTTagCompound> entry : this.items.entrySet()) {
            iTag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
    }

    public void setPermission(PermissionGroup group) {
        (group instanceof ItemPermission ? this.items : this.permissions).put(group.getId(), group.getTagCompound());
        this.func_76185_a();
    }

    public void deletePermission(PermissionGroup group) {
        String id = group.getId();
        if (id.startsWith("G_")) {
            groups.remove(id);
            this.permissions.remove(id);
            this.func_76185_a();
        } else if (id.startsWith("I_")) {
            groups.remove(id);
            this.items.remove(id);
            this.func_76185_a();
        }
    }

    public boolean hasPermission(PermissionGroup group) {
        return (group instanceof ItemPermission ? this.items : this.permissions).containsKey(group.getId());
    }

    public NBTTagCompound getPermission(PermissionGroup group) {
        String id;
        if (!(group instanceof ItemPermission ? this.items : this.permissions).containsKey(id = group.getId())) {
            this.setPermission(group);
        }
        return (group instanceof ItemPermission ? this.items : this.permissions).get(id);
    }

    public static PermissionData get(World world) {
        PermissionData data = (PermissionData)world.func_72943_a(PermissionData.class, identifier);
        if (data == null) {
            data = new PermissionData(identifier);
            world.func_72823_a(identifier, (WorldSavedData)data);
        }
        return data;
    }

    public void loadAllPermissions(World world) {
        PermissionGroup.getGroup(world, PermissionGroup.SpecialPermissionGroup.allowId);
        PermissionGroup.getGroup(world, PermissionGroup.SpecialPermissionGroup.denyId);
        for (String id : this.permissions.keySet()) {
            PermissionGroup.getGroup(world, id);
        }
        for (String id : this.items.keySet()) {
            PermissionGroup.getGroup(world, id);
        }
    }
}

