/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.CustomPacket;
import brad16840.common.MessageChannel;
import brad16840.common.Translatable;
import brad16840.common.UniqueItemData;
import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import brad16840.common.permissions.PermissionRule;
import brad16840.common.permissions.gui.ClientState;
import brad16840.common.permissions.gui.GroupView;
import brad16840.common.permissions.gui.PlayerView;
import brad16840.common.permissions.gui.RuleView;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;

public class PacketHandler {
    private static GroupView getGroupView(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerStack && ((ContainerStack)player.field_71070_bA).getContainer(0) instanceof GroupView) {
            return (GroupView)((ContainerStack)player.field_71070_bA).getContainer(0);
        }
        new Translatable("problem.groupview404", new Object[0]).logOrSend(player);
        ContainerStack.closeScreen(player);
        return null;
    }

    private static PlayerView getPlayerView(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerStack && ((ContainerStack)player.field_71070_bA).getContainer(0) instanceof PlayerView) {
            return (PlayerView)((ContainerStack)player.field_71070_bA).getContainer(0);
        }
        new Translatable("problem.playerview404", new Object[0]).logOrSend(player);
        ContainerStack.closeScreen(player);
        return null;
    }

    private static RuleView getRuleView(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerStack && ((ContainerStack)player.field_71070_bA).getContainer(0) instanceof RuleView) {
            return (RuleView)((ContainerStack)player.field_71070_bA).getContainer(0);
        }
        new Translatable("problem.ruleview404", new Object[0]).logOrSend(player);
        ContainerStack.closeScreen(player);
        return null;
    }

    public static void registerMessages(MessageChannel channel) {
        channel.registerMessage(AddRule.class);
        channel.registerMessage(EditRule.class);
        channel.registerMessage(LowerRule.class);
        channel.registerMessage(DeleteRule.class);
        channel.registerMessage(OpenGroup.class);
        channel.registerMessage(OpenRule.class);
        channel.registerMessage(OpenPlayer.class);
        channel.registerMessage(ModeratePlayer.class);
        channel.registerMessage(CreateGroup.class);
        channel.registerMessage(ChangeVisibility.class);
        channel.registerMessage(UpdateClientGroup.class);
        channel.registerMessage(UpdateClientRule.class);
        channel.registerMessage(UpdateClientPlayer.class);
        channel.registerMessage(ViewItem.class);
        channel.registerMessage(DeleteGroup.class);
    }

    public static class DeleteGroup
    extends MessageChannel.Message {
        public DeleteGroup() {
        }

        public DeleteGroup(String id) {
            super(id);
            this.setClasses(String.class);
        }

        private DeleteGroup(boolean succeeded, Translatable message) {
            super(succeeded, message);
            this.setClasses(Boolean.class, Translatable.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String stateId = reader.readString();
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, stateId);
                if (group == null) {
                    return;
                }
                PermissionPlayer pa = PermissionGroup.getPlayerPermission(player);
                if (!group.isOwner(pa)) {
                    Common.channel.sendToPlayer(player, new DeleteGroup(false, UniqueItemData.permissionError("disband", PermissionGroup._name)));
                    return;
                }
                group.deleteGroup(player.field_70170_p);
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen != null) {
                    String unlocalized = "disband.group";
                    String[] args = new String[]{group.name};
                    if (stateId.startsWith("I_")) {
                        if (stateId.startsWith("I_@")) {
                            unlocalized = "disband.block";
                            int o = group.name.indexOf(";");
                            args = new String[]{group.name.substring(6, o), group.name.substring(o + 7)};
                        } else {
                            unlocalized = "disband.item";
                            args[0] = group.name.substring(0, 13);
                        }
                    }
                    Common.channel.sendToPlayer(player, new DeleteGroup(true, new Translatable(unlocalized, args)));
                    screen.container.closeContainer(player);
                }
            } else {
                if (reader.readBoolean()) {
                    GroupView screen = PacketHandler.getGroupView(player);
                    if (screen != null) {
                        screen.container.closeContainer(player);
                    }
                } else {
                    GroupView screen = PacketHandler.getGroupView(player);
                    if (screen != null) {
                        screen.waitingForResponse = false;
                    }
                }
                reader.readSerializable(Translatable.class).log(player);
            }
        }
    }

    public static class ViewItem
    extends MessageChannel.Message {
        public ViewItem() {
        }

        public ViewItem(int stackPos, String type, String uuid) {
            super(stackPos, type, uuid);
            this.setClasses(Integer.class, String.class, String.class);
        }

        private ViewItem(boolean succeeded) {
            super(succeeded);
            this.setClasses(Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                int stackPos = reader.readInt();
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    reader.readString();
                    reader.readString();
                    return;
                }
                ContainerStack stack = (ContainerStack)player.field_71070_bA;
                if (stack.stacks[0].size() <= stackPos || !(stack.getContainer(stackPos) instanceof PlayerView)) {
                    reader.readString();
                    reader.readString();
                    new Translatable("problem.guiinvalidstate", new Object[0]).send(player);
                    ContainerStack.closeScreen(player);
                    return;
                }
                if (!((PlayerView)stack.getContainer(stackPos)).viewItem(player, reader.readString(), reader.readString())) {
                    new Translatable("problem.viewitemunviewable", new Object[0]).send(player);
                    Common.channel.sendToPlayer(player, new ViewItem(false));
                }
            } else if (!reader.readBoolean() && player.field_71070_bA instanceof ContainerStack) {
                ((ContainerStack)player.field_71070_bA).closeContainer(player);
            }
        }
    }

    public static class UpdateClientPlayer
    extends MessageChannel.Message {
        public UpdateClientPlayer() {
        }

        public UpdateClientPlayer(int stackPos, ClientState.PermissionPlayerData state) {
            super(stackPos, state);
            this.setClasses(Integer.class, ClientState.PermissionPlayerData.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int stackPos = reader.readInt();
                ClientState.PermissionPlayerData data = reader.readSerializable(ClientState.PermissionPlayerData.class);
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    return;
                }
                ContainerStack stack = (ContainerStack)player.field_71070_bA;
                if (stack.stacks[0].size() <= stackPos) {
                    return;
                }
                if (!(stack.stacks[0].get(stackPos) instanceof PlayerView)) {
                    new Translatable("problem.guiinvalidstate", new Object[0]).log(player);
                    ContainerStack.closeScreen(player);
                    return;
                }
                PlayerView screen = (PlayerView)stack.stacks[0].get(stackPos);
                if (data == null) {
                    ((ContainerStack)player.field_71070_bA).closeContainer(player);
                } else {
                    screen.data = data;
                    screen.updateScreen();
                    stack.updateContainers(player);
                }
            }
        }
    }

    public static class UpdateClientRule
    extends MessageChannel.Message {
        public UpdateClientRule() {
        }

        public UpdateClientRule(int stackPos, ClientState.PermissionGroups groups) {
            super(stackPos, groups);
            this.setClasses(Integer.class, ClientState.PermissionGroups.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int stackPos = reader.readInt();
                ClientState.PermissionGroups groups = reader.readSerializable(ClientState.PermissionGroups.class);
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    return;
                }
                ContainerStack stack = (ContainerStack)player.field_71070_bA;
                if (stack.stacks[0].size() <= stackPos) {
                    return;
                }
                if (!(stack.stacks[0].get(stackPos) instanceof RuleView)) {
                    new Translatable("problem.guiinvalidstate", new Object[0]).log(player);
                    ContainerStack.closeScreen(player);
                    return;
                }
                RuleView screen = (RuleView)stack.stacks[0].get(stackPos);
                if (groups == null) {
                    ((ContainerStack)player.field_71070_bA).closeContainer(player);
                } else {
                    boolean sel = false;
                    String selectedId = null;
                    if (screen.playerListSelected) {
                        if (screen.selectedRow < screen.groups.players.size()) {
                            selectedId = screen.groups.players.get((int)screen.selectedRow).id;
                        }
                    } else if (screen.selectedRow < screen.groups.groups.size()) {
                        selectedId = screen.groups.groups.get((int)screen.selectedRow).id;
                    }
                    screen.groups.players = groups.players;
                    screen.groups.groups = groups.groups;
                    screen.selectedRow = 0;
                    if (screen.playerListSelected) {
                        for (int i = 0; i < groups.players.size(); ++i) {
                            if (!groups.players.get((int)i).id.equals(selectedId)) continue;
                            screen.selectedRow = i;
                            break;
                        }
                    } else {
                        for (int i = 0; i < groups.groups.size(); ++i) {
                            if (!groups.groups.get((int)i).id.equals(selectedId)) continue;
                            screen.selectedRow = i;
                            break;
                        }
                    }
                    screen.updateScreen();
                }
            }
        }
    }

    public static class UpdateClientGroup
    extends MessageChannel.Message {
        public UpdateClientGroup() {
        }

        public UpdateClientGroup(int stackPos, ClientState.PermissionState state) {
            super(stackPos, state);
            this.setClasses(Integer.class, ClientState.PermissionState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                int stackPos = reader.readInt();
                ClientState.PermissionState state = reader.readSerializable(ClientState.PermissionState.class);
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    return;
                }
                ContainerStack stack = (ContainerStack)player.field_71070_bA;
                if (stack.stacks[0].size() <= stackPos) {
                    return;
                }
                if (!(stack.stacks[0].get(stackPos) instanceof GroupView)) {
                    new Translatable("problem.guiinvalidstate", new Object[0]).log(player);
                    ContainerStack.closeScreen(player);
                    return;
                }
                GroupView screen = (GroupView)stack.stacks[0].get(stackPos);
                if (state == null) {
                    ((ContainerStack)player.field_71070_bA).closeContainer(player);
                } else {
                    screen.state = state;
                    screen.updateScreen();
                }
            }
        }
    }

    public static class ChangeVisibility
    extends MessageChannel.Message {
        public ChangeVisibility() {
        }

        public ChangeVisibility(String id, int tempId) {
            super(id, tempId);
            this.setClasses(String.class, Integer.class);
        }

        private ChangeVisibility(int visibility) {
            super(visibility);
            this.setClasses(Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, reader.readString());
                if (group == null) {
                    reader.readInt();
                    return;
                }
                if (!group.isOwner(p)) {
                    reader.readInt();
                    UniqueItemData.permissionError("changevisibility", PermissionGroup._name).send(player);
                    return;
                }
                group.visibility = reader.readInt();
                if (group.visibility > 2 || group.visibility < 0) {
                    group.visibility = 0;
                }
                group.markDirty(player.field_70170_p);
                Common.channel.sendToPlayer(player, new ChangeVisibility(group.visibility));
            } else {
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    reader.readInt();
                    return;
                }
                screen.state.visibility = reader.readInt();
                screen.updateScreen();
            }
        }
    }

    public static class CreateGroup
    extends MessageChannel.Message {
        public CreateGroup() {
        }

        public CreateGroup(ClientState.PermissionGroupState group, boolean player) {
            super(group, player);
            this.setClasses(ClientState.PermissionGroupState.class, Boolean.class);
        }

        private CreateGroup(ClientState.PermissionGroupState group, boolean isPlayer, int tempId) {
            super(group, isPlayer, tempId);
            this.setClasses(ClientState.PermissionGroupState.class, Boolean.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                ClientState.PermissionGroupState group = reader.readSerializable(ClientState.PermissionGroupState.class);
                boolean isPlayer = reader.readBoolean();
                PermissionGroup g = null;
                g = isPlayer ? PermissionGroup.getGroup(player.field_70170_p, "P_" + group.name) : PermissionGroup.createGroup(player.field_70170_p, group.name, player.func_70005_c_());
                if (g != null && !isPlayer && !g.canView(PermissionGroup.getPlayerPermission(player), false)) {
                    g = null;
                }
                Common.channel.sendToPlayer(player, new CreateGroup(g == null ? new ClientState.PermissionGroupState(group.name, group.id, 0, group.canView) : new ClientState.PermissionGroupState(g, true), isPlayer, group.tempId));
            } else {
                ClientState.PermissionGroupState group = reader.readSerializable(ClientState.PermissionGroupState.class);
                boolean isPlayer = reader.readBoolean();
                int tempId = reader.readInt();
                RuleView screen = PacketHandler.getRuleView(player);
                if (screen == null) {
                    return;
                }
                ArrayList<ClientState.PermissionGroupState> groups = isPlayer ? screen.groups.players : screen.groups.groups;
                Collections.sort(groups);
                for (int i = 0; i < groups.size(); ++i) {
                    ClientState.PermissionGroupState g = groups.get(i);
                    if (g.tempId != tempId) continue;
                    g.tempId = group.tempId;
                    g.id = group.id;
                    g.name = group.name;
                    g.canView = group.canView;
                    if (group.tempId == 0) {
                        groups.remove(i);
                        break;
                    }
                    screen.setSelection(screen.playerListDisplayed, i);
                    screen.list.scrollToVisible(i);
                    break;
                }
                screen.updateScreen();
            }
        }
    }

    public static class ModeratePlayer
    extends MessageChannel.Message {
        public ModeratePlayer() {
        }

        public ModeratePlayer(boolean moderate) {
            super(moderate);
            this.setClasses(Boolean.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                PlayerView screen;
                PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
                boolean moderate = reader.readBoolean();
                PermissionGroup.ModeratorPermissionGroup g = (PermissionGroup.ModeratorPermissionGroup)PermissionGroup.getGroup(player.field_70170_p, PermissionGroup.ModeratorPermissionGroup.id);
                if (PermissionGroup.isOp(p)) {
                    g.setModerationStatus(player.field_70170_p, p, moderate);
                }
                if ((screen = PacketHandler.getPlayerView(player)) != null) {
                    screen.needsUpdating = true;
                    if (!screen.refreshData(player)) {
                        ((ContainerStack)player.field_71070_bA).closeContainer(player);
                    }
                }
            }
        }
    }

    public static class OpenPlayer
    extends MessageChannel.Message {
        public OpenPlayer() {
        }

        private OpenPlayer(ClientState.PermissionPlayerData playerData) {
            super(playerData);
            this.setClasses(ClientState.PermissionPlayerData.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
                int allowState = -1;
                if (PermissionGroup.isOp(p)) {
                    allowState = p.isModerator(p) ? 1 : 0;
                }
                ClientState.PermissionPlayerData playerData = new ClientState.PermissionPlayerData(allowState, new ClientState.PermissionGroupState(player.func_70005_c_(), true));
                PermissionData data = PermissionData.get(player.field_70170_p);
                data.loadAllPermissions(player.field_70170_p);
                for (PermissionGroup group : PermissionData.groups.values()) {
                    if (group instanceof PermissionPlayer || group == null) continue;
                    if (group.isOwner(p)) {
                        playerData.owner.add(new ClientState.PermissionGroupState(group, true));
                        continue;
                    }
                    if (group.canEdit(p)) {
                        playerData.admin.add(new ClientState.PermissionGroupState(group, group.canView(p, false)));
                        continue;
                    }
                    if (!group.canUse(p)) continue;
                    playerData.member.add(new ClientState.PermissionGroupState(group, group.canView(p, false)));
                }
                Collections.sort(playerData.owner);
                Collections.sort(playerData.admin);
                Collections.sort(playerData.member);
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).addContainer(player, null, new PlayerView(playerData));
                    Common.channel.sendToPlayer(player, new OpenPlayer(playerData));
                }
            } else {
                ClientState.PermissionPlayerData playerData = reader.readSerializable(ClientState.PermissionPlayerData.class);
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).addContainer(player, null, new PlayerView(playerData));
                } else {
                    new Translatable("problem.guioutofsync", new Object[0]).log(player);
                    ContainerStack.closeScreen(player);
                }
            }
        }
    }

    public static class OpenRule
    extends MessageChannel.Message {
        public OpenRule() {
        }

        public OpenRule(int stateId, ClientState.PermissionGroupState group, int allowed, int ruleId) {
            super(stateId, group, allowed, ruleId);
            this.setClasses(Integer.class, ClientState.PermissionGroupState.class, Integer.class, Integer.class);
        }

        private OpenRule(int stateId, ClientState.PermissionGroups groups, int ruleId) {
            super(stateId, groups, ruleId);
            this.setClasses(Integer.class, ClientState.PermissionGroups.class, Integer.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                int stateId = reader.readInt();
                PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
                ClientState.PermissionGroupState g = reader.readSerializable(ClientState.PermissionGroupState.class);
                ClientState.PermissionGroups groups = new ClientState.PermissionGroups();
                groups.allowState = reader.readInt();
                groups.defaultGroup = g;
                groups.player = new ClientState.PermissionGroupState(player.func_70005_c_(), true);
                groups.players = new ArrayList();
                groups.groups = new ArrayList();
                PermissionData data = PermissionData.get(player.field_70170_p);
                data.loadAllPermissions(player.field_70170_p);
                boolean foundDefault = g == null;
                for (PermissionGroup group : PermissionData.groups.values()) {
                    if (group instanceof ItemPermission) continue;
                    boolean e = foundDefault;
                    if (!foundDefault && group != null && group.getId().equals(g.id)) {
                        foundDefault = true;
                    }
                    if (group instanceof PermissionPlayer) {
                        groups.players.add(new ClientState.PermissionGroupState(group, false));
                        continue;
                    }
                    if (group instanceof PermissionGroup.SpecialPermissionGroup) {
                        groups.groups.add(new ClientState.PermissionGroupState(group, false));
                        continue;
                    }
                    if (group.canView(p, false)) {
                        groups.groups.add(new ClientState.PermissionGroupState(group, true));
                        continue;
                    }
                    foundDefault = e;
                }
                if (!foundDefault) {
                    if (g.id.startsWith("P_")) {
                        groups.players.add(g);
                    } else {
                        groups.groups.add(g);
                    }
                }
                Collections.sort(groups.groups);
                Collections.sort(groups.players);
                int ruleId = reader.readInt();
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    return;
                }
                ((ContainerStack)player.field_71070_bA).addContainer(player, null, new RuleView(screen, groups, ruleId));
                Common.channel.sendToPlayer(player, new OpenRule(stateId, groups, ruleId));
            } else {
                int stateId = reader.readInt();
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    reader.readSerializable(ClientState.PermissionGroups.class);
                    reader.readInt();
                    return;
                }
                ((ContainerStack)player.field_71070_bA).addContainer(player, null, new RuleView(screen, reader.readSerializable(ClientState.PermissionGroups.class), reader.readInt()));
            }
        }
    }

    public static class OpenGroup
    extends MessageChannel.Message {
        public OpenGroup() {
        }

        public OpenGroup(int stateId, ClientState.PermissionGroupState group, boolean isVisible) {
            super(stateId, group, isVisible);
            this.setClasses(Integer.class, ClientState.PermissionGroupState.class, Boolean.class);
        }

        private OpenGroup(int stateId, ClientState.PermissionState state) {
            super(stateId, state);
            this.setClasses(Integer.class, ClientState.PermissionState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                if (!(player.field_71070_bA instanceof ContainerStack)) {
                    return;
                }
                int stateId = reader.readInt();
                PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
                ClientState.PermissionGroupState g = reader.readSerializable(ClientState.PermissionGroupState.class);
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, g.id);
                boolean dunnoAnymore = reader.readBoolean();
                if (group == null || !group.canView(p, dunnoAnymore)) {
                    UniqueItemData.permissionError("view", PermissionGroup._name).send(player);
                    return;
                }
                ClientState.PermissionState state = new ClientState.PermissionState(group.name, group.getId(), group.tempId, group.canEdit(p), group.visibility, new ClientState.PermissionGroupState(group.owner, group.owner.canView(p, true)), new ClientState.PermissionGroupState(group.parent, group.parent.canView(p, true)), group.getEditPrivilige(p));
                for (PermissionRule rule : group.rules) {
                    if (rule != null && rule.group != null && rule.group.deleted) continue;
                    state.rules.add(rule == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(rule.group, rule.group.canView(p, true)), rule.isAllowed, rule.tempId));
                }
                ((ContainerStack)player.field_71070_bA).addContainer(player, null, new GroupView(state));
                Common.channel.sendToPlayer(player, new OpenGroup(stateId, state));
            } else {
                int stateId = reader.readInt();
                if (player.field_71070_bA instanceof ContainerStack) {
                    ((ContainerStack)player.field_71070_bA).addContainer(player, null, new GroupView(reader.readSerializable(ClientState.PermissionState.class)));
                } else {
                    reader.readSerializable(ClientState.PermissionState.class);
                    ContainerStack.closeScreen(player);
                }
            }
        }
    }

    public static class DeleteRule
    extends MessageChannel.Message {
        public DeleteRule() {
        }

        public DeleteRule(String groupId, ClientState.PermissionRuleState rule) {
            super(groupId, rule);
            this.setClasses(String.class, ClientState.PermissionRuleState.class);
        }

        private DeleteRule(boolean succeeded, ArrayList<ClientState.PermissionRuleState> rules) {
            super(succeeded, rules);
            this.setClasses(Boolean.class, ClientState.PermissionRuleState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String stateId = reader.readString();
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, stateId);
                ClientState.PermissionRuleState rule = reader.readSerializable(ClientState.PermissionRuleState.class);
                PermissionPlayer pa = PermissionGroup.getPlayerPermission(player);
                ArrayList<ClientState.PermissionRuleState> rules = new ArrayList<ClientState.PermissionRuleState>();
                for (int i = 0; i < group.rules.size(); ++i) {
                    if (group.rules.get(i) == null || group.rules.get((int)i).tempId != rule.tempId) continue;
                    int adminLevel = group.getEditPrivilige(pa);
                    if (adminLevel < 0 || adminLevel > i) break;
                    group.rules.remove(i);
                    Common.channel.sendToPlayer(player, new DeleteRule(true, rules));
                    group.markDirty(player.field_70170_p);
                    if (player.field_71070_bA instanceof ContainerStack && ((ContainerStack)player.field_71070_bA).getContainer(0) instanceof GroupView && !((GroupView)((ContainerStack)player.field_71070_bA).getContainer(0)).refreshData(player)) {
                        ((ContainerStack)player.field_71070_bA).closeContainer(player);
                    }
                    return;
                }
                for (PermissionRule r : group.rules) {
                    rules.add(r == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(r.group, r.group.canView(pa, true)), r.isAllowed, r.tempId));
                }
                Common.channel.sendToPlayer(player, new DeleteRule(false, rules));
            } else if (!reader.readBoolean()) {
                UniqueItemData.permissionError("delete", PermissionRule.name).log(player);
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    int ruleCount = reader.readInt();
                    for (int i = 0; i < ruleCount; ++i) {
                        reader.readSerializable(ClientState.PermissionRuleState.class);
                    }
                    return;
                }
                int ruleCount = reader.readInt();
                screen.state.rules.clear();
                for (int i = 0; i < ruleCount; ++i) {
                    screen.state.rules.add(reader.readSerializable(ClientState.PermissionRuleState.class));
                }
                screen.updateScreen();
                screen.waitingForResponse = false;
            } else {
                int ruleCount = reader.readInt();
                for (int i = 0; i < ruleCount; ++i) {
                    reader.readSerializable(ClientState.PermissionRuleState.class);
                }
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    return;
                }
                screen.waitingForResponse = false;
            }
        }
    }

    public static class LowerRule
    extends MessageChannel.Message {
        public LowerRule() {
        }

        public LowerRule(String groupId, ClientState.PermissionRuleState rule, boolean lowered) {
            super(groupId, rule, lowered);
            this.setClasses(String.class, ClientState.PermissionRuleState.class, Boolean.class);
        }

        private LowerRule(boolean succeeded, boolean lowered, ArrayList<ClientState.PermissionRuleState> rules) {
            super(succeeded, lowered, rules);
            this.setClasses(Boolean.class, Boolean.class, ClientState.PermissionRuleState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String stateId = reader.readString();
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, stateId);
                ClientState.PermissionRuleState rule = reader.readSerializable(ClientState.PermissionRuleState.class);
                PermissionPlayer pa = PermissionGroup.getPlayerPermission(player);
                ArrayList<ClientState.PermissionRuleState> rules = new ArrayList<ClientState.PermissionRuleState>();
                for (int i = 0; i < group.rules.size() - 1; ++i) {
                    if ((group.rules.get(i) != null || rule != null) && (rule == null || group.rules.get(i) == null || group.rules.get((int)i).tempId != rule.tempId)) continue;
                    int adminLevel = group.getEditPrivilige(pa);
                    if (adminLevel < 0 || adminLevel > i) break;
                    PermissionRule r = group.rules.get(i);
                    group.rules.remove(i);
                    group.rules.add(i + 1, r);
                    Common.channel.sendToPlayer(player, new LowerRule(true, reader.readBoolean(), rules));
                    group.markDirty(player.field_70170_p);
                    return;
                }
                for (PermissionRule r : group.rules) {
                    rules.add(r == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(r.group, r.group.canView(pa, true)), r.isAllowed, r.tempId));
                }
                Common.channel.sendToPlayer(player, new LowerRule(false, reader.readBoolean(), rules));
            } else if (!reader.readBoolean()) {
                UniqueItemData.permissionError("move", PermissionRule.name).log(player);
                boolean lowered = reader.readBoolean();
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    int t = reader.readInt();
                    for (int i = 0; i < t; ++i) {
                        reader.readSerializable(ClientState.PermissionRuleState.class);
                    }
                    return;
                }
                if (screen.list.rowClicked == screen.selectedRule) {
                    screen.selectedRule = screen.selectedRule - (lowered ? 1 : -1);
                } else if (screen.list.rowClicked - (lowered ? 1 : -1) == screen.selectedRule) {
                    screen.selectedRule = screen.selectedRule + (lowered ? 1 : -1);
                }
                screen.list.rowClicked = screen.list.rowClicked - (lowered ? 1 : -1);
                int ruleCount = reader.readInt();
                screen.state.rules.clear();
                for (int i = 0; i < ruleCount; ++i) {
                    screen.state.rules.add(reader.readSerializable(ClientState.PermissionRuleState.class));
                }
                screen.updateScreen();
                screen.waitingForResponse = false;
            } else {
                reader.readBoolean();
                int t = reader.readInt();
                for (int i = 0; i < t; ++i) {
                    reader.readSerializable(ClientState.PermissionRuleState.class);
                }
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    return;
                }
                screen.waitingForResponse = false;
                screen.updateScreen();
            }
        }
    }

    public static class EditRule
    extends MessageChannel.Message {
        public EditRule() {
        }

        public EditRule(String groupId, ClientState.PermissionRuleState rule) {
            super(groupId, rule);
            this.setClasses(String.class, ClientState.PermissionRuleState.class);
        }

        private EditRule(boolean succeeded, ClientState.PermissionGroupState owner, ClientState.PermissionGroupState parent, ArrayList<ClientState.PermissionRuleState> rules) {
            super(succeeded, owner, parent, rules);
            this.setClasses(Boolean.class, ClientState.PermissionGroupState.class, ClientState.PermissionGroupState.class, ClientState.PermissionRuleState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String stateId = reader.readString();
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, stateId);
                ClientState.PermissionRuleState rule = reader.readSerializable(ClientState.PermissionRuleState.class);
                if (group == null) {
                    return;
                }
                PermissionPlayer pa = PermissionGroup.getPlayerPermission(player);
                ArrayList<ClientState.PermissionRuleState> rules = new ArrayList<ClientState.PermissionRuleState>();
                if (rule.tempId == -1 || rule.tempId == -2) {
                    int adminLevel = group.getEditPrivilige(pa);
                    PermissionGroup g = PermissionGroup.getGroup(player.field_70170_p, rule.group.id);
                    if (adminLevel == 0 && g != null) {
                        if (rule.tempId == -2) {
                            group.owner = g;
                        } else {
                            group.parent = g;
                        }
                        g.subscribedGroups.add(group);
                        Common.channel.sendToPlayer(player, new EditRule(true, null, null, rules));
                        group.markDirty(player.field_70170_p);
                        return;
                    }
                } else {
                    for (int i = 0; i < group.rules.size(); ++i) {
                        PermissionGroup g;
                        if (group.rules.get(i) == null || group.rules.get((int)i).tempId != rule.tempId) continue;
                        int adminLevel = group.getEditPrivilige(pa);
                        if (adminLevel < 0 || adminLevel > i || (g = PermissionGroup.getGroup(player.field_70170_p, rule.group.id)) == null) break;
                        PermissionRule r = group.rules.get(i);
                        r.group = g;
                        r.isAllowed = rule.allowed;
                        g.subscribedGroups.add(group);
                        Common.channel.sendToPlayer(player, new EditRule(true, null, null, rules));
                        group.markDirty(player.field_70170_p);
                        return;
                    }
                }
                for (PermissionRule r : group.rules) {
                    rules.add(r == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(r.group, r.group.canView(pa, true)), r.isAllowed, r.tempId));
                }
                Common.channel.sendToPlayer(player, new EditRule(false, new ClientState.PermissionGroupState(group.owner, group.owner.canView(pa, true)), new ClientState.PermissionGroupState(group.parent, group.parent.canView(pa, true)), rules));
            } else if (!reader.readBoolean()) {
                UniqueItemData.permissionError("edit", PermissionRule.name).log(player);
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    reader.readSerializable(ClientState.PermissionGroupState.class);
                    reader.readSerializable(ClientState.PermissionGroupState.class);
                    int ruleCount = reader.readInt();
                    for (int i = 0; i < ruleCount; ++i) {
                        reader.readSerializable(ClientState.PermissionRuleState.class);
                    }
                    return;
                }
                screen.state.owner = reader.readSerializable(ClientState.PermissionGroupState.class);
                screen.state.parent = reader.readSerializable(ClientState.PermissionGroupState.class);
                screen.state.rules.clear();
                int ruleCount = reader.readInt();
                for (int i = 0; i < ruleCount; ++i) {
                    screen.state.rules.add(reader.readSerializable(ClientState.PermissionRuleState.class));
                }
                screen.updateScreen();
                screen.waitingForResponse = false;
            } else {
                reader.readSerializable(ClientState.PermissionGroupState.class);
                reader.readSerializable(ClientState.PermissionGroupState.class);
                int ruleCount = reader.readInt();
                for (int i = 0; i < ruleCount; ++i) {
                    reader.readSerializable(ClientState.PermissionRuleState.class);
                }
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    return;
                }
                screen.waitingForResponse = false;
            }
        }
    }

    public static class AddRule
    extends MessageChannel.Message {
        public AddRule() {
        }

        public AddRule(String groupId, int pos, ClientState.PermissionGroupState group, boolean allowed, int tempId) {
            super(groupId, pos, group, allowed, tempId);
            this.setClasses(String.class, Integer.class, ClientState.PermissionGroupState.class, Boolean.class, Integer.class);
        }

        private AddRule(int oldId, int newId) {
            super(true, oldId, newId);
            this.setClasses(Boolean.class, Integer.class, Integer.class);
        }

        private AddRule(ClientState.PermissionGroupState owner, ClientState.PermissionGroupState parent, ArrayList<ClientState.PermissionRuleState> rules) {
            super(false, owner, parent, rules);
            this.setClasses(Boolean.class, ClientState.PermissionGroupState.class, ClientState.PermissionGroupState.class, ClientState.PermissionRuleState.class);
        }

        @Override
        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String stateId = reader.readString();
                int ruleId = reader.readInt();
                PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, stateId);
                if (group == null) {
                    reader.readSerializable(ClientState.PermissionGroupState.class);
                    reader.readBoolean();
                    reader.readInt();
                    return;
                }
                ClientState.PermissionGroupState rulegroup = reader.readSerializable(ClientState.PermissionGroupState.class);
                PermissionPlayer pa = PermissionGroup.getPlayerPermission(player);
                boolean allowed = reader.readBoolean();
                int tempId = reader.readInt();
                for (int i = 0; i < group.rules.size() || ruleId == 0; ++i) {
                    if (ruleId != 0) {
                        if (group.rules.get(i) == null ? ruleId != -1 : group.rules.get((int)i).tempId != ruleId) continue;
                        ++i;
                    }
                    int adminLevel = group.getEditPrivilige(pa);
                    PermissionGroup g = PermissionGroup.getGroup(player.field_70170_p, rulegroup.id);
                    if (adminLevel < 0 || adminLevel > i || g == null) break;
                    PermissionRule r = new PermissionRule(g, allowed);
                    group.rules.add(i, r);
                    r.group.subscribedGroups.add(group);
                    Common.channel.sendToPlayer(player, new AddRule(tempId, r.tempId));
                    group.markDirty(player.field_70170_p);
                    return;
                }
                ArrayList<ClientState.PermissionRuleState> rules = new ArrayList<ClientState.PermissionRuleState>();
                for (PermissionRule r : group.rules) {
                    rules.add(r == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(r.group, r.group.canView(pa, true)), r.isAllowed, r.tempId));
                }
                Common.channel.sendToPlayer(player, new AddRule(new ClientState.PermissionGroupState(group.owner, group.owner.canView(pa, true)), new ClientState.PermissionGroupState(group.parent, group.parent.canView(pa, true)), rules));
            } else if (!reader.readBoolean()) {
                UniqueItemData.permissionError("add", PermissionRule.name).log(player);
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    reader.readSerializable(ClientState.PermissionGroupState.class);
                    reader.readSerializable(ClientState.PermissionGroupState.class);
                    int ruleCount = reader.readInt();
                    for (int i = 0; i < ruleCount; ++i) {
                        reader.readSerializable(ClientState.PermissionRuleState.class);
                    }
                    return;
                }
                screen.state.owner = reader.readSerializable(ClientState.PermissionGroupState.class);
                screen.state.parent = reader.readSerializable(ClientState.PermissionGroupState.class);
                int ruleCount = reader.readInt();
                screen.state.rules.clear();
                for (int i = 0; i < ruleCount; ++i) {
                    screen.state.rules.add(reader.readSerializable(ClientState.PermissionRuleState.class));
                }
                screen.updateScreen();
                screen.waitingForResponse = false;
            } else {
                int t = reader.readInt();
                int j = reader.readInt();
                GroupView screen = PacketHandler.getGroupView(player);
                if (screen == null) {
                    return;
                }
                screen.waitingForResponse = false;
                if (t != 0) {
                    for (int i = 0; i < screen.state.rules.size(); ++i) {
                        if (screen.state.rules.get(i) == null || screen.state.rules.get((int)i).tempId != t) continue;
                        screen.state.rules.get((int)i).tempId = j;
                        break;
                    }
                }
            }
        }
    }
}

