/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import org.lwjgl.opengl.GL11;

public class CraftingContainer
extends StackableContainer {
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/crafting.png");
    public CraftingContainerCallbackContainer callbackContainer = new CraftingContainerCallbackContainer();
    public InventoryCrafting craftMatrix = null;
    public IInventory craftResult = new InventoryCraftResult();
    public World world;
    public CraftingContainerSlot craftingSlot;

    public CraftingContainer(EntityPlayer player) {
        super(130, 100);
        this.craftMatrix = new CraftingContainerInventory(this.callbackContainer, 3, 3);
        this.world = player.field_70170_p;
    }

    protected CraftingContainer(EntityPlayer player, int width, int height) {
        super(width, height);
        this.world = player.field_70170_p;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        this.craftingSlot = new CraftingContainerSlot(player, (IInventory)this.craftMatrix, this.craftResult, 0, 102, 36 + this.getOffset());
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.craftingSlot);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_IN, new StackableContainer.ContainerSlot(this, player, (IInventory)this.craftMatrix, x + y * 3, 8 + x * 18, this.getOffset() + 18 + y * 18));
            }
        }
        this.callbackContainer.func_75130_a((IInventory)this.craftMatrix);
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        final int stackIdCache = this.stackId;
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 0, this.container.layout.isTop(this.stackId) ? 0 : this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                CraftingContainer.this.gui.closeContainer(stackIdCache);
            }
        }, 68));
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public void onUnload(EntityPlayer player) {
        if (!this.world.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!this.container.mergeItemStack(this, itemstack1, 1, 10, false)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0])).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, this.getOffset(), this.guiWidth, this.guiHeight - 22, 0, 0);
    }

    @Override
    public String getId() {
        return "none";
    }

    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 22;
        }
        return 0;
    }

    @Override
    public int getSlotCount() {
        return 10;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 3;
    }

    public class CraftingContainerSlot
    extends StackableContainer.ContainerSlot {
        private final IInventory craftMatrix;
        private int amountCrafted;

        public CraftingContainerSlot(EntityPlayer player, IInventory inventory, IInventory inventory2, int par2, int par3, int par4) {
            super(CraftingContainer.this, player, inventory2, par2, par3, par4);
            this.craftMatrix = inventory;
        }

        public CraftingContainer getContainer() {
            return CraftingContainer.this;
        }

        @Override
        public boolean func_75214_a(ItemStack par1ItemStack) {
            return false;
        }

        public ItemStack func_75209_a(int par1) {
            if (this.func_75216_d()) {
                this.amountCrafted += Math.min(par1, this.func_75211_c().field_77994_a);
            }
            return super.func_75209_a(par1);
        }

        protected void func_75210_a(ItemStack par1ItemStack, int par2) {
            this.amountCrafted += par2;
            this.func_75208_c(par1ItemStack);
        }

        protected void func_75208_c(ItemStack par1ItemStack) {
            par1ItemStack.func_77980_a(this.player.field_70170_p, this.player, this.amountCrafted);
            this.amountCrafted = 0;
            if (par1ItemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai)) {
                this.player.func_71064_a((StatBase)AchievementList.field_76017_h, 1);
            } else if (par1ItemStack.func_77973_b() instanceof ItemPickaxe) {
                this.player.func_71064_a((StatBase)AchievementList.field_76018_i, 1);
            } else if (par1ItemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150460_al)) {
                this.player.func_71064_a((StatBase)AchievementList.field_76015_j, 1);
            } else if (par1ItemStack.func_77973_b() instanceof ItemHoe) {
                this.player.func_71064_a((StatBase)AchievementList.field_76013_l, 1);
            } else if (par1ItemStack.func_77973_b() == Items.field_151025_P) {
                this.player.func_71064_a((StatBase)AchievementList.field_76014_m, 1);
            } else if (par1ItemStack.func_77973_b() == Items.field_151105_aU) {
                this.player.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
            } else if (par1ItemStack.func_77973_b() instanceof ItemPickaxe && ((ItemPickaxe)par1ItemStack.func_77973_b()).func_150913_i() != Item.ToolMaterial.WOOD) {
                this.player.func_71064_a((StatBase)AchievementList.field_76012_o, 1);
            } else if (par1ItemStack.func_77973_b() instanceof ItemSword) {
                this.player.func_71064_a((StatBase)AchievementList.field_76024_r, 1);
            } else if (par1ItemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150381_bn)) {
                this.player.func_71064_a((StatBase)AchievementList.field_75998_D, 1);
            } else if (par1ItemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150342_X)) {
                this.player.func_71064_a((StatBase)AchievementList.field_76000_F, 1);
            }
        }

        public void func_82870_a(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(par1EntityPlayer, par2ItemStack, this.craftMatrix);
            this.func_75208_c(par2ItemStack);
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                ItemStack itemstack1 = this.craftMatrix.func_70301_a(i);
                if (itemstack1 == null) continue;
                this.craftMatrix.func_70298_a(i, 1);
                if (!itemstack1.func_77973_b().hasContainerItem(itemstack1)) continue;
                ItemStack itemstack2 = itemstack1.func_77973_b().getContainerItem(itemstack1);
                if (itemstack2 != null && itemstack2.func_77984_f() && itemstack2.func_77960_j() > itemstack2.func_77958_k()) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(this.player, itemstack2));
                    continue;
                }
                if (itemstack1.func_77973_b().func_77630_h(itemstack1) && this.player.field_71071_by.func_70441_a(itemstack2)) continue;
                if (this.craftMatrix.func_70301_a(i) == null) {
                    this.craftMatrix.func_70299_a(i, itemstack2);
                    continue;
                }
                this.player.func_71019_a(itemstack2, false);
            }
        }
    }

    public class CraftingContainerInventory
    extends InventoryCrafting {
        public CraftingContainerInventory(Container par1Container, int par2, int par3) {
            super(par1Container, par2, par3);
        }

        public CraftingContainer getContainer() {
            return CraftingContainer.this;
        }
    }

    public class CraftingContainerCallbackContainer
    extends Container {
        public boolean func_75145_c(EntityPlayer entityplayer) {
            return false;
        }

        public void func_75130_a(IInventory par1IInventory) {
            CraftingContainer.this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(CraftingContainer.this.craftMatrix, CraftingContainer.this.world));
        }
    }
}

