/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.gui.CraftingContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ArmorContainer
extends CraftingContainer {
    private InventoryPlayer inventory;
    protected static final ResourceLocation inventoryTexture = new ResourceLocation("textures/gui/container/inventory.png");
    protected static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/armor.png");

    public ArmorContainer(InventoryPlayer inventory) {
        super(inventory.field_70458_d, 176, 100);
        this.craftMatrix = new CraftingContainer.CraftingContainerInventory(this, this.callbackContainer, 2, 2);
        this.inventory = inventory;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        int y;
        this.craftingSlot = new CraftingContainer.CraftingContainerSlot(this, player, (IInventory)this.craftMatrix, this.craftResult, 0, 144, 46 + this.getOffset());
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.craftingSlot);
        for (y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_IN, new StackableContainer.ContainerSlot(this, player, (IInventory)this.craftMatrix, x + y * 2, 88 + x * 18, this.getOffset() + 36 + y * 18));
            }
        }
        for (y = 0; y < 4; ++y) {
            this.addSlotToContainer(ContainerStack.ContainerSection.ARMOR, new ArmorContainerSlot(player, (IInventory)this.inventory, this.inventory.func_70302_i_() - 1 - y, 8, 18 + y * 18 + this.getOffset(), y));
        }
        this.callbackContainer.func_75130_a((IInventory)this.craftMatrix);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
    }

    @Override
    public void onUnload(EntityPlayer player) {
        if (!this.world.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
            this.craftResult.func_70299_a(0, null);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (itemstack.func_77973_b() instanceof ItemArmor && this.container.func_75139_a(((ItemArmor)itemstack.func_77973_b()).field_77881_a + 5).func_75211_c() == null) {
                int j = 5 + ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
                if (!this.container.mergeItemStack(this, itemstack1, j, j + 1, false)) {
                    return null;
                }
            } else {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, this.inventory.field_70458_d.func_70005_c_()).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
        this.gui.text(this, I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0])).drawString(86, 26 + this.getOffset(), 0x404040);
        this.displayDebuffEffects();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, this.getOffset(), this.guiWidth, this.guiHeight - 3, 0, 0);
        ArmorContainer.drawPlayerOnGui(this.inventory.field_70458_d, this.gui.getOffsetX(this) + 51, this.gui.getOffsetY(this) + 85, 30, 51 - x, 35 - y);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawPlayerOnGui(EntityPlayer player, int par1, int par2, int par3, float par4, float par5) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)par1, (float)par2, (float)50.0f);
        GL11.glScalef((float)(-par3), (float)par3, (float)par3);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = player.field_70761_aq;
        float f3 = player.field_70177_z;
        float f4 = player.field_70125_A;
        float f5 = player.field_70758_at;
        float f6 = player.field_70759_as;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        player.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
        player.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
        player.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
        player.field_70759_as = player.field_70177_z;
        player.field_70758_at = player.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)player.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)player, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        player.field_70761_aq = f2;
        player.field_70177_z = f3;
        player.field_70125_A = f4;
        player.field_70758_at = f5;
        player.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    @SideOnly(value=Side.CLIENT)
    private void displayDebuffEffects() {
        int i = -124;
        int j = 3;
        int itexture = i + this.container.getOffsetX(this) - (this.gui.getScrollX() + this.gui.getOffsetX(this));
        int jtexture = j + this.container.getOffsetY(this) - (this.gui.getScrollY() + this.gui.getOffsetY(this));
        Collection collection = this.inventory.field_70458_d.func_70651_bq();
        if (!collection.isEmpty()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : this.inventory.field_70458_d.func_70651_bq()) {
                Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.gui.bindTexture(inventoryTexture);
                this.gui.drawTexture(this, itexture, jtexture, 140, 32, 0, 166);
                if (potion.func_76400_d()) {
                    int l = potion.func_76392_e();
                    this.gui.drawTexture(this, itexture + 6, jtexture + 7, 18, 18, l % 8 * 18, 198 + l / 8 * 18);
                }
                String s = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                if (potioneffect.func_76458_c() == 1) {
                    s = s + " II";
                } else if (potioneffect.func_76458_c() == 2) {
                    s = s + " III";
                } else if (potioneffect.func_76458_c() == 3) {
                    s = s + " IV";
                }
                this.gui.text(this, s).setShadow(true).drawString(i + 10 + 18, j + 6, 0xFFFFFF);
                this.gui.text(this, Potion.func_76389_a((PotionEffect)potioneffect)).setShadow(true).drawString(i + 10 + 18, j + 6 + 10, 0x7F7F7F);
                j += k;
                jtexture += k;
            }
        }
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 3;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        return false;
    }

    @Override
    public int getSlotCount() {
        return 9;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 2;
    }

    public class ArmorContainerSlot
    extends StackableContainer.ContainerSlot {
        public final int armorType;

        public ArmorContainerSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4, int armorType) {
            super(ArmorContainer.this, player, inventory, par2, par3, par4);
            this.armorType = armorType;
        }

        public int func_75219_a() {
            return 1;
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            if (!super.func_75214_a(stack)) {
                return false;
            }
            Item item = stack == null ? null : stack.func_77973_b();
            return item != null && item.isValidArmor(stack, this.armorType, (Entity)((ArmorContainer)ArmorContainer.this).inventory.field_70458_d);
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon func_75212_b() {
            return ItemArmor.func_94602_b((int)this.armorType);
        }
    }
}

