/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.asm;

import brad16840.common.asm.ObfuscationHelper;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    public static int x;
    public static int y;
    public static float z;
    public static boolean renderItemWasPatched;
    public static Obfuscation class_Entity;
    public static Obfuscation class_EntityLivingBase;
    public static Obfuscation class_EntityLiving;
    public static Obfuscation class_EntityCreature;
    public static Obfuscation class_RenderItem;
    public static Obfuscation class_Slot;
    public static Obfuscation class_GuiContainer;
    public static Obfuscation class_FontRenderer;
    public static Obfuscation class_TextureManager;
    public static Obfuscation class_ItemStack;
    public static Obfuscation class_ModelBiped;
    public static Obfuscation method_handleMouseClick;
    public static Obfuscation method_renderItemAndEffectIntoGUI;
    public static Obfuscation method_onLivingUpdate;
    public static Obfuscation method_updateAITasks;
    public static Obfuscation method_render;
    public static Obfuscation field_riddenByEntity;
    public static Obfuscation field_isJumping;
    public static Obfuscation field_entityToAttack;
    public static Obfuscation field_zLevel;
    public static Obfuscation field_bipedHeadwear;

    public byte[] transform(String className, String transformedNames, byte[] bytes) {
        if (class_RenderItem.matchesClass(className)) {
            return this.patchRenderItem(bytes);
        }
        if (class_GuiContainer.matchesClass(className)) {
            return this.patchGuiContainer(bytes);
        }
        if (class_EntityLivingBase.matchesClass(className)) {
            return this.patchEntityLivingBase(bytes);
        }
        if (class_EntityLiving.matchesClass(className)) {
            return this.patchEntityLiving(bytes);
        }
        if (class_ModelBiped.matchesClass(className)) {
            return this.patchModelBiped(bytes);
        }
        return bytes;
    }

    public byte[] patchRenderItem(byte[] bytes) {
        boolean patched = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String methodDesc = "(L" + class_FontRenderer.toString() + ";L" + class_TextureManager.toString() + ";L" + class_ItemStack.toString() + ";II)V";
        for (MethodNode m : classNode.methods) {
            AbstractInsnNode parser;
            if (!m.name.equals(method_renderItemAndEffectIntoGUI.toString()) || !m.desc.equals(methodDesc)) continue;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInject.add((AbstractInsnNode)new FieldInsnNode(179, "brad16840/common/asm/ClassTransformer", "x", "I"));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 5));
            toInject.add((AbstractInsnNode)new FieldInsnNode(179, "brad16840/common/asm/ClassTransformer", "y", "I"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, class_RenderItem.toString(), field_zLevel.toString(), "F"));
            toInject.add((AbstractInsnNode)new FieldInsnNode(179, "brad16840/common/asm/ClassTransformer", "z", "F"));
            for (parser = m.instructions.get(0); parser != null && !(parser instanceof LineNumberNode); parser = parser.getNext()) {
            }
            if (parser == null) break;
            m.instructions.insert(parser, toInject);
            patched = true;
            break;
        }
        if (!patched) {
            System.out.println("Error: Backpacks! couldn't patch ForgeHooksClient to allow custom items to be rendered");
        } else {
            renderItemWasPatched = true;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchGuiContainer(byte[] bytes) {
        boolean patched = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String methodDesc = "(L" + class_Slot.toString() + ";III)V";
        String tryHandleMouseClickDesc = "(L" + class_Slot.toString() + ";IIIL" + class_GuiContainer.toString() + ";)Z";
        for (MethodNode m : classNode.methods) {
            AbstractInsnNode parser;
            if (!m.name.equals(method_handleMouseClick.toString()) || !m.desc.equals(methodDesc)) continue;
            InsnList toInject = new InsnList();
            Label l0 = new Label();
            LabelNode n0 = new LabelNode(l0);
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new TypeInsnNode(193, "brad16840/common/ContainerStackGui"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(154, n0));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "brad16840/common/ContainerStackGui", "tryHandleMouseClick", tryHandleMouseClickDesc));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, n0));
            toInject.add((AbstractInsnNode)new InsnNode(177));
            toInject.add((AbstractInsnNode)n0);
            for (parser = m.instructions.get(0); parser != null && !(parser instanceof LineNumberNode); parser = parser.getNext()) {
            }
            if (parser == null) break;
            m.instructions.insert(parser, toInject);
            patched = true;
            break;
        }
        if (!patched) {
            System.out.println("Error: Backpacks! couldn't patch GuiContainer to allow its backpacks to be opened from vanilla guis");
        } else {
            System.out.println("Backpacks! has patched GuiContainer to allow its backpacks to be opened from vanilla guis");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchEntityLivingBase(byte[] bytes) {
        boolean patched = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            AbstractInsnNode parser;
            if (!m.name.equals(method_onLivingUpdate.toString()) || !m.desc.equals("()V")) continue;
            InsnList toInject = new InsnList();
            Label l0 = new Label();
            LabelNode n0 = new LabelNode(l0);
            Label l1 = new Label();
            LabelNode n1 = new LabelNode(l1);
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "brad16840/common/UnknownItem", "isCommandedCreature", "(L" + class_EntityLivingBase.toString() + ";)Z"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, n0));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, class_EntityLivingBase.toString(), field_riddenByEntity.toString(), "L" + class_Entity.toString() + ";"));
            toInject.add((AbstractInsnNode)new TypeInsnNode(192, class_EntityLivingBase.toString()));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, class_EntityLivingBase.toString(), field_isJumping.toString(), "Z"));
            toInject.add((AbstractInsnNode)new FieldInsnNode(181, class_EntityLivingBase.toString(), field_isJumping.toString(), "Z"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new TypeInsnNode(193, class_EntityCreature.toString()));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, n1));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new TypeInsnNode(192, class_EntityCreature.toString()));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, class_EntityCreature.toString(), field_entityToAttack.toString(), "L" + class_Entity.toString() + ";"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, class_EntityLivingBase.toString(), field_riddenByEntity.toString(), "L" + class_Entity.toString() + ";"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(166, n1));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new TypeInsnNode(192, class_EntityCreature.toString()));
            toInject.add((AbstractInsnNode)new InsnNode(1));
            toInject.add((AbstractInsnNode)new FieldInsnNode(181, class_EntityCreature.toString(), field_entityToAttack.toString(), "L" + class_Entity.toString() + ";"));
            toInject.add((AbstractInsnNode)n1);
            toInject.add((AbstractInsnNode)n0);
            for (parser = m.instructions.get(0); parser != null && !(parser instanceof LineNumberNode); parser = parser.getNext()) {
            }
            if (parser == null) break;
            m.instructions.insert(parser, toInject);
            patched = true;
            break;
        }
        if (!patched) {
            System.out.println("Error: Backpacks! couldn't patch EntityLivingBase to allow custom items to control mobs");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchEntityLiving(byte[] bytes) {
        boolean patched = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            AbstractInsnNode parser;
            if (!m.name.equals(method_updateAITasks.toString()) || !m.desc.equals("()V")) continue;
            InsnList toInject = new InsnList();
            Label l0 = new Label();
            LabelNode n0 = new LabelNode(l0);
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "brad16840/common/UnknownItem", "isCommandedCreature", "(L" + class_EntityLivingBase.toString() + ";)Z"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(153, n0));
            toInject.add((AbstractInsnNode)new InsnNode(177));
            toInject.add((AbstractInsnNode)n0);
            for (parser = m.instructions.get(0); parser != null && !(parser instanceof LineNumberNode); parser = parser.getNext()) {
            }
            if (parser == null) break;
            m.instructions.insert(parser, toInject);
            patched = true;
            break;
        }
        if (!patched) {
            System.out.println("Error: Backpacks! couldn't patch EntityLiving to allow custom items to control mobs");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchModelBiped(byte[] bytes) {
        boolean patched = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String methodDesc = "(L" + class_Entity.toString() + ";FFFFFF)V";
        String renderBackpackDesc = "(L" + class_ModelBiped + ";L" + class_Entity.toString() + ";F)V";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(method_render.toString()) || !m.desc.equals(methodDesc)) continue;
            ObfuscationHelper.PatternFinder patternFinder = new ObfuscationHelper.PatternFinder();
            patternFinder.addVariable(0);
            patternFinder.addField(field_bipedHeadwear);
            patternFinder.addVariable(7);
            patternFinder.addMethod(method_render);
            ArrayList<AbstractInsnNode> matches = patternFinder.find(m.instructions);
            for (AbstractInsnNode match : matches) {
                InsnList toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInject.add((AbstractInsnNode)new VarInsnNode(23, 7));
                toInject.add((AbstractInsnNode)new MethodInsnNode(184, "brad16840/backpacks/gui/ModelBackpack", "renderBackpack", renderBackpackDesc.toString()));
                m.instructions.insert(match, toInject);
            }
            if (matches.size() <= 0) break;
            patched = true;
            break;
        }
        if (!patched) {
            System.out.println("Error: Backpacks! couldn't patch ModelBiped to allow backpacks to be rendered");
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        renderItemWasPatched = false;
        class_Entity = new Obfuscation("net/minecraft/entity/Entity", "sa");
        class_EntityLivingBase = new Obfuscation("net/minecraft/entity/EntityLivingBase", "sv");
        class_EntityLiving = new Obfuscation("net/minecraft/entity/EntityLiving", "sw");
        class_EntityCreature = new Obfuscation("net/minecraft/entity/EntityCreature", "td");
        class_RenderItem = new Obfuscation("net/minecraft/client/renderer/entity/RenderItem", "bny");
        class_Slot = new Obfuscation("net/minecraft/inventory/Slot", "aay");
        class_GuiContainer = new Obfuscation("net/minecraft/client/gui/inventory/GuiContainer", "bex");
        class_FontRenderer = new Obfuscation("net/minecraft/client/gui/FontRenderer", "bbu");
        class_TextureManager = new Obfuscation("net/minecraft/client/renderer/texture/TextureManager", "bqf");
        class_ItemStack = new Obfuscation("net/minecraft/item/ItemStack", "add");
        class_ModelBiped = new Obfuscation("net/minecraft/client/model/ModelBiped", "bhm");
        method_handleMouseClick = new Obfuscation("handleMouseClick", "a");
        method_renderItemAndEffectIntoGUI = new Obfuscation("renderItemAndEffectIntoGUI", "b");
        method_onLivingUpdate = new Obfuscation("onLivingUpdate", "e");
        method_updateAITasks = new Obfuscation("updateAITasks", "bn");
        method_render = new Obfuscation("render", "a");
        field_riddenByEntity = new Obfuscation("riddenByEntity", "l");
        field_isJumping = new Obfuscation("isJumping", "bc");
        field_entityToAttack = new Obfuscation("entityToAttack", "bm");
        field_zLevel = new Obfuscation("zLevel", "f");
        field_bipedHeadwear = new Obfuscation("bipedHeadwear", "d");
    }

    public static class Obfuscation {
        public static boolean obfuscated = false;
        private String original;
        private String obfuscation;

        public Obfuscation(String original, String obfuscation) {
            this.original = original;
            this.obfuscation = obfuscation;
        }

        public String toString() {
            if (obfuscated) {
                return this.obfuscation;
            }
            return this.original;
        }

        public boolean matchesClass(String className) {
            if (this.original.replace("/", ".").equals(className)) {
                obfuscated = false;
                return true;
            }
            if (this.obfuscation.replace("/", ".").equals(className)) {
                obfuscated = true;
                return true;
            }
            return false;
        }
    }
}

