/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Common;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;

public class UnknownItem
extends Item
implements ISpecialArmor {
    public String field_77774_bZ;
    public int renderType = 1;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] customIcons;
    public static HashMap<String, NBTTagCompound> _existingCustomItems = new HashMap();
    public static HashMap<String, NBTTagCompound> _customItems = new HashMap();
    public static HashMap<String, NBTTagCompound> customItems = new HashMap();
    public static HashMap<EntityLivingBase, Integer> commandedCreatures = new HashMap();
    public static HashMap<String, DamageSource> damageSources = new HashMap();
    private static HashMap<EntityLivingBase, TickManager> tickManagersServer = new HashMap();
    private static HashMap<EntityLivingBase, TickManager> tickManagersClient = new HashMap();
    private static HashMap<String, ArmorEffect> armorEffects = new HashMap();
    private static HashMap<String, Conditional> genericConditionals = new HashMap();
    private boolean wasJustBypassed = false;
    public static final String[] armorTypes;

    public static boolean isCommandedCreature(EntityLivingBase creature) {
        if (commandedCreatures.containsKey(creature)) {
            int t = commandedCreatures.get(creature) - 1;
            if (t == 0 || t == -1) {
                commandedCreatures.remove(creature);
            } else {
                if (t > 0) {
                    commandedCreatures.put(creature, t);
                }
                if (creature.field_70153_n instanceof EntityLivingBase) {
                    creature.field_70759_as = ((EntityLivingBase)creature.field_70153_n).field_70759_as;
                    creature.field_70177_z = ((EntityLivingBase)creature.field_70153_n).field_70177_z;
                    creature.field_70125_A = ((EntityLivingBase)creature.field_70153_n).field_70125_A;
                    creature.field_70701_bs = ((EntityLivingBase)creature.field_70153_n).field_70701_bs * 0.4f;
                    creature.field_70702_br = ((EntityLivingBase)creature.field_70153_n).field_70702_br * 0.4f;
                    if (creature instanceof EntityBlaze || creature instanceof EntityBat || creature instanceof EntityWither || creature instanceof EntityGhast || creature instanceof EntityDragon) {
                        float a = MathHelper.func_76126_a((float)(creature.field_70177_z * (float)Math.PI / 180.0f));
                        float b = MathHelper.func_76134_b((float)(creature.field_70177_z * (float)Math.PI / 180.0f));
                        float c = MathHelper.func_76126_a((float)(creature.field_70125_A * (float)Math.PI / 180.0f));
                        float d = MathHelper.func_76134_b((float)(creature.field_70125_A * (float)Math.PI / 180.0f));
                        creature.field_70159_w = (double)d * (double)(creature.field_70702_br * b - creature.field_70701_bs * a);
                        creature.field_70179_y = (double)d * (double)(creature.field_70701_bs * b + creature.field_70702_br * a);
                        creature.field_70181_x = -c * creature.field_70701_bs;
                    }
                    if (((Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)((EntityLivingBase)creature.field_70153_n), (String[])new String[]{"isJumping"})).booleanValue()) {
                        return true;
                    }
                    return true;
                }
                commandedCreatures.remove(creature);
            }
        }
        return false;
    }

    public UnknownItem(String unlocalizedName) {
        this.field_77774_bZ = unlocalizedName;
        this.func_77655_b(unlocalizedName);
        this.func_77627_a(true);
    }

    public static TickManager getTickManager(EntityLivingBase entity) {
        HashMap<EntityLivingBase, TickManager> managers = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? tickManagersClient : tickManagersServer;
        if (!managers.containsKey(entity)) {
            managers.put(entity, new TickManager());
        }
        return managers.get(entity);
    }

    public static void addArmorEffect(ArmorEffect a) {
        armorEffects.put(a.name, a);
    }

    public static void addConditional(HashMap<String, Conditional> map, Conditional a) {
        map.put(a.name, a);
    }

    private boolean isSubtag(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key, ActionRunner runner, HashMap<String, Conditional> conditionals) {
        if (key.equals("if")) {
            tag = tag.func_74775_l(key);
            boolean success = true;
            for (Object k : tag.func_150296_c()) {
                if (conditionals != null && conditionals.containsKey(k)) {
                    if (conditionals.get(k).process(player, stack, tag).booleanValue()) continue;
                    success = false;
                    continue;
                }
                if (!genericConditionals.containsKey(k) || genericConditionals.get(k).process(player, stack, tag).booleanValue()) continue;
                success = false;
            }
            if (tag.func_150297_b("then", 10) && success) {
                runner.run(player, stack, tag.func_74775_l("then"), conditionals);
            } else if (tag.func_150297_b("else", 10) && !success) {
                runner.run(player, stack, tag.func_74775_l("else"), conditionals);
            }
            return true;
        }
        if (key.equals("ifAny")) {
            tag = tag.func_74775_l(key);
            boolean success = false;
            for (Object k : tag.func_150296_c()) {
                if (conditionals != null && conditionals.containsKey(k)) {
                    if (!conditionals.get(k).process(player, stack, tag).booleanValue()) continue;
                    success = true;
                    continue;
                }
                if (!genericConditionals.containsKey(k) || !genericConditionals.get(k).process(player, stack, tag).booleanValue()) continue;
                success = true;
            }
            if (tag.func_150297_b("then", 10) && success) {
                runner.run(player, stack, tag.func_74775_l("then"), conditionals);
            } else if (tag.func_150297_b("else", 10) && !success) {
                runner.run(player, stack, tag.func_74775_l("else"), conditionals);
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity eplayer, final int slot, final boolean isHeld) {
        if (!(eplayer instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)eplayer;
        UnknownItem.getTickManager((EntityLivingBase)player).slotTick(slot);
        NBTTagCompound tag = UnknownItem.getCompoundTag("passiveEffect", stack);
        if (tag != null) {
            if (tag.func_150297_b("maxTriggers", 99)) {
                String id = UnknownItem.getItemDescriptor(stack);
                int limit = tag.func_74762_e("maxTriggers");
                int duplicates = 1;
                for (int i = 0; i < slot; ++i) {
                    ItemStack s = player.field_71071_by.func_70301_a(i);
                    if (s == null || !(s.func_77973_b() instanceof UnknownItem) || !UnknownItem.getItemDescriptor(s).equals(id)) continue;
                    ++duplicates;
                }
                if (duplicates > limit) {
                    return;
                }
            }
            final int tick = UnknownItem.getTickManager((EntityLivingBase)player).tick;
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    int frequency = 20;
                    do {
                        if (t.func_150297_b("whileHeld", 99) && t.func_74767_n("whileHeld") != isHeld || t.func_150297_b("onHotbar", 99) && t.func_74767_n("onHotbar") != slot < 9) {
                            if (t.func_150297_b("and", 10)) {
                                t = t.func_74775_l("and");
                                continue;
                            }
                            t = null;
                            continue;
                        }
                        if (t.func_150297_b("frequency", 99)) {
                            frequency = t.func_74762_e("frequency");
                        }
                        if (tick % frequency == 0 && armorEffects.containsKey(key)) {
                            int damage = ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t);
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                            } else {
                                UnknownItem.damageItem(stack, damage, player);
                            }
                            if (stack.field_77994_a <= 0) {
                                ((EntityPlayer)player).field_71071_by.field_70462_a[slot] = null;
                            }
                        }
                        t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null;
                    } while (t != null);
                }
            }.run((EntityLivingBase)player, stack, tag, null);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        int eslot;
        for (eslot = 0; eslot < 3 && player.field_71071_by.field_70460_b[eslot] != stack; ++eslot) {
        }
        final int slot = eslot;
        UnknownItem.getTickManager((EntityLivingBase)player).slotTick(slot + player.field_71071_by.field_70462_a.length);
        NBTTagCompound tag = UnknownItem.getCompoundTag("armorEffect", stack);
        if (tag != null) {
            final int tick = UnknownItem.getTickManager((EntityLivingBase)player).tick;
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    int frequency = 20;
                    do {
                        if (t.func_150297_b("frequency", 99)) {
                            frequency = t.func_74762_e("frequency");
                        }
                        if (tick % frequency != 0 || !armorEffects.containsKey(key)) continue;
                        int damage = ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t);
                        if (damage < 0) {
                            stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                        } else {
                            UnknownItem.damageItem(stack, damage, player);
                        }
                        if (stack.field_77994_a > 0) continue;
                        ((EntityPlayer)player).field_71071_by.field_70460_b[slot] = null;
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run((EntityLivingBase)player, stack, tag, null);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77942_o()) {
            String id;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("id") && customItems.containsKey(id = tag.func_74779_i("id")) && customItems.get(id).func_150297_b("default", 10)) {
                NBTTagCompound tag2 = customItems.get(id).func_74775_l("default");
                for (Object key : tag2.func_150296_c()) {
                    if (tag.func_74764_b((String)key)) continue;
                    tag.func_74782_a((String)key, tag2.func_74781_a((String)key).func_74737_b());
                }
            }
            if (UnknownItem.getBooleanTag("markOnCreation", stack)) {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74780_a("x", player.field_70165_t);
                t.func_74780_a("y", player.field_70163_u);
                t.func_74780_a("z", player.field_70161_v);
                t.func_74776_a("yaw", player.field_70177_z);
                t.func_74776_a("pitch", player.field_70125_A);
                t.func_74768_a("dim", player.field_71093_bK);
                stack.func_77978_p().func_74782_a("mark", (NBTBase)t);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.customIcons = new IIcon[10];
        for (int i = 0; i < this.customIcons.length; ++i) {
            this.customIcons[i] = iconRegister.func_94245_a("backpacks16840:custom_icon_" + (i + 1));
        }
        this.field_77791_bV = iconRegister.func_94245_a("backpacks16840:" + this.field_77774_bZ);
    }

    public static ItemStack wrap(String id, int metadata) {
        Item item;
        if (id == null) {
            id = "null";
        }
        if ((item = (Item)GameData.getItemRegistry().func_82594_a(id)) == null) {
            ItemStack stack = new ItemStack((Item)Common.unknownItem, 1, metadata);
            NBTTagCompound tag = new NBTTagCompound();
            if (customItems.containsKey(id) && customItems.get(id).func_150297_b("default", 10)) {
                tag = (NBTTagCompound)customItems.get(id).func_74775_l("default").func_74737_b();
            }
            UniqueItem.setNBTId(tag, id);
            stack.func_77982_d(tag);
            return stack;
        }
        return new ItemStack(item, 1, metadata);
    }

    public static ItemStack wrap(String id, int metadata, int count) {
        ItemStack stack = UnknownItem.wrap(id, metadata);
        stack.field_77994_a = count;
        return stack;
    }

    public static String getItemDescriptor(ItemStack stack) {
        NBTTagCompound tag;
        if (stack == null) {
            return "null";
        }
        if (stack.func_77973_b() instanceof UnknownItem && (tag = stack.func_77978_p()) != null && tag.func_74764_b("id")) {
            return UniqueItem.getNBTId(tag);
        }
        return GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b());
    }

    public static ItemStack unwrap(ItemStack stack) {
        ItemStack result = UnknownItem.wrap(UnknownItem.getItemDescriptor(stack), stack.func_77960_j());
        result.func_77982_d(stack.func_77978_p());
        result.field_77994_a = stack.field_77994_a;
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        String id = UnknownItem.getItemDescriptor(stack);
        if (id == null) {
            id = "null";
        }
        if (GameData.getItemRegistry().func_82594_a(id) == Common.unknownItem) {
            new Translatable("tooltip.unknownitem.item", new Object[0]).addTo(list);
        } else {
            NBTTagCompound tag = UnknownItem.getCompoundTag("appearance", stack);
            if (tag != null) {
                if (tag.func_74764_b("tooltip")) {
                    int durabilityLeft = stack.func_77958_k() - stack.func_77960_j();
                    int maxDurability = stack.func_77958_k();
                    String tooltip = tag.func_74779_i("tooltip");
                    tooltip = tooltip.replace("%damage%", "" + stack.func_77952_i());
                    tooltip = tooltip.replace("%durability%", "" + stack.func_77958_k());
                    tooltip = tooltip.replace("%durabilityLeft%", "" + durabilityLeft);
                    if (customItems.containsKey(id) && customItems.get(id).func_150297_b("durability", 99)) {
                        maxDurability = customItems.get(id).func_74762_e("durability");
                    }
                    tooltip = maxDurability != 0 ? tooltip.replace("%durabilityPercent%", "" + 100 * durabilityLeft / maxDurability + "%") : tooltip.replace("%durabilityPercent%", "100%");
                    Translatable.addTo(tooltip, list);
                }
                return;
            }
            new Translatable("tooltip.unknownitem.proxy", id, stack.func_77960_j()).addTo(list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return this.renderType;
    }

    public static ItemStack getProxyFromTag(NBTTagCompound tag, ItemStack self) {
        int damage;
        int n = tag.func_150297_b("damage", 99) ? tag.func_74762_e("damage") : (tag.func_150297_b("Damage", 99) ? tag.func_74762_e("Damage") : (damage = tag.func_150297_b("metadata", 99) ? tag.func_74762_e("metadata") : self.func_77960_j()));
        int count = tag.func_150297_b("count", 99) ? tag.func_74762_e("count") : (tag.func_150297_b("Count", 99) ? tag.func_74762_e("Count") : self.field_77994_a);
        ItemStack stack = UnknownItem.wrap(tag.func_74779_i("id"), damage, count);
        if (tag.func_150297_b("tag", 10)) {
            stack.func_77982_d(tag.func_74775_l("tag"));
        } else if (tag.func_150297_b("data", 10)) {
            stack.func_77982_d(tag.func_74775_l("data"));
        }
        return stack;
    }

    public static String getStringTag(String key, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (tag.func_74764_b(key)) {
            return tag.func_74779_i(key);
        }
        String id = tag.func_74779_i("id");
        if (customItems.containsKey(id) && customItems.get(id).func_74764_b(key)) {
            return customItems.get(id).func_74779_i(key);
        }
        return null;
    }

    public static Integer getIntegerTag(String key, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (tag.func_150297_b(key, 99)) {
            return tag.func_74762_e(key);
        }
        String id = tag.func_74779_i("id");
        if (customItems.containsKey(id) && customItems.get(id).func_150297_b(key, 99)) {
            return customItems.get(id).func_74762_e(key);
        }
        return null;
    }

    public static boolean getBooleanTag(String key, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        if (tag.func_150297_b(key, 99)) {
            return tag.func_74767_n(key);
        }
        String id = tag.func_74779_i("id");
        if (customItems.containsKey(id) && customItems.get(id).func_150297_b(key, 99)) {
            return customItems.get(id).func_74767_n(key);
        }
        return false;
    }

    public static NBTTagCompound getCompoundTag(String key, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (tag.func_150297_b(key, 10)) {
            return tag.func_74775_l(key);
        }
        String id = tag.func_74779_i("id");
        if (customItems.containsKey(id) && customItems.get(id).func_150297_b(key, 10)) {
            return customItems.get(id).func_74775_l(key);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 > 0 && par1 <= this.customIcons.length) {
            return this.customIcons[par1 - 1];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        this.renderType = 1;
        NBTTagCompound tag = UnknownItem.getCompoundTag("appearance", stack);
        if (tag != null) {
            ItemStack result = UnknownItem.getProxyFromTag(tag, stack);
            this.renderType = result.func_77973_b().func_94901_k();
            return result.func_77973_b().getIcon(result, pass);
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        this.renderType = 1;
        NBTTagCompound tag = UnknownItem.getCompoundTag("appearance", stack);
        if (tag != null) {
            ItemStack result = UnknownItem.getProxyFromTag(tag, stack);
            this.renderType = result.func_77973_b().func_94901_k();
            return result.func_77973_b().func_77650_f(result);
        }
        return super.func_77650_f(stack);
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("appearance", stack);
        if (tag != null) {
            if (tag.func_74764_b("name")) {
                return tag.func_74779_i("name");
            }
            return UnknownItem.getItemDescriptor(stack);
        }
        return super.func_77653_i(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        Integer durability = UnknownItem.getIntegerTag("durability", stack);
        if (durability != null) {
            return durability;
        }
        return super.getMaxDamage(stack);
    }

    private void getMobConditionals(HashMap<String, Conditional> conditionals, final EntityLivingBase entity) {
        UnknownItem.addConditional(conditionals, new Conditional("mobType"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                String mobType = EntityList.func_75617_a((int)entity.func_145782_y());
                if (parent.func_74781_a(this.name).func_74732_a() == 9) {
                    NBTTagList list = parent.func_150295_c(this.name, 8);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        if (!list.func_150307_f(i).equals(mobType)) continue;
                        return true;
                    }
                } else if (parent.func_74764_b(this.name)) {
                    return parent.func_74779_i(this.name).equals(mobType);
                }
                return false;
            }
        });
        UnknownItem.addConditional(conditionals, new Conditional("mobHealthEquals"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                int value = (int)Math.floor(entity.func_110143_aJ());
                if (parent.func_74781_a(this.name).func_74732_a() == 11) {
                    int[] list;
                    for (int i : list = parent.func_74759_k(this.name)) {
                        if (i != value) continue;
                        return true;
                    }
                } else if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74762_e(this.name) == value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(conditionals, new Conditional("mobHealthAbove"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                double value = entity.func_110143_aJ();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74769_h(this.name) < value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(conditionals, new Conditional("mobHealthBelow"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                double value = entity.func_110143_aJ();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74769_h(this.name) > value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("mobInWater"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.func_70090_H();
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("mobInLava"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.func_70058_J();
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("mobOnGround"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.field_70122_E;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("mobInAir"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == (!player.field_70122_E && !player.func_70058_J() && !player.func_70090_H());
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("mobNameEquals"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_74764_b(this.name)) {
                    return parent.func_74779_i(this.name).equals(player.func_70005_c_());
                }
                return false;
            }
        });
    }

    private void getBlockConditionals(HashMap<String, Conditional> conditionals, final Block block, final Integer metadata) {
        UnknownItem.addConditional(conditionals, new Conditional("blockId"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                String blockId = UniqueItem.getDescriptor(block);
                if (parent.func_74781_a(this.name).func_74732_a() == 9) {
                    NBTTagList list = parent.func_150295_c(this.name, 8);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        if (!list.func_150307_f(i).equals(blockId)) continue;
                        return true;
                    }
                } else if (parent.func_74764_b(this.name)) {
                    return parent.func_74779_i(this.name).equals(blockId);
                }
                return false;
            }
        });
        if (metadata != null) {
            UnknownItem.addConditional(conditionals, new Conditional("blockMetadata"){

                @Override
                public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                    int value = metadata;
                    if (parent.func_74781_a(this.name).func_74732_a() == 11) {
                        int[] list;
                        for (int i : list = parent.func_74759_k(this.name)) {
                            if (i != value) continue;
                            return true;
                        }
                    } else if (parent.func_150297_b(this.name, 99)) {
                        return parent.func_74762_e(this.name) == value;
                    }
                    return false;
                }
            });
        }
    }

    public boolean func_77644_a(ItemStack stack, final EntityLivingBase entity, EntityLivingBase player) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("attackMob", stack);
        if (tag != null) {
            HashMap<String, Conditional> conditionals = new HashMap<String, Conditional>();
            this.getMobConditionals(conditionals, entity);
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    do {
                        if (armorEffects.containsKey(key)) {
                            int damage = t.func_150297_b("targetSelf", 99) && t.func_74767_n("targetSelf") ? ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t) : ((ArmorEffect)armorEffects.get(key)).process(entity, stack, (NBTTagCompound)t, player);
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("useItem")) {
                            boolean result = false;
                            ItemStack item = UnknownItem.getProxyFromTag(t, stack);
                            if (!(item.func_77973_b() instanceof UnknownItem)) {
                                result = item.func_77973_b().func_77644_a(item, entity, player);
                            }
                            if (!result || !t.func_150297_b("durabilityCost", 99)) continue;
                            int damage = t.func_74762_e("durabilityCost");
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("mount")) {
                            player.func_70078_a((Entity)entity);
                            if (!t.func_150297_b("controlMob", 10)) continue;
                            ((ArmorEffect)armorEffects.get("controlMob")).process(player, stack, t.func_74775_l("controlMob"));
                            continue;
                        }
                        if (!key.equals("carry")) continue;
                        entity.func_70078_a((Entity)player);
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run(player, stack, tag, conditionals);
        }
        return true;
    }

    public boolean func_150894_a(ItemStack stack, final World world, final Block block, final int x, final int y, final int z, EntityLivingBase player) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("breakBlock", stack);
        if (tag != null) {
            HashMap<String, Conditional> conditionals = new HashMap<String, Conditional>();
            this.getBlockConditionals(conditionals, block, null);
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    if (key.equals("damageDurability") && (double)block.func_149712_f(world, x, y, z) == 0.0) {
                        return;
                    }
                    Object t = tag.func_74775_l(key);
                    do {
                        if (!armorEffects.containsKey(key)) continue;
                        int damage = ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t);
                        if (damage < 0) {
                            stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                            continue;
                        }
                        UnknownItem.damageItem(stack, damage, player);
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run(player, stack, tag, conditionals);
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            ItemStack result;
            if (tag.func_74764_b("type")) {
                String type = tag.func_74779_i("type");
                if (type.equals("eat")) {
                    return EnumAction.eat;
                }
                if (type.equals("drink")) {
                    return EnumAction.drink;
                }
                if (type.equals("block")) {
                    return EnumAction.block;
                }
                if (type.equals("bow")) {
                    return EnumAction.bow;
                }
            } else if (tag.func_150297_b("useItem", 10) && !((result = UnknownItem.getProxyFromTag(tag.func_74775_l("useItem"), stack)).func_77973_b() instanceof UnknownItem)) {
                return result.func_77973_b().func_77661_b(result);
            }
        }
        return super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            ItemStack result;
            if (tag.func_150297_b("duration", 99)) {
                return tag.func_74762_e("duration");
            }
            if (tag.func_150297_b("useItem", 10) && !((result = UnknownItem.getProxyFromTag(tag.func_74775_l("useItem"), stack)).func_77973_b() instanceof UnknownItem)) {
                return result.func_77973_b().func_77626_a(result);
            }
        }
        return super.func_77626_a(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, final World world, final int x, final int y, final int z, final int side, final float hitX, final float hitY, final float hitZ) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("blockAction", stack);
        if (tag != null) {
            final Block block = world.func_147439_a(x, y, z);
            final int metadata = world.func_72805_g(x, y, z);
            HashMap<String, Conditional> conditionals = new HashMap<String, Conditional>();
            this.getBlockConditionals(conditionals, block, metadata);
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    do {
                        boolean flag;
                        if (armorEffects.containsKey(key)) {
                            int damage = ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t);
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("useItem")) {
                            boolean result = false;
                            ItemStack item = UnknownItem.getProxyFromTag(t, stack);
                            if (!(item.func_77973_b() instanceof UnknownItem)) {
                                result = item.func_77973_b().func_77648_a(item, (EntityPlayer)player, world, x, y, z, side, hitX, hitY, hitZ);
                                if (((EntityPlayer)player).field_71071_by.func_70448_g() == null) {
                                    ((EntityPlayer)player).field_71071_by.func_70437_b(stack);
                                }
                            }
                            if (!result || !t.func_150297_b("durabilityCost", 99)) continue;
                            int damage = t.func_74762_e("durabilityCost");
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (!key.equals("break")) continue;
                        if (t.func_150297_b("creative", 99) && t.func_74767_n("creative")) {
                            boolean bl = flag = ((EntityPlayer)player).func_82247_a(x, y, z, side, stack) && world.func_147468_f(x, y, z);
                            if (!flag || !t.func_74767_n("dropItems")) continue;
                            block.func_149636_a(world, (EntityPlayer)player, x, y, z, metadata);
                            continue;
                        }
                        block.func_149681_a(world, x, y, z, metadata, (EntityPlayer)player);
                        flag = block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true);
                        if (flag) {
                            block.func_149664_b(world, x, y, z, metadata);
                        }
                        if (!flag || !block.canHarvestBlock((EntityPlayer)player, metadata) || !t.func_74767_n("dropItems")) continue;
                        block.func_149636_a(world, (EntityPlayer)player, x, y, z, metadata);
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run((EntityLivingBase)player, stack, tag, conditionals);
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public static void damageItem(ItemStack stack, int damage, EntityLivingBase player) {
        if (damage == 0) {
            return;
        }
        ItemStack rest = null;
        if (stack.field_77994_a > 1) {
            rest = stack.func_77979_a(stack.field_77994_a - 1);
        }
        stack.func_77972_a(damage, player);
        if (rest != null && player instanceof EntityPlayer) {
            if (!((EntityPlayer)player).field_71071_by.func_70441_a(rest)) {
                ((EntityPlayer)player).func_71019_a(rest, false);
            }
        } else if (rest != null) {
            player.func_70099_a(rest, 1.0f);
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, final EntityLivingBase entity) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("mobAction", stack);
        if (tag != null) {
            HashMap<String, Conditional> conditionals = new HashMap<String, Conditional>();
            this.getMobConditionals(conditionals, entity);
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    do {
                        if (armorEffects.containsKey(key)) {
                            int damage = t.func_150297_b("targetSelf", 99) && t.func_74767_n("targetSelf") ? ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t) : ((ArmorEffect)armorEffects.get(key)).process(entity, stack, (NBTTagCompound)t, player);
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("useItem")) {
                            boolean result = false;
                            ItemStack item = UnknownItem.getProxyFromTag(t, stack);
                            if (!(item.func_77973_b() instanceof UnknownItem)) {
                                result = item.func_77973_b().func_111207_a(item, (EntityPlayer)player, entity);
                                if (((EntityPlayer)player).field_71071_by.func_70448_g() == null) {
                                    ((EntityPlayer)player).field_71071_by.func_70437_b(stack);
                                }
                            }
                            if (!result || !t.func_150297_b("durabilityCost", 99)) continue;
                            int damage = t.func_74762_e("durabilityCost");
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("mount")) {
                            player.func_70078_a((Entity)entity);
                            if (!t.func_150297_b("controlMob", 10)) continue;
                            ((ArmorEffect)armorEffects.get("controlMob")).process(player, stack, t.func_74775_l("controlMob"));
                            continue;
                        }
                        if (!key.equals("carry")) continue;
                        entity.func_70078_a((Entity)player);
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run((EntityLivingBase)player, stack, tag, conditionals);
            return true;
        }
        return super.func_111207_a(stack, player, entity);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, final int count) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    Object t = tag.func_74775_l(key);
                    int frequency = 0;
                    do {
                        if (t.func_150297_b("frequency", 99)) {
                            frequency = t.func_74762_e("frequency");
                        }
                        if (frequency == 0 || count % frequency != 0) continue;
                        if (armorEffects.containsKey(key)) {
                            int damage = ((ArmorEffect)armorEffects.get(key)).process(player, stack, (NBTTagCompound)t);
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (key.equals("useItem")) {
                            ItemStack item = UnknownItem.getProxyFromTag(t, stack);
                            if (!(item.func_77973_b() instanceof UnknownItem)) {
                                item.func_77973_b().onUsingTick(item, (EntityPlayer)player, count);
                                if (((EntityPlayer)player).field_71071_by.func_70448_g() == null) {
                                    ((EntityPlayer)player).field_71071_by.func_70437_b(stack);
                                }
                            }
                            if (!t.func_150297_b("durabilityCost", 99)) continue;
                            int damage = t.func_74762_e("durabilityCost");
                            if (damage < 0) {
                                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                                continue;
                            }
                            UnknownItem.damageItem(stack, damage, player);
                            continue;
                        }
                        if (!key.equals("dropMob") || player.field_70153_n == null) continue;
                        player.field_70153_n.func_70078_a(null);
                    } while ((t = t.func_150297_b("and", 10) ? t.func_74775_l("and") : null) != null);
                }
            }.run((EntityLivingBase)player, stack, tag, null);
        }
        super.onUsingTick(stack, player, count);
    }

    public ItemStack func_77654_b(ItemStack stack, final World world, EntityPlayer player) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    NBTTagCompound t = tag.func_74775_l(key);
                    UnknownItem.this.processUseAction((EntityPlayer)player, world, stack, key, t, true);
                }
            }.run((EntityLivingBase)player, stack, tag, null);
            return stack;
        }
        return super.func_77654_b(stack, world, player);
    }

    public void processUseAction(EntityPlayer player, World world, ItemStack stack, String key, NBTTagCompound t, boolean onFinished) {
        if (onFinished ? !t.func_150297_b("onFinished", 99) || !t.func_74767_n("onFinished") : (t.func_150297_b("onFinished", 99) ? t.func_74767_n("onFinished") : t.func_150297_b("frequency", 99))) {
            if (t.func_150297_b("and", 10)) {
                this.processUseAction(player, world, stack, key, t.func_74775_l("and"), onFinished);
            }
            return;
        }
        if (armorEffects.containsKey(key)) {
            int damage = armorEffects.get(key).process((EntityLivingBase)player, stack, t);
            if (damage < 0) {
                stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
            } else {
                UnknownItem.damageItem(stack, damage, (EntityLivingBase)player);
            }
        } else if (key.equals("useItem")) {
            ItemStack item = UnknownItem.getProxyFromTag(t, stack);
            if (!(item.func_77973_b() instanceof UnknownItem)) {
                if (onFinished) {
                    item.func_77973_b().func_77654_b(item, world, player);
                } else {
                    item.func_77973_b().func_77659_a(item, world, player);
                }
                if (player.field_71071_by.func_70448_g() == null) {
                    player.field_71071_by.func_70437_b(stack);
                }
            }
            if (t.func_150297_b("durabilityCost", 99)) {
                int damage = t.func_74762_e("durabilityCost");
                if (damage < 0) {
                    stack.field_77994_a = Math.max(0, stack.field_77994_a + damage);
                } else {
                    UnknownItem.damageItem(stack, damage, (EntityLivingBase)player);
                }
            }
        } else if (key.equals("dropMob") && player.field_70153_n != null) {
            player.field_70153_n.func_70078_a(null);
        }
        if (t.func_150297_b("and", 10)) {
            this.processUseAction(player, world, stack, key, t.func_74775_l("and"), onFinished);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null && tag.func_150297_b("bypassBlocks", 99)) {
            this.useAction(stack, world, player);
            this.wasJustBypassed = true;
            return tag.func_74767_n("bypassBlocks");
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            if (!this.wasJustBypassed) {
                return this.useAction(stack, world, player);
            }
            this.wasJustBypassed = false;
        }
        return UnknownItem.unwrap(stack);
    }

    public ItemStack useAction(ItemStack stack, final World world, EntityPlayer player) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("useAction", stack);
        if (tag != null) {
            if (tag.func_150297_b("duration", 99)) {
                player.func_71008_a(stack, stack.func_77988_m());
            }
            new ActionRunner(){

                @Override
                public void processAction(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, String key) {
                    NBTTagCompound t = tag.func_74775_l(key);
                    UnknownItem.this.processUseAction((EntityPlayer)player, world, stack, key, t, false);
                }
            }.run((EntityLivingBase)player, stack, tag, null);
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("harvestLevel", stack);
        if (tag != null) {
            return ImmutableSet.copyOf((Collection)tag.func_150296_c());
        }
        return super.getToolClasses(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("appearance", stack);
        if (tag != null && tag.func_150297_b("enchanted", 99)) {
            return tag.func_74767_n("enchanted");
        }
        return super.hasEffect(stack, pass);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("harvestLevel", stack);
        if (tag != null) {
            if (!tag.func_150297_b(toolClass, 99)) {
                return -1;
            }
            return tag.func_74762_e(toolClass);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("miningSpeed", stack);
        if (tag != null) {
            String blockId = UniqueItem.getDescriptor(block).replace(':', '.');
            if (tag.func_150297_b(blockId + '@' + meta, 99)) {
                return tag.func_74760_g(blockId + '@' + meta);
            }
            if (tag.func_150297_b(blockId, 99)) {
                return tag.func_74760_g(blockId);
            }
            if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) && tag.func_150297_b("effective", 99)) {
                return tag.func_74760_g("effective");
            }
            return tag.func_74760_g("all");
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public int getItemStackLimit(ItemStack stack) {
        Integer stackLimit = UnknownItem.getIntegerTag("stackLimit", stack);
        if (stackLimit != null) {
            return stackLimit;
        }
        return super.getItemStackLimit(stack);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("canWear", stack);
        if (tag != null) {
            String type = "other";
            if (armorType >= 0 && armorType < 4) {
                type = armorTypes[armorType];
            }
            return tag.func_150297_b(type, 10);
        }
        return super.isValidArmor(stack, armorType, entity);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack stack, DamageSource source, double damage, int armorType) {
        NBTTagCompound tag;
        String type = "other";
        if ((armorType = 3 - armorType) >= 0 && armorType < 4) {
            type = armorTypes[armorType];
        }
        if ((tag = UnknownItem.getCompoundTag("canWear", stack)) == null || !tag.func_74764_b(type)) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        tag = tag.func_74775_l(type);
        double damageReduceAmount = 0.0;
        if (tag.func_150297_b("armor", 99) && !source.func_76363_c()) {
            damageReduceAmount = tag.func_74769_h("armor");
        }
        if (tag.func_150297_b(source.func_76355_l(), 99)) {
            damageReduceAmount = tag.func_74769_h(source.func_76355_l());
        }
        int maxDamage = stack.func_77958_k() + 1 - stack.func_77960_j();
        if (!stack.func_77984_f()) {
            maxDamage = Integer.MAX_VALUE;
        }
        return new ISpecialArmor.ArmorProperties(0, damageReduceAmount / 25.0, maxDamage);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack stack, int armorType) {
        NBTTagCompound tag;
        String type = "other";
        if ((armorType = 3 - armorType) >= 0 && armorType < 4) {
            type = armorTypes[armorType];
        }
        if ((tag = UnknownItem.getCompoundTag("canWear", stack)) == null || !tag.func_74764_b(type)) {
            return 0;
        }
        if ((tag = tag.func_74775_l(type)).func_150297_b("armor", 99)) {
            return (int)tag.func_74769_h("armor");
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound tag = UnknownItem.getCompoundTag("armorDamageScale", stack);
        if (tag != null) {
            float scale = 1.0f;
            if (tag.func_150297_b("all", 99)) {
                scale = tag.func_74760_g("all");
            }
            if (tag.func_150297_b(source.func_76355_l(), 99)) {
                scale = tag.func_74760_g(source.func_76355_l());
            }
            damage = (int)((float)damage * scale);
        }
        UnknownItem.damageItem(stack, damage, entity);
    }

    static {
        damageSources.put(DamageSource.field_76372_a.field_76373_n, DamageSource.field_76372_a);
        damageSources.put(DamageSource.field_76370_b.field_76373_n, DamageSource.field_76370_b);
        damageSources.put(DamageSource.field_76371_c.field_76373_n, DamageSource.field_76371_c);
        damageSources.put(DamageSource.field_76368_d.field_76373_n, DamageSource.field_76368_d);
        damageSources.put(DamageSource.field_76369_e.field_76373_n, DamageSource.field_76369_e);
        damageSources.put(DamageSource.field_76366_f.field_76373_n, DamageSource.field_76366_f);
        damageSources.put(DamageSource.field_76367_g.field_76373_n, DamageSource.field_76367_g);
        damageSources.put(DamageSource.field_76379_h.field_76373_n, DamageSource.field_76379_h);
        damageSources.put(DamageSource.field_76380_i.field_76373_n, DamageSource.field_76380_i);
        damageSources.put(DamageSource.field_76377_j.field_76373_n, DamageSource.field_76377_j);
        damageSources.put(DamageSource.field_76376_m.field_76373_n, DamageSource.field_76376_m);
        damageSources.put(DamageSource.field_82727_n.field_76373_n, DamageSource.field_82727_n);
        damageSources.put(DamageSource.field_82728_o.field_76373_n, DamageSource.field_82728_o);
        damageSources.put(DamageSource.field_82729_p.field_76373_n, DamageSource.field_82729_p);
        damageSources.put("explosion", new DamageSource("explosion").func_76351_m().func_94540_d());
        UnknownItem.addArmorEffect(new ArmorEffect("damageDurability"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                return tag.func_150297_b("amount", 99) ? tag.func_74762_e("amount") : 1;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("repairDurability"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                int damage = stack.func_77960_j() - (tag.func_150297_b("amount", 99) ? tag.func_74762_e("amount") : 1);
                if (damage < 0) {
                    if (tag.func_74767_n("exceedMaxDurability")) {
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        stack.func_77978_p().func_74768_a("durability", stack.func_77958_k() - damage);
                    }
                    damage = 0;
                }
                stack.func_77964_b(damage);
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("accelerate"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (player.field_70154_o != null && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                    if (!tag.func_74767_n("targetRiddenMob")) {
                        return 0;
                    }
                }
                double a = Math.sin((double)player.field_70177_z * Math.PI / 180.0);
                double b = Math.cos((double)player.field_70177_z * Math.PI / 180.0);
                double c = Math.sin((double)player.field_70125_A * Math.PI / 180.0);
                double d = Math.cos((double)player.field_70125_A * Math.PI / 180.0);
                if (tag.func_150297_b("swimming", 10) && (player.func_70090_H() || player.func_70058_J())) {
                    tag = tag.func_74775_l("swimming");
                }
                if (tag.func_150297_b("inAir", 10) && !player.field_70122_E) {
                    tag = tag.func_74775_l("inAir");
                }
                if (tag.func_150297_b("onGround", 10) && player.field_70122_E) {
                    tag = tag.func_74775_l("onGround");
                }
                if (!tag.func_74767_n("fullyDirectional")) {
                    c = 0.0;
                    d = 1.0;
                }
                if (!tag.func_74767_n("invertDirectionalY")) {
                    c = -c;
                }
                double incrementForwards = d * tag.func_74769_h("x");
                double incrementSideways = tag.func_74769_h("z");
                double incrementUp = tag.func_74769_h("y") + c * tag.func_74769_h("x");
                double limitX = tag.func_150297_b("xLimit", 99) ? tag.func_74769_h("xLimit") : incrementForwards;
                double limitY = tag.func_150297_b("yLimit", 99) ? tag.func_74769_h("yLimit") : incrementSideways;
                double limitZ = tag.func_150297_b("zLimit", 99) ? tag.func_74769_h("zLimit") : incrementUp;
                TickManager tm = UnknownItem.getTickManager(player);
                AccelerationChange change = AccelerationChange.create(0, -(a * incrementForwards + b * incrementSideways), -(a * limitX + b * limitZ));
                tm.accelerationChanges.add(change);
                change.process(tm, player);
                change = AccelerationChange.create(1, incrementUp, limitY);
                tm.accelerationChanges.add(change);
                change.process(tm, player);
                change = AccelerationChange.create(2, b * incrementForwards + a * incrementSideways, b * limitX + a * limitZ);
                tm.accelerationChanges.add(change);
                change.process(tm, player);
                tm.processAccelerationChange(player);
                player.field_70143_R = tag.func_150297_b("fallDistance", 99) ? (player.field_70143_R += tag.func_74760_g("fallDistance")) : (float)((double)player.field_70143_R - incrementUp * 10.0);
                if (player.field_70143_R < 0.0f) {
                    player.field_70143_R = 0.0f;
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("hurt"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                return this.process(player, stack, tag, null);
            }

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, EntityLivingBase sourceEntity) {
                float min;
                float health = player.func_110143_aJ();
                float rate = tag.func_150297_b("amount", 99) ? tag.func_74760_g("amount") : 1.0f;
                float amount = Math.max(rate, health - (min = tag.func_150297_b("min", 99) ? tag.func_74760_g("min") : -1.0f));
                if (amount > 0.0f) {
                    DamageSource source = DamageSource.field_76377_j;
                    if (tag.func_74764_b("damageType")) {
                        String type = tag.func_74779_i("damageType");
                        if (damageSources.containsKey(type)) {
                            source = damageSources.get(type);
                        } else if (sourceEntity != null) {
                            if (type.equals("player") && sourceEntity instanceof EntityPlayer) {
                                source = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)sourceEntity));
                            } else if (type.equals("explosion.player")) {
                                source = new EntityDamageSource("explosion.player", (Entity)sourceEntity).func_76351_m().func_94540_d();
                            } else if (type.equals("thorns")) {
                                source = DamageSource.func_92087_a((Entity)sourceEntity);
                            }
                        }
                    }
                    player.func_70097_a(source, amount);
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("heal"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                float max;
                float health = player.func_110143_aJ();
                float rate = tag.func_150297_b("amount", 99) ? tag.func_74760_g("amount") : 1.0f;
                float amount = Math.min(rate, (max = tag.func_150297_b("max", 99) ? tag.func_74760_g("max") : 20.0f) - health);
                if (amount > 0.0f) {
                    player.func_70691_i(amount);
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("feed"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                int max;
                if (!(player instanceof EntityPlayer)) {
                    return 0;
                }
                int food = ((EntityPlayer)player).func_71024_bL().func_75116_a();
                int rate = tag.func_150297_b("amount", 99) ? tag.func_74762_e("amount") : 1;
                int amount = Math.min(rate, (max = tag.func_150297_b("max", 99) ? tag.func_74762_e("max") : 20) - food);
                if (amount > 0) {
                    ((EntityPlayer)player).func_71024_bL().func_75122_a(amount, 0.5f);
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("extinguish"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (player.func_70027_ad()) {
                    player.func_70066_B();
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("ignite"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                int duration = tag.func_150297_b("duration", 99) ? Math.round((float)tag.func_74762_e("duration") / 20.0f) : 1;
                player.func_70015_d(duration);
                if (tag.func_150297_b("durabilityCost", 99)) {
                    return tag.func_74762_e("durabilityCost");
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("curePoison"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (player.func_70644_a(Potion.field_76436_u)) {
                    player.func_82170_o(Potion.field_76436_u.func_76396_c());
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("cureWither"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (player.func_70644_a(Potion.field_82731_v)) {
                    player.func_82170_o(Potion.field_82731_v.func_76396_c());
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("cure"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (!tag.func_150297_b("id", 99)) {
                    return 0;
                }
                if (player.func_82165_m(tag.func_74762_e("id"))) {
                    player.func_82170_o(tag.func_74762_e("id"));
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("inflict"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (tag.func_150297_b("id", 99)) {
                    if (!(!player.func_82165_m(tag.func_74762_e("id")) || tag.func_150297_b("combine", 99) && tag.func_74767_n("combine"))) {
                        return 0;
                    }
                    int amplifier = tag.func_150297_b("amplifier", 99) ? tag.func_74762_e("amplifier") : (tag.func_150297_b("level", 99) ? tag.func_74762_e("level") : 1);
                    int duration = tag.func_150297_b("duration", 99) ? tag.func_74762_e("duration") : 20;
                    player.func_70690_d(new PotionEffect(tag.func_74762_e("id"), duration, amplifier));
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("dropItem"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (tag.func_74764_b("id")) {
                    ItemStack drop = UnknownItem.getProxyFromTag(tag, new ItemStack(Blocks.field_150346_d, 1, 0));
                    if (tag.func_150297_b("chance", 99)) {
                        Random random = new Random();
                        if (random.nextFloat() > tag.func_74760_g("chance")) {
                            return 0;
                        }
                    }
                    EntityItem ent = player.func_70099_a(drop, 1.0f);
                    if (!tag.func_74767_n("motionless")) {
                        Random rand = new Random();
                        ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    }
                    if (tag.func_150297_b("durabilityCost", 99)) {
                        return tag.func_74762_e("durabilityCost");
                    }
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("recall"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                return this.process(player, stack, tag, null);
            }

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, EntityLivingBase source) {
                if (!stack.func_77978_p().func_150297_b("mark", 10)) {
                    return 0;
                }
                NBTTagCompound t = stack.func_77978_p().func_74775_l("mark");
                if (t.func_150297_b("dim", 99) && player.field_71093_bK != t.func_74762_e("dim")) {
                    if (player instanceof EntityPlayerMP) {
                        int dimension = t.func_74762_e("dim");
                        WorldServer newWorld = ((EntityPlayerMP)player).field_71133_b.func_71218_a(dimension);
                        if (newWorld == null) {
                            return 0;
                        }
                        ((EntityPlayerMP)player).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, dimension, (Teleporter)new BasicTeleporter(newWorld));
                    } else if (source instanceof EntityPlayerMP) {
                        if (t.func_74767_n("riskCreatingPortal")) {
                            player.func_70107_b(0.0, 300.0, 0.0);
                            player.func_71027_c(t.func_74762_e("dim"));
                        } else {
                            return 0;
                        }
                    }
                }
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a(t.func_74769_h("x"), t.func_74769_h("y"), t.func_74769_h("z"), t.func_74760_g("yaw"), t.func_74760_g("pitch"));
                }
                player.func_70080_a(t.func_74769_h("x"), t.func_74769_h("y"), t.func_74769_h("z"), t.func_74760_g("yaw"), t.func_74760_g("pitch"));
                if (tag.func_150297_b("durabilityCost", 99)) {
                    return tag.func_74762_e("durabilityCost");
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("mark"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74780_a("x", player.field_70165_t);
                t.func_74780_a("y", player.field_70163_u);
                t.func_74780_a("z", player.field_70161_v);
                t.func_74776_a("yaw", player.field_70177_z);
                t.func_74776_a("pitch", player.field_70125_A);
                t.func_74768_a("dim", player.field_71093_bK);
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("mark", (NBTBase)t);
                if (tag.func_150297_b("durabilityCost", 99)) {
                    return tag.func_74762_e("durabilityCost");
                }
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("change"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                NBTTagCompound newTag = stack.func_77978_p();
                String newId = UnknownItem.getItemDescriptor(stack);
                int newCount = stack.field_77994_a;
                int newDamage = stack.func_77960_j();
                if (tag.func_150297_b("tag", 10)) {
                    newTag = tag.func_74775_l("tag");
                }
                if (tag.func_74764_b("id")) {
                    newId = tag.func_74779_i("id");
                }
                newTag.func_74778_a("id", newId);
                if (tag.func_150297_b("count", 99)) {
                    newCount = tag.func_74762_e("count");
                }
                if (tag.func_150297_b("damage", 99)) {
                    newDamage = tag.func_74762_e("damage");
                }
                ItemStack newStack = UnknownItem.wrap(newId, newDamage);
                stack.func_77982_d(newTag);
                stack.func_77964_b(newDamage);
                stack.field_77994_a = newCount;
                stack.func_150996_a(newStack.func_77973_b());
                return 0;
            }
        });
        UnknownItem.addArmorEffect(new ArmorEffect("controlMob"){

            @Override
            public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag) {
                if (player.field_70154_o == null || !(player.field_70154_o instanceof EntityLivingBase)) {
                    return 0;
                }
                EntityLivingBase entity = (EntityLivingBase)player.field_70154_o;
                String mobType = EntityList.func_75621_b((Entity)entity);
                if (tag.func_150297_b("mobTypes", 10) && !tag.func_74767_n(mobType)) {
                    return 0;
                }
                commandedCreatures.put(entity, (tag.func_150297_b("duration", 99) ? tag.func_74762_e("duration") : -1) * 2);
                if (tag.func_150297_b("durabilityCost", 99)) {
                    return tag.func_74762_e("durabilityCost");
                }
                return 0;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("damageEquals"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                int value = stack.func_77960_j();
                if (parent.func_74781_a(this.name).func_74732_a() == 11) {
                    int[] list;
                    for (int i : list = parent.func_74759_k(this.name)) {
                        if (i != value) continue;
                        return true;
                    }
                } else if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74762_e(this.name) == value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("damageAbove"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                int value = stack.func_77960_j();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74762_e(this.name) < value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("damageBelow"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                int value = stack.func_77960_j();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74762_e(this.name) > value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("healthEquals"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                int value = (int)Math.floor(player.func_110143_aJ());
                if (parent.func_74781_a(this.name).func_74732_a() == 11) {
                    int[] list;
                    for (int i : list = parent.func_74759_k(this.name)) {
                        if (i != value) continue;
                        return true;
                    }
                } else if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74762_e(this.name) == value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("healthAbove"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                double value = player.func_110143_aJ();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74769_h(this.name) < value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("healthBelow"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                double value = player.func_110143_aJ();
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74769_h(this.name) > value;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("inWater"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.func_70090_H();
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("inLava"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.func_70058_J();
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("onGround"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == player.field_70122_E;
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("inAir"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                if (parent.func_150297_b(this.name, 99)) {
                    return parent.func_74767_n(this.name) == (!player.field_70122_E && !player.func_70058_J() && !player.func_70090_H());
                }
                return false;
            }
        });
        UnknownItem.addConditional(genericConditionals, new Conditional("nameEquals"){

            @Override
            public Boolean process(EntityLivingBase player, ItemStack stack, NBTTagCompound parent) {
                if (parent.func_150297_b("targetRidden", 99) && parent.func_74767_n("targetRidden") && player.field_70154_o instanceof EntityLivingBase) {
                    player = (EntityLivingBase)player.field_70154_o;
                }
                if (parent.func_74764_b(this.name)) {
                    return parent.func_74779_i(this.name).equals(player.func_70005_c_());
                }
                return false;
            }
        });
        armorTypes = new String[]{"helmet", "chestplate", "leggings", "boots"};
    }

    public abstract class ActionRunner {
        public abstract void processAction(EntityLivingBase var1, ItemStack var2, NBTTagCompound var3, String var4);

        public void run(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, HashMap<String, Conditional> conditionals) {
            for (Object key : tag.func_150296_c()) {
                if (!tag.func_74764_b((String)key) || tag.func_74781_a((String)key).func_74732_a() != 10 || UnknownItem.this.isSubtag(player, stack, tag, (String)key, this, conditionals)) continue;
                this.processAction(player, stack, tag, (String)key);
            }
        }
    }

    public static class BasicTeleporter
    extends Teleporter {
        private final WorldServer worldServerInstance;

        public BasicTeleporter(WorldServer par1WorldServer) {
            super(par1WorldServer);
            this.worldServerInstance = par1WorldServer;
        }

        public void func_77185_a(Entity pEntity, double p2, double p3, double p4, float p5) {
            int i = MathHelper.func_76128_c((double)pEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)pEntity.field_70163_u);
            int k = MathHelper.func_76128_c((double)pEntity.field_70161_v);
            this.worldServerInstance.func_147439_a(i, j, k);
            int height = this.worldServerInstance.func_72976_f(i, k);
            pEntity.func_70107_b((double)i, (double)height, (double)k);
        }
    }

    public static abstract class Conditional {
        public String name;

        public Conditional(String name) {
            this.name = name;
        }

        public abstract Boolean process(EntityLivingBase var1, ItemStack var2, NBTTagCompound var3);
    }

    public static abstract class ArmorEffect {
        public String name;

        public ArmorEffect(String name) {
            this.name = name;
        }

        public abstract int process(EntityLivingBase var1, ItemStack var2, NBTTagCompound var3);

        public int process(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, EntityLivingBase source) {
            return this.process(player, stack, tag);
        }
    }

    public static class AccelerationLoss
    extends AccelerationChange {
        public AccelerationLoss(int type, double amount, double threshold) {
            super(type, amount, threshold);
        }

        @Override
        public void process(TickManager manager, EntityLivingBase entity) {
            double current;
            double base = current = this.type == 0 ? manager.totalAccelerationX : (this.type == 1 ? manager.totalAccelerationY : manager.totalAccelerationZ);
            if (current > this.threshold) {
                if (current + this.amount < this.threshold) {
                    manager.accelerationChanges.add(new AccelerationGain(this.type, current - this.threshold, this.threshold));
                    this.amount = current + this.amount - this.threshold;
                    current = this.threshold;
                } else {
                    current += this.amount;
                    manager.accelerationChanges.add(new AccelerationGain(this.type, -this.amount, this.threshold));
                    this.amount = 0.0;
                }
                if (current != base) {
                    if (this.type == 0) {
                        entity.field_70159_w += current - base;
                        manager.totalAccelerationX += current - base;
                    } else if (this.type == 1) {
                        entity.field_70181_x += current - base;
                        manager.totalAccelerationY += current - base;
                    } else {
                        entity.field_70179_y += current - base;
                        manager.totalAccelerationZ += current - base;
                    }
                }
            }
        }
    }

    public static class AccelerationGain
    extends AccelerationChange {
        public AccelerationGain(int type, double amount, double threshold) {
            super(type, amount, threshold);
        }

        @Override
        public void process(TickManager manager, EntityLivingBase entity) {
            double current;
            double base = current = this.type == 0 ? manager.totalAccelerationX : (this.type == 1 ? manager.totalAccelerationY : manager.totalAccelerationZ);
            if (current < this.threshold) {
                if (current + this.amount > this.threshold) {
                    manager.accelerationChanges.add(new AccelerationLoss(this.type, current - this.threshold, this.threshold));
                    this.amount = current + this.amount - this.threshold;
                    current = this.threshold;
                } else if (this.amount > 0.0) {
                    current += this.amount;
                    manager.accelerationChanges.add(new AccelerationLoss(this.type, -this.amount, this.threshold));
                    this.amount = 0.0;
                }
                if (current != base) {
                    if (this.type == 0) {
                        entity.field_70159_w += current - base;
                        manager.totalAccelerationX += current - base;
                    } else if (this.type == 1) {
                        entity.field_70181_x += current - base;
                        manager.totalAccelerationY += current - base;
                    } else {
                        entity.field_70179_y += current - base;
                        manager.totalAccelerationZ += current - base;
                    }
                }
            }
        }
    }

    public static abstract class AccelerationChange {
        public double threshold;
        public int type;
        public double amount;

        public AccelerationChange(int type, double amount, double threshold) {
            this.type = type;
            this.amount = amount;
            this.threshold = threshold;
        }

        public abstract void process(TickManager var1, EntityLivingBase var2);

        public static AccelerationChange create(int type, double amount, double threshold) {
            if (amount < 0.0) {
                return new AccelerationLoss(type, amount, threshold);
            }
            return new AccelerationGain(type, amount, threshold);
        }
    }

    public static class TickManager {
        private int lastSlot = 0;
        public int tick = -1;
        public ArrayList<AccelerationChange> accelerationChanges = new ArrayList();
        public double totalAccelerationX;
        public double totalAccelerationY;
        public double totalAccelerationZ;

        public void slotTick(int slot) {
            if (this.lastSlot >= slot) {
                ++this.tick;
                this.accelerationChanges.clear();
                this.totalAccelerationX = 0.0;
                this.totalAccelerationY = 0.0;
                this.totalAccelerationZ = 0.0;
            }
            this.lastSlot = slot;
        }

        public void processAccelerationChange(EntityLivingBase entity) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < this.accelerationChanges.size(); ++j) {
                    this.accelerationChanges.get(j).process(this, entity);
                }
            }
        }
    }
}

