/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.BackpackChecker;
import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.BackpackBlock;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.LoaderEditor;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.BackpackRestorer;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.ClientProxy;
import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.DynamicRecipes;
import brad16840.common.EntityBlock164;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.Proxy;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import brad16840.common.asm.BCModPlugin;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ChestContainer;
import brad16840.common.gui.PlayerContainer;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.RecipeSorter;

public class Common
extends DummyModContainer {
    public static final String modId = "backpacks16840";
    public static final String versionId = "1.7.10 - 3.0";
    public static String fileVersion = "1.7.2 - 3.0";
    public static boolean shiftOpensInSameStack = false;
    public static boolean _disableItemRestorers = false;
    public static boolean disableItemRestorers;
    public static boolean _disableCraftingGui;
    public static boolean disableCraftingGui;
    public static boolean _disableChestOpening;
    public static boolean disableChestOpening;
    public static boolean disableCustomItemEditing;
    public static boolean _allEditorsRequireOpPermission;
    public static boolean allEditorsRequireOpPermission;
    public static ArrayList<String> drdFilenames;
    private static String configDirectory;
    public static final MessageChannel channel;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding loaderKeyBinding;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler openFirstKeyBinding;
    public static Backpack backpack;
    public static BackpackBlock backpackBlock;
    public static QuantumBackpack quantumBackpack;
    public static Backpack.BackpackResizer backpackResizer;
    public static BackpackRestorer backpackRestorer;
    public static BackpackPouchUpgrade backpackUpgrade;
    public static QuantumChest quantumChest;
    public static boolean _preventQuantumChestCreation;
    public static boolean preventQuantumChestCreation;
    public static boolean _disableBackpackBlocks;
    public static boolean disableBackpackBlocks;
    public static boolean _requirePermissionToDestroyQuantumChest;
    public static boolean requirePermissionToDestroyQuantumChest;
    public static boolean disableAutoLoader;
    public static boolean renderBackpacksIn3D;
    public static boolean animatedQuantumBackpacks;
    public static boolean displayPlacedBackpackNames;
    public static boolean _disableNesting;
    public static boolean disableNesting;
    @SidedProxy(clientSide="brad16840.common.ClientProxy", serverSide="brad16840.common.Proxy")
    public static Proxy proxy;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding permissionKey;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler loadKeyBinding;
    public static UnknownItem unknownItem;
    public static boolean hideUniqueItemIds;
    public static boolean disableRecipeEditor;
    public static boolean allowOpFunctionsInSinglePlayer;
    private long lastOpenTime = 0L;
    public static ArrayList<RecipeInstantiator> recipeInstantiators;
    private WeakHashMap<EntityPlayer, Integer> tickNumbers = new WeakHashMap();
    public static boolean backpackRendererEnabled;
    public static int backpackRendererTickCount;

    public File getSource() {
        return BCModPlugin.source;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    public Common() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = modId;
        meta.name = "Backpacks!";
        meta.version = "3.0.1";
        meta.credits = "Created by Brad16840";
        meta.authorList = Arrays.asList("Brad16840");
        meta.description = "Adds upgradable, customizable backpacks that can be opened with right-click from almost any gui and can be configured to automatically collect specific types of items. Also includes a recipe editor";
        meta.url = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1291844-backpacks-by-brad16840";
        meta.updateUrl = "";
        meta.screenshots = new String[0];
        meta.logoFile = "assets/backpacks16840/textures/logo.png";
    }

    public static void ensureCompatibleWith(String modName, String versionId) {
        if (versionId.equals(versionId)) {
            return;
        }
        throw new RuntimeException(modName + " requires version \"" + versionId + "\" of Backpacks!, but that is incompatible with the installed version (" + versionId + ")");
    }

    public Object getMod() {
        return this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    private void updateIntList(Property p, int[] list) {
        String[] values = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            values[i] = Integer.toString(list[i]);
        }
        p.set(values);
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        String[] filenames;
        configDirectory = event.getModConfigurationDirectory().getAbsolutePath();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        File file = new File(configDirectory + File.separator + "Dynamic_Recipes");
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        if ((filenames = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.equalsIgnoreCase("overridden.drd")) {
                    return false;
                }
                return name.toLowerCase().endsWith(".drd");
            }
        })) == null) {
            filenames = new String[]{};
        }
        drdFilenames = new ArrayList(filenames.length);
        for (String s : filenames) {
            drdFilenames.add(s);
        }
        shiftOpensInSameStack = !config.get("general", "items_open_in_same_section", !shiftOpensInSameStack, "Right-clicking an item will open it in the same inventory section unless you hold down shift, setting this to false will invert that behaviour").getBoolean(!shiftOpensInSameStack);
        disableItemRestorers = _disableItemRestorers = config.get("general", "disable_item_restorers", _disableItemRestorers, "Setting this to true will prevent item restorers from being used").getBoolean(_disableItemRestorers);
        hideUniqueItemIds = config.get("general", "hide_unique_item_ids", hideUniqueItemIds, "If this is true, unique items (like backpacks) won't display their unique id in their tooltip").getBoolean(hideUniqueItemIds);
        disableRecipeEditor = config.get("general", "disable_recipe_editor", disableRecipeEditor, "Setting this to true will prevent opped players from using the ingame recipe editor").getBoolean(disableRecipeEditor);
        allowOpFunctionsInSinglePlayer = config.get("general", "allow_op_functions_in_single_player", allowOpFunctionsInSinglePlayer, "If this is true the player of a single player game counts as being opped when using op-only editors in Backpacks!").getBoolean(allowOpFunctionsInSinglePlayer);
        disableCustomItemEditing = config.get("general", "disable_custom_item_editing", disableCustomItemEditing, "Setting this to true will prevent opped players from editing custom items").getBoolean(disableCustomItemEditing);
        disableChestOpening = _disableChestOpening = config.get("general", "disable_custom_block_interfaces", _disableChestOpening, "Setting this to true will prevent Backpacks! from opening its chest/crafting interface when right-clicking a chest/crafting table").getBoolean(_disableChestOpening);
        disableCraftingGui = _disableCraftingGui = config.get("general", "disable_inventory_crafting_interface", _disableCraftingGui, "Backpacks! allows you to open a crafting table by right-clicking it from your inventory, you can disable that by setting this to true").getBoolean(_disableCraftingGui);
        allEditorsRequireOpPermission = _allEditorsRequireOpPermission = config.get("general", "need_op_permission_to_use_any_editor", _allEditorsRequireOpPermission, "Non opped players can usually configure what items their backpacks will collect/resupply, set this to true to stop that").getBoolean(_allEditorsRequireOpPermission);
        String configVersion = config.get("general", "internal_config_version", "pre", "Used to update existing config values when a mod update requires a change").getString();
        if (configVersion.equals("pre")) {
            this.updateIntList(config.get("general", "backpack_widths", Backpack._widths, "How many columns of storage a backpack with X pouches will have"), Backpack._widths);
            this.updateIntList(config.get("general", "backpack_heights", Backpack._heights, "How many rows of storage a backpack with X pouches will have"), Backpack._heights);
            config.get("general", "animate_quantum_backpacks", animatedQuantumBackpacks, "If this is true the 3d model for quantum backpacks will use its animated texture").set(animatedQuantumBackpacks);
        }
        config.get("general", "internal_config_version", "pre", "Used to update existing config values when a mod update requires a change").set("3.0");
        Backpack._widths = config.get("general", "backpack_widths", Backpack._widths, "How many columns of storage a backpack with X pouches will have").getIntList();
        Backpack._heights = config.get("general", "backpack_heights", Backpack._heights, "How many rows of storage a backpack with X pouches will have").getIntList();
        if (Backpack._widths.length < 1) {
            Backpack._widths = new int[]{3};
        }
        if (Backpack._heights.length < 1) {
            Backpack._heights = new int[]{3};
        }
        if (Backpack._widths.length != Backpack._heights.length) {
            int[] w = Backpack._widths;
            int[] h = Backpack._heights;
            int min = w.length < h.length ? w.length : h.length;
            Backpack._widths = new int[min];
            Backpack._heights = new int[min];
            for (int i = 0; i < min; ++i) {
                Backpack._widths[i] = w[i];
                Backpack._heights[i] = h[i];
            }
            FMLLog.warning((String)"The list of backpack widths was a different size to the list of backpack heights, so unpaired values are being ignored", (Object[])new Object[0]);
        }
        Backpack.widths = Backpack._widths;
        Backpack.heights = Backpack._heights;
        Backpack.forceDefaults = Backpack._forceDefaults = config.get("general", "restrict_backpack_size_to_presets", Backpack._forceDefaults, "If this is true the size of every backpack will be forced to be one of the sizes defined by backpack_widths and backpack_heights, otherwise backpack resizers can be used to freely change the size of individual backpacks").getBoolean(Backpack._forceDefaults);
        BackpackBlock.canDuplicate = BackpackBlock._canDuplicate = config.get("general", "ender_eyes_can_duplicate_backpacks", BackpackBlock._canDuplicate, "If this is true you can 'use' an ender eye on a placed backpack to duplicate it. Any change made to a duplicated backpack will be present in all duplicates (like an ender chest)").getBoolean(BackpackBlock._canDuplicate);
        preventQuantumChestCreation = _preventQuantumChestCreation = config.get("general", "prevent_quantum_chest_placement", _preventQuantumChestCreation, "Setting this to true will prevent new quantum chests being placed in the world, existing chests won't be affected").getBoolean(_preventQuantumChestCreation);
        animatedQuantumBackpacks = config.get("general", "animate_quantum_backpacks", animatedQuantumBackpacks, "If this is true the 3d model for quantum backpacks will use its animated texture").getBoolean(animatedQuantumBackpacks);
        displayPlacedBackpackNames = config.get("general", "show_names_of_placed_backpacks", displayPlacedBackpackNames, "If this is true you will be able to see the name of a placed backpack by looking at it").getBoolean(displayPlacedBackpackNames);
        disableNesting = _disableNesting = config.get("general", "disable_backpack_nesting", _disableNesting, "If this is true you won't be able to put backpacks inside other backpacks :(").getBoolean(_disableNesting);
        renderBackpacksIn3D = config.get("general", "render_backpacks_in_3d", renderBackpacksIn3D, "If this is true backpacks will be rendered in 3d when dropped or in your hand").getBoolean(renderBackpacksIn3D);
        requirePermissionToDestroyQuantumChest = _requirePermissionToDestroyQuantumChest = config.get("general", "require_permission_to_destroy_quantum_chests", _requirePermissionToDestroyQuantumChest, "If this is true, only players with permission to edit a quantum chest will be able to destroy it").getBoolean(_requirePermissionToDestroyQuantumChest);
        disableBackpackBlocks = _disableBackpackBlocks = config.get("general", "disable_backpack_blocks", _disableBackpackBlocks, "If this is true backpacks will not be placeable").getBoolean(_disableBackpackBlocks);
        disableAutoLoader = config.get("general", "disable_backpack_auto_loader", disableAutoLoader, "This will disable the automatic loading and unloading of designated items from backpacks (it won't affect the piping of items to/from placed backpacks)").getBoolean(disableAutoLoader);
        backpackRendererTickCount = config.get("general", "backpack_renderer_refresh_frequency", backpackRendererTickCount, "How many ticks (1/20th of a second) should the backpack renderer wait between checking a player for backpacks. Setting this to 0 will disable backpack checking").getInt(backpackRendererTickCount);
        backpackRendererEnabled = config.get("general", "backpack_renderer_enabled", backpackRendererEnabled, "Whether or not backpacks should be rendered on the backs of players carrying them").getBoolean(backpackRendererEnabled);
        config.save();
        unknownItem = new UnknownItem("unknown_item");
        GameRegistry.registerItem((Item)unknownItem, (String)Common.unknownItem.field_77774_bZ);
        recipeInstantiators.add(new RecipeInstantiator(){

            @Override
            public void instantiateRecipes(ArrayList<String> files) {
                Iterator<String> iterator = files.iterator();
                while (iterator.hasNext()) {
                    String name = iterator.next();
                    if (!name.toLowerCase().startsWith("backpacks")) continue;
                    iterator.remove();
                }
                final ArrayList<String> recipes = new ArrayList<String>();
                if (!Common.loadDynamicRecipes("backpacks " + fileVersion + ".drd", false)) {
                    try {
                        ItemStack craftedBackpack = new ItemStack((Item)backpack, 1, 3);
                        DynamicRecipes.buildRecipe(recipes, (Object)craftedBackpack, "111101121", Items.field_151116_aA, Blocks.field_150445_bS);
                        DynamicRecipes.buildRecipe(recipes, (Object)backpackUpgrade, "112102112", Items.field_151116_aA, Items.field_151007_F);
                        DynamicRecipes.buildRecipe(recipes, (Object)backpackRestorer, "111121131", Items.field_151043_k, Items.field_151061_bv, Blocks.field_150445_bS);
                        DynamicRecipes.buildRecipe(recipes, (Object)quantumChest, "121232121", Items.field_151045_i, Items.field_151061_bv, Blocks.field_150343_Z);
                    }
                    catch (DynamicRecipes.DynamicRecipeException e) {
                        throw new RuntimeException("Backpacks' default recipes couldn't be processed! " + e.getMessage(), e);
                    }
                    if (!Common.drdExists("backpacks " + fileVersion + ".drd")) {
                        FMLLog.warning((String)("Backpacks: 'backpacks " + fileVersion + ".drd' did not exist, so has been created using the default recipe definitions"), (Object[])new Object[0]);
                        Common.saveDynamicRecipes("backpacks " + fileVersion, new DRDFilter(){

                            @Override
                            public boolean includeRecipe(DynamicRecipes.Recipe recipe, boolean disabled) {
                                return !disabled && recipes.contains(recipe.getRepresentation());
                            }
                        }, false);
                    } else {
                        FMLLog.warning((String)("Backpacks: Couldn't load 'backpacks " + fileVersion + ".drd', so using default recipes definitions"), (Object[])new Object[0]);
                    }
                }
            }
        });
        backpack = new Backpack("backpack");
        GameRegistry.registerItem((Item)backpack, (String)Common.backpack.field_77774_bZ);
        quantumBackpack = new QuantumBackpack("quantum_backpack");
        GameRegistry.registerItem((Item)quantumBackpack, (String)Common.quantumBackpack.field_77774_bZ);
        backpackResizer = new Backpack.BackpackResizer("backpack_resizer");
        GameRegistry.registerItem((Item)backpackResizer, (String)Common.backpackResizer.field_77774_bZ);
        backpackRestorer = new BackpackRestorer("backpack_restorer");
        GameRegistry.registerItem((Item)backpackRestorer, (String)Common.backpackRestorer.field_77774_bZ);
        backpackUpgrade = new BackpackPouchUpgrade("backpack_pouch");
        GameRegistry.registerItem((Item)backpackUpgrade, (String)Common.backpackUpgrade.field_77774_bZ);
        backpackBlock = new BackpackBlock("backpack_block");
        GameRegistry.registerBlock((Block)backpackBlock, (String)Common.backpackBlock.field_149770_b);
        GameRegistry.registerBlock((Block)new EntityBlock164((Block)backpackBlock), (String)(Common.backpackBlock.field_149770_b + "164"));
        quantumChest = new QuantumChest("quantum_chest");
        GameRegistry.registerBlock((Block)quantumChest, (String)Common.quantumChest.field_149770_b);
        GameRegistry.registerBlock((Block)new EntityBlock164((Block)quantumChest), (String)(Common.quantumChest.field_149770_b + "164"));
    }

    @Subscribe
    public void load(FMLInitializationEvent event) {
        if (proxy == null) {
            proxy = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? new ClientProxy() : new Proxy();
        }
        proxy.init(this);
        RecipeSorter.register((String)"balancedexchange:dynamicshaped", DynamicRecipes.ShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"balancedexchange:dynamicshapeless", DynamicRecipes.ShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"balancedexchange:dynamicfurnace", DynamicRecipes.FurnaceRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)modId, (IGuiHandler)proxy);
        channel.initialize(modId);
        PacketHandler.registerMessages(channel);
        brad16840.common.permissions.PacketHandler.registerMessages(channel);
        UniqueItem.registerContainerItem(backpack);
        UniqueItem.registerProtectedBlockType(quantumChest);
        brad16840.backpacks.PacketHandler.registerMessages(channel);
        GameRegistry.registerTileEntity(BackpackBlockTileEntity.class, (String)Common.backpackBlock.field_149770_b);
        GameRegistry.registerTileEntity(QuantumChestTileEntity.class, (String)"quantumChest");
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        Logger.register();
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            FMLCommonHandler.instance().bus().register((Object)new KeyBindingRegistry());
            Minecraft.func_71410_x().field_71474_y.func_74300_a();
            ContainerStackGui.customMouseClickHandlers.add(new ContainerStackGui.CustomMouseClickHandler(){

                @Override
                public boolean handle(EntityPlayer player, ItemStack stack, boolean holdingShift) {
                    if ((stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) && !holdingShift) {
                        Backpack.openingStandalone = true;
                        ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
                        return true;
                    }
                    return false;
                }
            });
        }
        for (RecipeInstantiator instantiator : recipeInstantiators) {
            instantiator.instantiateRecipes(drdFilenames);
        }
        for (String name : drdFilenames) {
            Common.loadDynamicRecipes(name, false);
        }
        CraftingManager.func_77594_a().func_77592_b().addAll(DynamicRecipes.recipes.values());
        Common.loadOverriddenCustomItems(false);
        MinecraftForge.EVENT_BUS.register((Object)new InventoryScanner());
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loader");
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loadbackpack");
        PacketHandler.OpenEditorWindow.editors.add(new PacketHandler.OpenEditorWindow.CustomEditor(){

            public boolean load(ContainerStack container, int stackId, EntityPlayer player) {
                StackableContainer stack;
                if (container.stacks.length > stackId && (stack = container.getContainer(stackId)) instanceof ContainerStack.LoadableContainer) {
                    String uuid = stack.getId();
                    NBTTagCompound tag = UniqueItemData.get(player.field_70170_p).getItemData(uuid, false);
                    if (tag == null) {
                        return false;
                    }
                    container.addContainers(player, new StackableContainer[]{new BlockSelector(), new LoaderEditor(uuid, tag, ((ContainerStack.LoadableContainer)((Object)stack)).getName())});
                    return true;
                }
                return false;
            }

            @Override
            public boolean loadEditor(String type, int stackId, ContainerStack container, EntityPlayer player) {
                block7: {
                    block10: {
                        block8: {
                            block9: {
                                if (!type.equals("loadbackpack")) break block7;
                                if (disableAutoLoader) {
                                    new Translatable("problem.autoloaddisabled", new Object[0]).send(player);
                                    return true;
                                }
                                if (container != null) break block8;
                                if (!(player.field_71070_bA instanceof ContainerChest)) break block9;
                                InventoryScanner.loadFromInventory(player, ((ContainerChest)player.field_71070_bA).func_85151_d());
                                player.field_71070_bA.func_75142_b();
                                break block10;
                            }
                            if (!(player.field_71070_bA instanceof ContainerPlayer)) break block10;
                            InventoryScanner.loadFromInventory(player, (IInventory)player.field_71071_by);
                            player.field_71070_bA.func_75142_b();
                            break block10;
                        }
                        for (int i = 0; i < container.stacks.length; ++i) {
                            StackableContainer c = container.getContainer(i);
                            if (c instanceof ChestContainer) {
                                InventoryScanner.loadFromInventory(player, ((ChestContainer)c).inventory);
                                container.func_75142_b();
                                continue;
                            }
                            if (!(c instanceof PlayerContainer)) continue;
                            InventoryScanner.loadFromInventory(player, (IInventory)((PlayerContainer)c).inventory);
                            container.func_75142_b();
                        }
                    }
                    return true;
                }
                if (type.equals("loader") && container.stacks.length > stackId) {
                    int i;
                    if (this.load(container, stackId, player)) {
                        return true;
                    }
                    for (i = stackId; i < container.stacks.length; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                    for (i = 0; i < stackId; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @SubscribeEvent
    public void onKeypress(InputEvent.KeyInputEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleKeypress(event);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT || backpackRendererTickCount == 0) {
            return;
        }
        Integer count = this.tickNumbers.get(event.player);
        count = count == null ? Integer.valueOf(backpackRendererTickCount) : Integer.valueOf(count + 1);
        if (count >= backpackRendererTickCount) {
            count = 0;
            BackpackChecker.update(event.player);
        }
        this.tickNumbers.put(event.player, count);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleKeypress(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || !mc.field_71474_y.field_151445_Q.func_151470_d()) {
            return;
        }
        long time = Minecraft.func_71386_F();
        if (time - this.lastOpenTime < 500L) {
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_151445_Q.func_151463_i(), (boolean)false);
            while (mc.field_71474_y.field_151445_Q.func_151468_f()) {
            }
            return;
        }
        ItemStack stack = mc.field_71439_g.func_71045_bC();
        if (mc.field_71462_r == null && stack != null && stack.func_77973_b() instanceof UniqueItem.OpenableItem && !mc.field_71439_g.func_70093_af()) {
            this.lastOpenTime = time;
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_151445_Q.func_151463_i(), (boolean)false);
            while (mc.field_71474_y.field_151445_Q.func_151468_f()) {
            }
            if (!((UniqueItem.OpenableItem)stack.func_77973_b()).ensureInventoryIdentifiers((EntityPlayer)mc.field_71439_g, stack)) {
                return;
            }
            channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        channel.sendToPlayer(event.player, new PacketHandler.InitializePlayer());
        channel.sendToPlayer(event.player, new PacketHandler.InitializePlayer());
    }

    @SubscribeEvent
    public void loadEvent(WorldEvent.Load event) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        Common.loadOverriddenCustomItems(true);
        DynamicRecipes.FurnaceRecipe.unoverrideRecipes();
        DynamicRecipes.unoverrideRecipes();
        DynamicRecipes.settingOverriddenValues = true;
        Common.loadDynamicRecipes("overridden.drd", true);
        DynamicRecipes.settingOverriddenValues = false;
        DynamicRecipes.sortRecipes();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.itemStack;
        NBTTagCompound tag = UnknownItem.getCompoundTag("tooltip-filter", stack);
        if (tag != null) {
            Multimap multimap;
            int i;
            event.toolTip.clear();
            String s = stack.func_82833_r();
            if (tag.func_74767_n("display-tag") && stack.func_82837_s()) {
                s = EnumChatFormatting.ITALIC + s + EnumChatFormatting.RESET;
            }
            if (event.showAdvancedItemTooltips) {
                String s1 = "";
                if (s.length() > 0) {
                    s = s + " (";
                    s1 = ")";
                }
                i = Item.func_150891_b((Item)stack.func_77973_b());
                s = stack.func_77981_g() ? s + String.format("#%04d/%d%s", i, stack.func_77960_j(), s1) : s + String.format("#%04d%s", i, s1);
            } else if (!stack.func_82837_s() && stack.func_77973_b() == Items.field_151098_aY) {
                s = s + " #" + stack.func_77960_j();
            }
            event.toolTip.add(s);
            if (tag.func_74767_n("item-info")) {
                stack.func_77973_b().func_77624_a(stack, event.entityPlayer, event.toolTip, event.showAdvancedItemTooltips);
            }
            if (stack.func_77942_o()) {
                NBTTagList nbttaglist;
                if (tag.func_74767_n("enchantments") && (nbttaglist = stack.func_77986_q()) != null) {
                    for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.field_77331_b[short1] == null) continue;
                        event.toolTip.add(Enchantment.field_77331_b[short1].func_77316_c((int)short2));
                    }
                }
                if (tag.func_74767_n("display-tag") && stack.field_77990_d.func_150297_b("display", 10)) {
                    NBTTagList nbttaglist1;
                    NBTTagCompound nbttagcompound = stack.field_77990_d.func_74775_l("display");
                    if (nbttagcompound.func_150297_b("color", 3)) {
                        if (event.showAdvancedItemTooltips) {
                            event.toolTip.add("Color: #" + Integer.toHexString(nbttagcompound.func_74762_e("color")).toUpperCase());
                        } else {
                            event.toolTip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.dyed"));
                        }
                    }
                    if (nbttagcompound.func_150299_b("Lore") == 9 && (nbttaglist1 = nbttagcompound.func_150295_c("Lore", 8)).func_74745_c() > 0) {
                        for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                            event.toolTip.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + nbttaglist1.func_150307_f(j));
                        }
                    }
                }
            }
            if (tag.func_74767_n("attributes") && !(multimap = stack.func_111283_C()).isEmpty()) {
                event.toolTip.add("");
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.func_111164_d();
                    double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? attributemodifier.func_111164_d() : attributemodifier.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = ItemStack.field_111284_a.format(d1);
                        objectArray[1] = StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()));
                        event.toolTip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])objectArray));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ItemStack.field_111284_a.format(d1 *= -1.0);
                    objectArray[1] = StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()));
                    event.toolTip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])objectArray));
                }
            }
            if (tag.func_74767_n("durability")) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable")) {
                    event.toolTip.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"item.unbreakable"));
                }
                if (event.showAdvancedItemTooltips && stack.func_77951_h()) {
                    event.toolTip.add("Durability: " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
                }
            }
        }
    }

    public static boolean ensureInventoryIdentifiers(EntityPlayer player, IInventory inventory, ItemStack stackToOpen, int stackToOpenIn, ArrayList<String> dataNeeded) {
        if (inventory == null) {
            return false;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        String parentGuid = inventory instanceof UniqueItemInventory ? ((UniqueItemInventory)inventory).getIdentifier() : "none";
        ArrayList<Integer> slotsNeeded = new ArrayList<Integer>();
        int slotToOpen = -1;
        String idToOpen = UniqueItem.getIdentifier(stackToOpen);
        if (stackToOpen != null && stackToOpen.func_77973_b() instanceof UniqueItem && !idToOpen.equals("none") && ((UniqueItem)stackToOpen.func_77973_b()).hasUniqueData() && !data.isSubscribed(idToOpen)) {
            dataNeeded.add(idToOpen);
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null && stack.func_77973_b() instanceof UniqueItem) {
                if (!UniqueItem.hasIdentifier(stack) || data.isPermissionDeleted(player, UniqueItem.getIdentifier(stack))) {
                    slotsNeeded.add(i);
                    if (stackToOpen == null || !stackToOpen.equals(stack) || slotToOpen >= 0) continue;
                    slotToOpen = i;
                    continue;
                }
                String uuid = UniqueItem.getIdentifier(stack);
                if (uuid.equals(idToOpen)) {
                    slotToOpen = i;
                }
                if (!((UniqueItem)stack.func_77973_b()).hasUniqueData()) continue;
                if (!data.isSubscribed(uuid)) {
                    dataNeeded.add(uuid);
                }
                if (player.field_70170_p.field_72995_K || data.items.containsKey(uuid)) continue;
                UniqueItem.setIdentifier(player, stack, uuid);
                continue;
            }
            if (stack == null || stackToOpen == null || !stackToOpen.equals(stack) || slotToOpen >= 0) continue;
            slotToOpen = i;
        }
        if (slotsNeeded.size() < 1 && dataNeeded.size() < 1) {
            return true;
        }
        if (stackToOpen == null) {
            slotToOpen = -1;
        }
        if (player.field_70170_p.field_72995_K) {
            channel.sendToServer(new PacketHandler.InventoryIdRequest(parentGuid, slotsNeeded, dataNeeded, slotToOpen, stackToOpenIn));
        }
        return false;
    }

    public static void ensureInventorySubscribed(EntityPlayer player, IInventory inventory) {
        if (inventory == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<String> dataNeeded = new ArrayList<String>();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof UniqueItem) || !UniqueItem.hasIdentifier(stack) || !((UniqueItem)stack.func_77973_b()).hasUniqueData()) continue;
            String uuid = UniqueItem.getIdentifier(stack);
            dataNeeded.add(uuid);
            if (player.field_70170_p.field_72995_K || data.items.containsKey(uuid)) continue;
            UniqueItem.setIdentifier(player, stack, uuid);
        }
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        for (String aDataNeeded : dataNeeded) {
            data.subscribePlayer(player, aDataNeeded, tags, false);
        }
        if (tags.size() < 1) {
            return;
        }
        channel.sendToPlayer(player, new PacketHandler.DataUpdate(tags));
    }

    public static String requestInventoryIdentifier(EntityPlayer player, IInventory inventory, int index) {
        ItemStack stack = inventory.func_70301_a(index);
        if (stack != null && stack.func_77973_b() instanceof UniqueItem) {
            if (!UniqueItem.hasIdentifier(stack) || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, UniqueItem.getIdentifier(stack))) {
                UniqueItem.setIdentifier(player, stack, UUID.randomUUID().toString());
            } else {
                String uuid = UniqueItem.getIdentifier(stack);
                if (((UniqueItem)stack.func_77973_b()).hasUniqueData() && !UniqueItemData.get((World)player.field_70170_p).items.containsKey(uuid)) {
                    UniqueItem.setIdentifier(player, stack, uuid);
                }
            }
            return UniqueItem.getIdentifier(stack);
        }
        return null;
    }

    public static void setInventoryIdentifier(EntityPlayer player, IInventory inventory, int index, String id) {
        ItemStack stack = inventory.func_70301_a(index);
        if (stack != null && stack.func_77973_b() instanceof UniqueItem) {
            UniqueItem.setIdentifier(player, stack, id);
        }
    }

    private static void reportDRDError(String message) {
        FMLLog.severe((String)"%s", (Object[])new Object[]{message});
    }

    public static boolean drdExists(String filename) {
        File file = new File(configDirectory + File.separator + "Dynamic_Recipes" + File.separator + filename);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDynamicRecipes(String filename, boolean perWorld) {
        block43: {
            boolean bl;
            BufferedReader buffer = null;
            Configuration.UnicodeInputStreamReader input = null;
            try {
                File file;
                if (!perWorld) {
                    file = new File(configDirectory + File.separator + "Dynamic_Recipes" + File.separator + filename);
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                } else {
                    File worldSaveDir = DimensionManager.getCurrentSaveRootDirectory();
                    file = new File(worldSaveDir, filename);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                }
                if (!file.exists()) {
                    boolean worldSaveDir = false;
                    return worldSaveDir;
                }
                if (!file.canRead()) break block43;
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                buffer = new BufferedReader((Reader)input);
                String line = null;
                int lineNum = 0;
                do {
                    if ((line = buffer.readLine()) != null) {
                        line = line.trim();
                    }
                    ++lineNum;
                    if (line == null || line.length() <= 0 || line.charAt(0) == '#') continue;
                    try {
                        DynamicRecipes.processRecipe(line, true);
                    }
                    catch (DynamicRecipes.DynamicRecipeException e) {
                        Common.reportDRDError("Error in dynamic recipe definition file \"" + filename + "\", line " + lineNum + ": " + e.getMessage());
                    }
                } while (line != null);
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                bl = true;
            }
            catch (IOException e) {
                Common.reportDRDError("Failed to load Dynamic Recipes from " + filename);
                e.printStackTrace();
                break block43;
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            return bl;
        }
        return false;
    }

    public static void saveDynamicRecipes(String name, DRDFilter filter, boolean perWorld) {
        try {
            File file = null;
            if (!perWorld) {
                file = new File(configDirectory + File.separator + "Dynamic_Recipes" + File.separator + name + ".drd");
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
            } else {
                File worldSaveDir = DimensionManager.getCurrentSaveRootDirectory();
                file = new File(worldSaveDir, name + ".drd");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
            }
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            if (file.canWrite()) {
                DynamicRecipes.Recipe recipe;
                FileOutputStream fos = new FileOutputStream(file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                buffer.write("# Dynamic Recipe Definition file" + Configuration.NEW_LINE);
                buffer.write("# Any line that starts with a hash is a comment and won't be processed by Backpacks!" + Configuration.NEW_LINE);
                buffer.write("# Shapeless recipe definitions use the format: input items > output item" + Configuration.NEW_LINE);
                buffer.write("# Shaped recipe definitions use the format: input items > output item | pattern" + Configuration.NEW_LINE);
                buffer.write("# Smelting recipe definitions use the format: smelt input > output" + Configuration.NEW_LINE);
                buffer.write("# input items must be between 1 and 9 items, separated by + symbols" + Configuration.NEW_LINE);
                buffer.write("# An 'item' consists of an item id, an optional item count and an optional metadata/damage value" + Configuration.NEW_LINE);
                buffer.write("# if the item count is provided it must come before the item id and be followed by an 'x', e.g 4xminecraft:dirt = 4 dirt blocks" + Configuration.NEW_LINE);
                buffer.write("# if the metadata/damage is provided it must come after the item id and be preceded by a ':', e.g minecraft:wool:5 = lime wool" + Configuration.NEW_LINE);
                buffer.write("# The output item can be given custom data by following it with a json representation of an nbt tag" + Configuration.NEW_LINE);
                buffer.write("# When used as an output '3xminecraft:wool:5 {display:{Name:\"Grass\"}' would create 3 lime wool named 'Grass'" + Configuration.NEW_LINE);
                buffer.write("# When used as an input for a shapeless recipe 3xminecraft:wool:5 is equivalent to minecraft:wool:5 + minecraft:wool:5 + minecraft:wool:5" + Configuration.NEW_LINE);
                buffer.write("# When used as an input you may use * as a metadata value to include all possible values, eg minecraft:wool:* = any color of wool" + Configuration.NEW_LINE);
                buffer.write("# The pattern for a shaped recipe must be a sequence of 1, 4 or 9 numbers, each number indicates which item to put where" + Configuration.NEW_LINE);
                buffer.write("# minecraft:wool:5 + minecraft:dirt:0 > 8xminecraft:wool:12 | 111121111 defines a recipe for a dirt block surrounded by lime wool outputting 8 brown wool" + Configuration.NEW_LINE);
                buffer.write("# You can have empty spaces in your pattern by using 0, so the recipe for a torch would be represented as minecraft:stick:0 + minecraft:coal:0 > 4xminecraft:torch:0 | 1020" + Configuration.NEW_LINE);
                buffer.write("# Any recipe can be disabled (including vanilla recipes and most recipes from other mods) by beginning a recipe definition with a ! symbol" + Configuration.NEW_LINE + Configuration.NEW_LINE);
                for (String repr : DynamicRecipes.recipesServerSide) {
                    recipe = DynamicRecipes.evaluateRecipe(repr);
                    if (!filter.includeRecipe(recipe, false)) continue;
                    buffer.write(recipe.getRepresentation() + Configuration.NEW_LINE + Configuration.NEW_LINE);
                }
                for (String repr : DynamicRecipes.disabledRecipesServerSide) {
                    recipe = DynamicRecipes.evaluateRecipe(repr);
                    if (!filter.includeRecipe(recipe, true)) continue;
                    buffer.write("!" + recipe.getRepresentation() + Configuration.NEW_LINE + Configuration.NEW_LINE);
                }
                Iterator<Object> i$ = DynamicRecipes.FurnaceRecipe.serverRecipes.keySet().iterator();
                while (i$.hasNext()) {
                    DynamicRecipes.Recipe recipe2;
                    boolean disabled = DynamicRecipes.FurnaceRecipe.serverRecipes.get(recipe2 = (DynamicRecipes.Recipe)i$.next()) == false;
                    if (!filter.includeRecipe(recipe2, disabled)) continue;
                    buffer.write((disabled ? "!" : "") + recipe2.getRepresentation() + Configuration.NEW_LINE + Configuration.NEW_LINE);
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            Common.reportDRDError("Backpacks!: Failed to save dynamic recipe definitions to " + name + ".drd");
            e.printStackTrace();
        }
    }

    public static void saveOverriddenDRDValues() {
        Common.saveDynamicRecipes("overridden", new DRDFilter(){

            @Override
            public boolean includeRecipe(DynamicRecipes.Recipe recipe, boolean disabled) {
                if (recipe instanceof DynamicRecipes.FurnaceRecipe) {
                    return DynamicRecipes.FurnaceRecipe.overriddenRecipes.contains(recipe);
                }
                if (disabled) {
                    return DynamicRecipes.overriddenRecipes.contains("!" + recipe.getRepresentation());
                }
                return DynamicRecipes.overriddenRecipes.contains(recipe.getRepresentation());
            }
        }, true);
    }

    public static void saveOverriddenCustomItems() {
        try {
            File worldSaveDir = DimensionManager.getCurrentSaveRootDirectory();
            File file = new File(worldSaveDir, "CustomItems.bcmod");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            if (file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                buffer.write("# Custom Item Definition file" + Configuration.NEW_LINE);
                for (String key : UnknownItem._customItems.keySet()) {
                    NBTTagCompound tag = UnknownItem._customItems.get(key);
                    buffer.write(DynamicRecipes.tagToString(tag) + Configuration.NEW_LINE);
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            Common.reportDRDError("Backpacks!: Failed to save custom item definitions");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadOverriddenCustomItems(boolean overridden) {
        block41: {
            BufferedReader buffer = null;
            Configuration.UnicodeInputStreamReader input = null;
            UnknownItem.customItems.clear();
            if (overridden) {
                UnknownItem.customItems.putAll(UnknownItem._existingCustomItems);
                UnknownItem._customItems.clear();
            }
            try {
                File file;
                if (overridden) {
                    File worldSaveDir = DimensionManager.getCurrentSaveRootDirectory();
                    file = new File(worldSaveDir, "CustomItems.bcmod");
                } else {
                    file = new File(configDirectory + File.separator + "CustomItems.bcmod");
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    return;
                }
                if (!file.canRead()) break block41;
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                buffer = new BufferedReader((Reader)input);
                String line = null;
                int lineNum = 0;
                do {
                    if ((line = buffer.readLine()) != null) {
                        line = line.trim();
                    }
                    ++lineNum;
                    if (line == null || line.length() <= 0 || line.charAt(0) == '#') continue;
                    try {
                        NBTBase c = JsonToNBT.func_150315_a((String)line);
                        if (!(c instanceof NBTTagCompound) || !((NBTTagCompound)c).func_74764_b("id")) continue;
                        String id = ((NBTTagCompound)c).func_74779_i("id");
                        if (overridden) {
                            UnknownItem._customItems.put(id, (NBTTagCompound)c);
                        } else {
                            UnknownItem._existingCustomItems.put(id, (NBTTagCompound)c);
                        }
                        UnknownItem.customItems.put(id, (NBTTagCompound)c);
                    }
                    catch (NBTException e) {
                        Common.reportDRDError("Error in custom item definition file \"CustomItems.bcmod\", line " + lineNum + ": " + e.getMessage());
                    }
                } while (line != null);
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                Common.reportDRDError("Failed to load custom item definitions from CustomItems.bcmod" + (overridden ? " for that world" : " in the config folder"));
                e.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static {
        _disableCraftingGui = false;
        _disableChestOpening = false;
        disableCustomItemEditing = false;
        _allEditorsRequireOpPermission = false;
        drdFilenames = new ArrayList();
        channel = new MessageChannel();
        _preventQuantumChestCreation = false;
        _disableBackpackBlocks = false;
        _requirePermissionToDestroyQuantumChest = true;
        disableAutoLoader = false;
        renderBackpacksIn3D = true;
        animatedQuantumBackpacks = true;
        displayPlacedBackpackNames = true;
        _disableNesting = false;
        hideUniqueItemIds = true;
        disableRecipeEditor = false;
        allowOpFunctionsInSinglePlayer = true;
        recipeInstantiators = new ArrayList();
        backpackRendererEnabled = true;
        backpackRendererTickCount = 7;
    }

    public static interface DRDFilter {
        public boolean includeRecipe(DynamicRecipes.Recipe var1, boolean var2);
    }

    public static interface RecipeInstantiator {
        public void instantiateRecipes(ArrayList<String> var1);
    }
}

