/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPos {
    public int x;
    public int y;
    public int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPos other = (BlockPos)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public int getPositionOfSide(int side) {
        if (side < 2) {
            return this.y;
        }
        if (side < 4) {
            return this.z;
        }
        return this.x;
    }

    public void setPositionOfSide(int side, int neighbourPos) {
        if (side < 2) {
            this.y = neighbourPos;
        } else if (side < 4) {
            this.z = neighbourPos;
        } else {
            this.x = neighbourPos;
        }
    }

    public BlockPos getNeighbour(int side) {
        BlockPos neighbour = new BlockPos(this.x, this.y, this.z);
        switch (side) {
            case 0: {
                --neighbour.y;
                break;
            }
            case 1: {
                ++neighbour.y;
                break;
            }
            case 2: {
                --neighbour.z;
                break;
            }
            case 3: {
                ++neighbour.z;
                break;
            }
            case 4: {
                --neighbour.x;
                break;
            }
            case 5: {
                ++neighbour.x;
            }
        }
        return neighbour;
    }

    public boolean blockEquals(World world, Block otherBlock, int otherBlockMetadata, boolean ignoreMetadata) {
        Block block = world.func_147439_a(this.x, this.y, this.z);
        int metadata = world.func_72805_g(this.x, this.y, this.z);
        if (block != null && block.isAir((IBlockAccess)world, this.x, this.y, this.z)) {
            block = Blocks.field_150350_a;
            metadata = 0;
        }
        if (block == null && otherBlock == null) {
            return true;
        }
        if (block != otherBlock) {
            return false;
        }
        return ignoreMetadata || metadata == otherBlockMetadata;
    }

    public ArrayList<BlockPos> getChain(World world, int maximumBlocks, boolean ignoreMetadata) {
        ArrayList<BlockPos> chain = new ArrayList<BlockPos>();
        LinkedList<BlockPos> unvisited = new LinkedList<BlockPos>();
        unvisited.add(this);
        Block block = world.func_147439_a(this.x, this.y, this.z);
        int metadata = world.func_72805_g(this.x, this.y, this.z);
        if (block != null && block.isAir((IBlockAccess)world, this.x, this.y, this.z)) {
            block = Blocks.field_150350_a;
            metadata = 0;
        }
        HashSet<BlockPos> known = new HashSet<BlockPos>();
        while (unvisited.size() > 0) {
            BlockPos current = (BlockPos)unvisited.pop();
            BlockPos neighbour = null;
            for (int side = 0; side < 6; ++side) {
                neighbour = current.getNeighbour(side);
                if (!neighbour.blockEquals(world, block, metadata, ignoreMetadata) || known.contains(neighbour)) continue;
                known.add(neighbour);
                unvisited.add(neighbour);
            }
            chain.add(current);
            if (chain.size() < maximumBlocks) continue;
            return chain;
        }
        return chain;
    }

    public boolean withinArea(int[] area) {
        if (this.y < area[0] || this.y > area[1]) {
            return false;
        }
        if (this.z < area[2] || this.z > area[3]) {
            return false;
        }
        return this.x >= area[4] && this.x <= area[5];
    }

    public static BlockPos readFromNBT(NBTTagCompound tag) {
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
    }
}

