/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.items;

import brad16840.backpacks.gui.ModelBackpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BackpackRenderer
implements IItemRenderer {
    ModelBackpack backpack = new ModelBackpack(null);
    public boolean quantum = false;

    public BackpackRenderer(boolean quantum) {
        this.quantum = quantum;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        if (this.quantum && helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION) {
            Minecraft mc = Minecraft.func_71410_x();
            return mc == null || mc.field_71441_e == null || item == null || mc.field_71441_e.field_73011_w.field_76574_g != QuantumBackpack.getChestDimension(item);
        }
        return helper != IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityItem t;
        BlockPos pos;
        boolean renderQuantumEntity;
        if (item == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = renderQuantumEntity = this.quantum && type == IItemRenderer.ItemRenderType.ENTITY;
        if (renderQuantumEntity) {
            renderQuantumEntity = false;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc != null && mc.field_71441_e != null && item != null && mc.field_71441_e.field_73011_w.field_76574_g == QuantumBackpack.getChestDimension(item)) {
                renderQuantumEntity = true;
            }
        }
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        int rotation = 180;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            rotation = 260;
            GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.5f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            rotation = 90;
            if (renderQuantumEntity) {
                pos = QuantumBackpack.getChestPosition(item);
                t = (EntityItem)data[1];
                rotation = (short)((90.0 + 180.0 * Math.atan((t.field_70161_v - (double)pos.z) / (t.field_70165_t - (double)pos.x)) / Math.PI) % 360.0);
                if (t.field_70165_t - (double)pos.x < 0.0) {
                    rotation = (short)(rotation + 180);
                }
                GL11.glTranslatef((float)0.5f, (float)0.75f, (float)1.0f);
                GL11.glTranslatef((float)-0.15f, (float)-0.2f, (float)0.0f);
            }
            if (!this.quantum || !renderQuantumEntity) {
                GL11.glTranslatef((float)0.5f, (float)1.0f, (float)1.0f);
            }
        } else {
            rotation = 140;
            GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        }
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        if (type != IItemRenderer.ItemRenderType.ENTITY && type != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)-0.1f);
            GL11.glRotatef((float)40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
        }
        if (renderQuantumEntity) {
            pos = QuantumBackpack.getChestPosition(item);
            t = (EntityItem)data[1];
            double g = Math.sqrt(Math.pow(t.field_70165_t - (double)pos.x, 2.0) + Math.pow(t.field_70161_v - (double)pos.z, 2.0));
            rotation = (short)((180.0 - 180.0 * Math.atan(g / (t.field_70163_u - (double)pos.y)) / Math.PI) % 360.0);
            if (t.field_70163_u - (double)pos.y < 0.0) {
                rotation = (short)(rotation + 180);
            }
            GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)-0.425f, (float)-0.655f);
        GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        int color = item.func_77973_b() == Common.quantumBackpack ? (item.func_77960_j() == 0 ? 16 : (item.func_77960_j() - 1) % 16) : item.func_77960_j() % 16;
        this.backpack.render(color, 0.0625f);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

