/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.items.Backpack;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ContainerList;
import brad16840.common.gui.TitledImageButton;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class LoaderEditor
extends StackableContainer
implements BlockSelector.BlockSelectionListener {
    @SideOnly(value=Side.CLIENT)
    public ContainerList collect;
    @SideOnly(value=Side.CLIENT)
    public ContainerList replenish;
    @SideOnly(value=Side.CLIENT)
    public TitledImageButton collectbutton;
    @SideOnly(value=Side.CLIENT)
    public TitledImageButton replenishbutton;
    @SideOnly(value=Side.CLIENT)
    public TitledImageButton collectOnlybutton;
    @SideOnly(value=Side.CLIENT)
    public TitledImageButton replenishOnlybutton;
    @SideOnly(value=Side.CLIENT)
    public TitledImageButton fillExistingButton;
    private String backpackName;
    private ItemStack backpackColor;
    private int collectScrollPos = 0;
    private int replenishScrollPos = 0;
    private String selectedId;
    private int selectedMetadata;
    public boolean needsUpdating = false;
    public boolean fillExisting = false;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/backpack_loader.png");
    public String uuid;
    public NBTTagCompound overallTag;
    public ArrayList<String> collectList;
    public ArrayList<String> replenishList;
    public NBTTagCompound collectTag;
    public NBTTagCompound replenishTag;

    public void save(World world) {
        UniqueItemData.get(world).markItemDirty(this.uuid);
    }

    public LoaderEditor(String uuid, NBTTagCompound tag, String name) {
        super(307, 117);
        this.uuid = uuid;
        this.overallTag = tag;
        this.backpackColor = !tag.func_74764_b("color") ? new ItemStack((Item)Common.backpack, 1, 3) : new ItemStack((Item)Common.backpack, 1, tag.func_74762_e("color"));
        this.backpackName = name;
        this.collectTag = tag.func_74775_l("collect");
        this.replenishTag = tag.func_74775_l("replenish");
        this.collectList = new ArrayList(this.collectTag.func_150296_c());
        this.replenishList = new ArrayList(this.replenishTag.func_150296_c());
        this.collectList.remove("exclude");
        this.replenishList.remove("exclude");
        Collections.sort(this.collectList);
        Collections.sort(this.replenishList);
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.collectbutton = new TitledImageButton(this, "Add", 1, 99, 7, 45, 15, texture, 0, 116);
        this.gui.addButton(this.collectbutton);
        this.replenishbutton = new TitledImageButton(this, "Add", 2, 255, 7, 45, 15, texture, 0, 116);
        this.gui.addButton(this.replenishbutton);
        this.collectOnlybutton = new TitledImageButton(this, "Add", 1, 7, 7, 35, 15, texture, 0, 131);
        this.gui.addButton(this.collectOnlybutton);
        this.replenishOnlybutton = new TitledImageButton(this, "Add", 2, 163, 7, 35, 15, texture, 0, 131);
        this.gui.addButton(this.replenishOnlybutton);
        this.fillExistingButton = new TitledImageButton(this, "", 3, 45, 7, 51, 15, texture, 0, 146);
        this.gui.addButton(this.fillExistingButton);
        this.replenishOnlybutton.tooltip = new ArrayList();
        this.collectOnlybutton.tooltip = new ArrayList();
        this.fillExistingButton.tooltip = new ArrayList();
        this.collectOnlybutton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                LoaderEditor.this.invertList(true);
            }
        };
        this.replenishOnlybutton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                LoaderEditor.this.invertList(false);
            }
        };
        this.fillExistingButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                if (player == null) {
                    return;
                }
                if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission((EntityPlayer)player, LoaderEditor.this.uuid, 2)) {
                    UniqueItemData.permissionError("modify", Backpack.name).log((EntityPlayer)player);
                    return;
                }
                boolean inverse = LoaderEditor.this.overallTag.func_74767_n("fillExisting");
                inverse = !inverse;
                LoaderEditor.this.overallTag.func_74757_a("fillExisting", inverse);
                LoaderEditor.this.updateButtons();
                Common.channel.sendToServer(new PacketHandler.InvertLoaderList(inverse, LoaderEditor.this.uuid, 2));
            }
        };
        this.collectbutton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                LoaderEditor.this.setLoaderItem(false);
            }
        };
        this.replenishbutton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                LoaderEditor.this.setLoaderItem(true);
            }
        };
        this.collect = new ContainerList(this, 7, 24, 136, 84, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                return LoaderEditor.this.collectList.size();
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                if (row >= LoaderEditor.this.collectList.size()) {
                    return;
                }
                NBTTagCompound tag = LoaderEditor.this.collectTag.func_74775_l(LoaderEditor.this.collectList.get(row));
                ItemStack stack = UniqueItem.loadItemStackFromNBT(tag);
                String line = stack.func_77960_j() == Short.MAX_VALUE ? new Translatable("tooltip.blockselector.wildcarditem", new ItemStack(stack.func_77973_b(), 1, 0).func_82833_r()).translate() : stack.func_82833_r();
                LoaderEditor.this.gui.text(this.container, line).truncateString(width).drawCenteredString(x + width / 2, y + 1, -11184811);
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                int color;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                int height = 10;
                NBTTagCompound tag = LoaderEditor.this.collectTag.func_74775_l(LoaderEditor.this.collectList.get(row));
                int n = color = hovered ? -8850318 : -7631989;
                if (tag.func_74779_i("id").equals(LoaderEditor.this.selectedId) && (LoaderEditor.this.selectedMetadata == Short.MAX_VALUE || LoaderEditor.this.selectedMetadata == tag.func_74765_d("Damage"))) {
                    color = -14751714;
                    LoaderEditor.this.gui.drawRectangle(this.container, x, y, x + width, y + height, color);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -8850318);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y - 1, -8850318);
                } else {
                    LoaderEditor.this.gui.drawRectangle(this.container, x, y, x + width, y + height, color);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -6250336);
                }
            }

            @Override
            public int getRowHeight(int slot) {
                return 11;
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (row >= LoaderEditor.this.collectList.size()) {
                    return;
                }
                NBTTagCompound tag = LoaderEditor.this.collectTag.func_74775_l(LoaderEditor.this.collectList.get(row));
                ((BlockSelector)LoaderEditor.this.container.getContainer(0)).setSelectedItem(tag.func_74779_i("id"), tag.func_74765_d("Damage"));
            }
        });
        this.replenish = new ContainerList(this, 163, 24, 136, 84, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                return LoaderEditor.this.replenishList.size();
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                if (row >= LoaderEditor.this.replenishList.size()) {
                    return;
                }
                NBTTagCompound tag = LoaderEditor.this.replenishTag.func_74775_l(LoaderEditor.this.replenishList.get(row));
                ItemStack stack = UniqueItem.loadItemStackFromNBT(tag);
                String line = stack.func_77960_j() == Short.MAX_VALUE ? new Translatable("tooltip.blockselector.wildcarditem", new ItemStack(stack.func_77973_b(), 1, 0).func_82833_r()).translate() : stack.func_82833_r();
                LoaderEditor.this.gui.text(this.container, line).truncateString(width).drawCenteredString(x + width / 2, y + 1, -11184811);
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                int color;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                int height = 10;
                NBTTagCompound tag = LoaderEditor.this.replenishTag.func_74775_l(LoaderEditor.this.replenishList.get(row));
                int n = color = hovered ? -8850318 : -7631989;
                if (tag.func_74779_i("id").equals(LoaderEditor.this.selectedId) && (LoaderEditor.this.selectedMetadata == Short.MAX_VALUE || LoaderEditor.this.selectedMetadata == tag.func_74765_d("Damage"))) {
                    color = -14751714;
                    LoaderEditor.this.gui.drawRectangle(this.container, x, y, x + width, y + height, color);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -8850318);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y - 1, -8850318);
                } else {
                    LoaderEditor.this.gui.drawRectangle(this.container, x, y, x + width, y + height, color);
                    LoaderEditor.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -6250336);
                }
            }

            @Override
            public int getRowHeight(int slot) {
                return 11;
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (row >= LoaderEditor.this.replenishList.size()) {
                    return;
                }
                NBTTagCompound tag = LoaderEditor.this.replenishTag.func_74775_l(LoaderEditor.this.replenishList.get(row));
                ((BlockSelector)LoaderEditor.this.container.getContainer(0)).setSelectedItem(tag.func_74779_i("id"), tag.func_74765_d("Damage"));
            }
        });
        this.collect.scrollPos = this.collectScrollPos;
        this.replenish.scrollPos = this.replenishScrollPos;
        this.collect.addButtons();
        this.replenish.addButtons();
        this.updateButtons();
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == 58) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return true;
            }
            if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission((EntityPlayer)player, this.uuid, 2)) {
                UniqueItemData.permissionError("modify", Backpack.name).log((EntityPlayer)player);
                return true;
            }
            boolean on = this.overallTag.func_150297_b("filtered", 99) && this.overallTag.func_74767_n("filtered");
            this.overallTag.func_74757_a("filtered", !on);
            Common.channel.sendToServer(new PacketHandler.InvertLoaderList(!on, this.uuid, 3));
            return true;
        }
        return false;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            if (this.collect != null) {
                this.collectScrollPos = this.collect.scrollPos;
            }
            if (this.replenish != null) {
                this.replenishScrollPos = this.replenish.scrollPos;
            }
            Keyboard.enableRepeatEvents((boolean)false);
        }
        this.needsUpdating = true;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, new Translatable("button.replenish", new Object[0]).translate()).truncateString(57).drawCenteredString(226, 12, -12566464);
        this.collect.drawForeground(x, y);
        this.replenish.drawForeground(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, 151, 116, 0, 0);
        this.gui.drawTexture(this, 156, 0, 151, 116, 0, 0);
        this.collect.drawBackground(x, y);
        this.replenish.drawBackground(x, y);
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getRowSize() {
        return 0;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        if (x > 153) {
            return this.replenish.mouseWheel(x, y, wheel);
        }
        return this.collect.mouseWheel(x, y, wheel);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateButtons() {
        if (this.replenish == null) {
            return;
        }
        this.collect.updateData();
        this.replenish.updateData();
        boolean exclude = this.overallTag.func_150297_b("collect", 10) && this.overallTag.func_74775_l("collect").func_150297_b("exclude", 99) && this.overallTag.func_74775_l("collect").func_74767_n("exclude");
        this.fillExisting = this.overallTag.func_74767_n("fillExisting");
        this.fillExistingButton.field_146126_j = new Translatable("button.collect" + (exclude ? "" : (this.fillExisting ? "andfill" : "")), new Object[0]).translate();
        this.fillExistingButton.field_146124_l = !exclude;
        this.fillExistingButton.tooltip.clear();
        new Translatable("tooltip.collect." + (exclude ? "dont" : (this.fillExisting ? "fill" : "only")), new Object[0]).addTo(this.fillExistingButton.tooltip);
        this.collectOnlybutton.field_146126_j = new Translatable("button." + (exclude ? "dont" : "only"), new Object[0]).translate();
        this.collectOnlybutton.tooltip.clear();
        new Translatable("tooltip.collect." + (exclude ? "dont" : "only"), new Object[0]).addTo(this.collectOnlybutton.tooltip);
        exclude = this.overallTag.func_150297_b("replenish", 10) && this.overallTag.func_74775_l("replenish").func_150297_b("exclude", 99) && this.overallTag.func_74775_l("replenish").func_74767_n("exclude");
        this.replenishOnlybutton.field_146126_j = new Translatable("button." + (exclude ? "dont" : "only"), new Object[0]).translate();
        this.replenishOnlybutton.tooltip.clear();
        new Translatable("tooltip.replenish." + (exclude ? "dont" : "only"), new Object[0]).addTo(this.replenishOnlybutton.tooltip);
        if (this.selectedId == null) {
            this.replenishbutton.field_146124_l = false;
            this.collectbutton.field_146124_l = false;
            this.collectbutton.field_146126_j = this.replenishbutton.field_146126_j = new Translatable("gui.loadereditor.add", new Object[0]).translate();
        } else {
            this.replenishbutton.field_146124_l = true;
            this.collectbutton.field_146124_l = true;
            String key = this.selectedId.replace(":", "+");
            int i = this.collectList.indexOf(key);
            if (this.selectedMetadata != Short.MAX_VALUE && i < 0) {
                i = this.collectList.indexOf(key + "@" + this.selectedMetadata);
            }
            if (i >= 0) {
                this.collect.scrollToVisible(i);
            }
            this.collectbutton.field_146126_j = new Translatable("gui.loadereditor." + (i < 0 ? "add" : "remove"), new Object[0]).translate();
            i = this.replenishList.indexOf(key);
            if (this.selectedMetadata != Short.MAX_VALUE && i < 0) {
                i = this.replenishList.indexOf(key + "@" + this.selectedMetadata);
            }
            if (i >= 0) {
                this.replenish.scrollToVisible(i);
            }
            this.replenishbutton.field_146126_j = new Translatable("gui.loadereditor." + (i < 0 ? "add" : "remove"), new Object[0]).translate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setLoaderItem(boolean replenish) {
        String key;
        NBTTagCompound tag;
        String t;
        if (this.selectedId == null) {
            return;
        }
        String string = t = !replenish ? "collect" : "replenish";
        if (!this.overallTag.func_74764_b(t)) {
            this.overallTag.func_74782_a(t, (NBTBase)new NBTTagCompound());
        }
        boolean exists = (tag = this.overallTag.func_74775_l(t)).func_74764_b(key = this.selectedId.replace(":", "+")) || this.selectedMetadata != Short.MAX_VALUE && tag.func_74764_b(key + "@" + this.selectedMetadata);
        this.setLoaderItem(!exists, !replenish);
    }

    @SideOnly(value=Side.CLIENT)
    private void setLoaderItem(boolean add, boolean collectDisplayed) {
        String t;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission((EntityPlayer)player, this.uuid, 2)) {
            UniqueItemData.permissionError("modify", Backpack.name).log((EntityPlayer)player);
            return;
        }
        String string = t = collectDisplayed ? "collect" : "replenish";
        if (!this.overallTag.func_74764_b(t)) {
            this.overallTag.func_74782_a(t, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound tag = this.overallTag.func_74775_l(t);
        String key = this.selectedId.replace(":", "+");
        tag.func_82580_o(key);
        if (this.selectedMetadata != Short.MAX_VALUE) {
            key = key + "@" + this.selectedMetadata;
        }
        if (add) {
            tag.func_74782_a(key, (NBTBase)UniqueItem.writeItemStackToNBT(this.selectedId, this.selectedMetadata, 1, null));
        } else {
            tag.func_82580_o(key);
        }
        this.collectTag = this.overallTag.func_74775_l("collect");
        this.replenishTag = this.overallTag.func_74775_l("replenish");
        this.collectList = new ArrayList(this.collectTag.func_150296_c());
        this.replenishList = new ArrayList(this.replenishTag.func_150296_c());
        this.collectList.remove("exclude");
        this.replenishList.remove("exclude");
        Collections.sort(this.collectList);
        Collections.sort(this.replenishList);
        this.updateButtons();
        Common.channel.sendToServer(new PacketHandler.SetLoaderItem(add, this.uuid, collectDisplayed, this.selectedId, this.selectedMetadata));
    }

    @SideOnly(value=Side.CLIENT)
    private void invertList(boolean collectDisplayed) {
        NBTTagCompound tag;
        String t;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission((EntityPlayer)player, this.uuid, 2)) {
            UniqueItemData.permissionError("modify", Backpack.name).log((EntityPlayer)player);
            return;
        }
        String string = t = collectDisplayed ? "collect" : "replenish";
        if (!this.overallTag.func_74764_b(t)) {
            this.overallTag.func_74782_a(t, (NBTBase)new NBTTagCompound());
        }
        boolean inverse = (tag = this.overallTag.func_74775_l(t)).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        inverse = !inverse;
        tag.func_74757_a("exclude", inverse);
        this.updateButtons();
        Common.channel.sendToServer(new PacketHandler.InvertLoaderList(inverse, this.uuid, collectDisplayed ? 1 : 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0) {
            if (this.collect.mouseDown(x, y)) {
                return true;
            }
            if (this.replenish.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        if (this.collect.mouseDragged(x, y)) {
            return true;
        }
        return this.replenish.mouseDragged(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        if (this.collect.mouseUp(x, y)) {
            return true;
        }
        return this.replenish.mouseUp(x, y);
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.collect.updateData();
            this.replenish.updateData();
            this.gui.func_73876_c();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void selectionChanged(String id, int metadata) {
        this.selectedId = id;
        this.selectedMetadata = metadata;
        if (this.isClient()) {
            this.updateButtons();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesContainItemClient(String id, int metadata) {
        UniqueItemInventory inventory;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71441_e != null && (inventory = UniqueItemInventory.getInventory((EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e, this.uuid)) != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!UnknownItem.getItemDescriptor(inventory.func_70301_a(i)).equals(id) || metadata != Short.MAX_VALUE && (inventory.func_70301_a(i) == null || metadata != inventory.func_70301_a(i).func_77960_j())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addCustomTabs(ArrayList<BlockSelector.CustomTab> list) {
        list.add(new BlockSelector.CustomTab(){

            @Override
            public String getName() {
                return LoaderEditor.this.backpackName;
            }

            @Override
            public ItemStack getIcon() {
                return LoaderEditor.this.backpackColor;
            }

            @Override
            public boolean hasItem(String id, int metadata) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    return LoaderEditor.this.doesContainItemClient(id, metadata);
                }
                return false;
            }
        });
    }
}

