/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.blocks;

import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.gui.QuantumContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class QuantumChestTileEntity
extends TileEntity
implements IInventory {
    private ItemStack backpack = null;
    public int backpackType = -1;

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 == 0) {
            return this.backpack;
        }
        return null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 != 0) {
            return null;
        }
        if (this.backpack != null) {
            if (this.backpack.field_77994_a <= par2) {
                ItemStack itemstack = this.backpack;
                this.backpack = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.backpack.func_77979_a(par2);
            if (this.backpack.field_77994_a == 0) {
                this.backpack = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 != 0) {
            return;
        }
        this.backpack = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "quantumChest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145829_t() {
        NBTTagCompound tag;
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(this.field_145850_b);
        String blockId = QuantumChestTileEntity.getChestId(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
        if (!data.blocks.containsKey(blockId)) {
            tag = new NBTTagCompound();
            tag.func_74778_a("blockpos", blockId);
            data.blocks.put(blockId, tag);
            tag.func_74778_a("block-type", Common.quantumChest.getProtectedBlockType());
            if (this.backpack != null) {
                tag.func_74782_a("backpack", (NBTBase)UniqueItem.writeItemStackToNBT(this.backpack, null));
            } else {
                tag.func_82580_o("backpack");
            }
            data.markBlockDirty(blockId);
        }
        this.backpack = (tag = data.getBlockData(blockId, false)).func_74764_b("backpack") ? UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack")) : null;
        this.updateBackpackType();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 || pass == 0;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.func_74764_b("updateClient")) {
            this.backpackType = par1NBTTagCompound.func_74762_e("backpacktype");
            return;
        }
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j != 0) continue;
            this.backpack = UniqueItem.loadItemStackFromNBT(nbttagcompound1);
        }
        this.updateBackpackType();
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 0 && (par2ItemStack.func_77973_b() instanceof Backpack || par2ItemStack.func_77973_b() instanceof QuantumBackpack);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public static String getChestId(BlockPos pos, int dimension) {
        return "@Pos: " + pos.x + ", " + pos.y + ", " + pos.z + "; Dim: " + dimension;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(this.field_145850_b);
        String blockId = QuantumChestTileEntity.getChestId(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
        NBTTagCompound tag = data.getBlockData(blockId, true);
        tag.func_74778_a("block-type", Common.quantumChest.getProtectedBlockType());
        if (this.backpack != null) {
            UniqueItemInventory i = UniqueItemInventory.retrieveInventory(UniqueItem.getIdentifier(this.backpack), !this.field_145850_b.field_72995_K);
            if (i != null) {
                i.saveInventory();
            }
            tag.func_74782_a("backpack", (NBTBase)UniqueItem.writeItemStackToNBT(this.backpack, null));
        } else {
            tag.func_82580_o("backpack");
        }
        data.markBlockDirty(blockId);
        VirtualQuantumChest.updateChest(this.field_145850_b, blockId);
        this.updateBackpackType();
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("updateClient", true);
        tag.func_74768_a("backpacktype", this.backpackType);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 90, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.backpackType = tag.func_74762_e("backpacktype");
    }

    public void updateBackpackType() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.backpackType = this.backpack == null ? -1 : (this.backpack.func_77973_b() == Common.quantumBackpack ? 16 : (this.backpack.func_77973_b() == Common.backpack ? Math.min(this.backpack.func_77960_j(), 15) : -1));
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("updateClient", true);
            tag.func_74768_a("backpacktype", this.backpackType);
            Common.channel.sendToAll(new PacketHandler.UpdateClientTileEntity(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e), tag));
        }
    }

    public static class VirtualQuantumChest {
        private boolean isServer;
        private BlockPos position;
        private int dimension;
        public String backpackId;
        private String chestId;
        private HashMap<String, WeakReference<QuantumContainer>> openContainers = new HashMap();
        public static HashMap<String, WeakReference<VirtualQuantumChest>> openServerChests = new HashMap();
        public static HashMap<String, WeakReference<VirtualQuantumChest>> openClientChests = new HashMap();

        public static VirtualQuantumChest getChest(World world, String chestId) {
            HashMap<String, WeakReference<VirtualQuantumChest>> openChests;
            HashMap<String, WeakReference<VirtualQuantumChest>> hashMap = openChests = world.field_72995_K ? openClientChests : openServerChests;
            if (openChests.containsKey(chestId)) {
                WeakReference<VirtualQuantumChest> ref = openChests.get(chestId);
                if (ref != null && ref.get() != null) {
                    VirtualQuantumChest chest = (VirtualQuantumChest)ref.get();
                    UniqueItemData data = UniqueItemData.get(world);
                    NBTTagCompound tag = data.getBlockData(chestId, false);
                    if (tag != null) {
                        ItemStack stack;
                        chest.backpackId = tag.func_74764_b("backpack") ? ((stack = UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack"))) != null && stack.func_77973_b() instanceof QuantumBackpack ? QuantumBackpack.getInfo(stack) : UniqueItem.getIdentifier(stack)) : null;
                        return chest;
                    }
                }
                openChests.remove(chestId);
            }
            VirtualQuantumChest chest = new VirtualQuantumChest();
            chest.chestId = chestId;
            chest.isServer = !world.field_72995_K;
            try {
                String[] parts = chestId.split("[;:]")[1].split(",");
                chest.position = new BlockPos(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()));
                chest.dimension = Integer.parseInt(chestId.split("[;:]")[3].trim());
            }
            catch (Exception e) {
                return null;
            }
            UniqueItemData data = UniqueItemData.get(world);
            NBTTagCompound tag = data.getBlockData(chestId, false);
            if (tag == null) {
                return null;
            }
            if (tag.func_74764_b("backpack")) {
                ItemStack stack = UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack"));
                if (stack != null && stack.func_77973_b() instanceof QuantumBackpack) {
                    chest.backpackId = QuantumBackpack.getInfo(stack);
                } else {
                    chest.backpackId = UniqueItem.getIdentifier(stack);
                    if (stack == null) {
                        chest.backpackId = null;
                    }
                }
            } else {
                chest.backpackId = null;
            }
            openChests.put(chestId, new WeakReference<VirtualQuantumChest>(chest));
            return chest;
        }

        public boolean canPlayerUse(EntityPlayer player) {
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            return data.hasRequiredPermission(player, this.chestId, 1);
        }

        public boolean canStrictlyUse(World world, String player) {
            UniqueItemData data = UniqueItemData.get(world);
            return data.strictlyHasRequiredPermission(world, player, this.chestId, 1);
        }

        public boolean canPlayerEdit(EntityPlayer player) {
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            return data.isPermissionDeleted(player, this.chestId) || data.hasRequiredPermission(player, this.chestId, 2);
        }

        public static void updateChest(World world, String chestId) {
            HashMap<String, WeakReference<VirtualQuantumChest>> openChests;
            HashMap<String, WeakReference<VirtualQuantumChest>> hashMap = openChests = world.field_72995_K ? openClientChests : openServerChests;
            if (openChests.containsKey(chestId)) {
                WeakReference<VirtualQuantumChest> ref = openChests.get(chestId);
                if (ref == null || ref.get() == null) {
                    return;
                }
                VirtualQuantumChest chest = (VirtualQuantumChest)ref.get();
                UniqueItemData data = UniqueItemData.get(world);
                NBTTagCompound tag = data.getBlockData(chestId, false);
                if (tag == null) {
                    openChests.remove(chestId);
                    return;
                }
                if (tag.func_74764_b("backpack")) {
                    ItemStack stack = UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack"));
                    if (stack != null && stack.func_77973_b() instanceof QuantumBackpack) {
                        chest.backpackId = QuantumBackpack.getInfo(stack);
                    } else {
                        chest.backpackId = UniqueItem.getIdentifier(stack);
                        if (stack == null) {
                            chest.backpackId = null;
                        }
                    }
                } else {
                    chest.backpackId = null;
                }
            }
        }

        public int getUserCount(String id, HashSet<String> visited) {
            UniqueItemInventory inventory;
            if (id == null) {
                id = this.backpackId;
            }
            int count = 0;
            if (id == null || id.equals("none") || visited.contains(id)) {
                return 0;
            }
            visited.add(id);
            WeakReference<QuantumContainer> ref = this.openContainers.get(id);
            if (ref != null && ref.get() != null) {
                ((QuantumContainer)ref.get()).checkPlayers();
                count = ((QuantumContainer)ref.get()).players.size();
            }
            if ((inventory = UniqueItemInventory.retrieveInventory(id, this.isServer)) == null) {
                return count;
            }
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.ContainerItem)) continue;
                count += this.getUserCount(UniqueItem.getIdentifier(stack), visited);
            }
            return count;
        }

        public boolean hasBackpack() {
            return this.backpackId != null && !this.backpackId.equals("none");
        }

        public QuantumContainer openPreparedContainer(EntityPlayer player, String uuid) {
            UniqueItemInventory inventory;
            if (uuid == null) {
                uuid = this.backpackId;
            }
            if (uuid == null || !this.hasBackpack() || uuid.equals("none")) {
                return null;
            }
            if (uuid.startsWith("@Pos:")) {
                HashSet<String> visited = new HashSet<String>();
                visited.add(this.chestId);
                String currentId = uuid;
                VirtualQuantumChest chest = this;
                while (currentId != null && !currentId.equals("none") && !visited.contains(currentId)) {
                    if (!currentId.startsWith("@Pos:")) {
                        return chest.openPreparedContainer(player, currentId);
                    }
                    chest = VirtualQuantumChest.getChest(player.field_70170_p, currentId);
                    if (chest == null || !chest.canPlayerUse(player)) {
                        UniqueItemData.permissionError("use", QuantumChest.name).logOrSend(player);
                        return null;
                    }
                    visited.add(currentId);
                    currentId = chest.backpackId;
                }
                new Translatable("problem.infinitequantumloop", new Object[0]).logOrSend(player);
                return null;
            }
            if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, uuid, 1)) {
                UniqueItemData.permissionError("view", Backpack.name).send(player);
            }
            if (this.openContainers.containsKey(uuid)) {
                WeakReference<QuantumContainer> ref = this.openContainers.get(uuid);
                if (ref != null && ref.get() != null) {
                    ((QuantumContainer)ref.get()).onOpened(player);
                    return (QuantumContainer)ref.get();
                }
                this.openContainers.remove(uuid);
            }
            if ((inventory = UniqueItemInventory.getInventory(player, uuid)) == null) {
                return null;
            }
            ArrayList<String> idChain = new ArrayList<String>();
            idChain.add(uuid);
            if (!uuid.equals(inventory.getIdentifier()) && !UniqueItem.refreshIdChain(player, uuid, Arrays.asList(inventory), idChain)) {
                return null;
            }
            idChain.add(0, "none");
            inventory = UniqueItemInventory.getInventory(player, uuid);
            if (inventory == null) {
                return null;
            }
            QuantumContainer container = new QuantumContainer(inventory.width, inventory.height, this.chestId, inventory, idChain);
            this.openContainers.put(uuid, new WeakReference<QuantumContainer>(container));
            container.onOpened(player);
            return container;
        }

        public String getBackpackId(World world, String player) {
            if (this.backpackId == null || this.backpackId.equals("none")) {
                return null;
            }
            if (this.backpackId.startsWith("@Pos:")) {
                HashSet<String> visited = new HashSet<String>();
                visited.add(this.chestId);
                String currentId = this.backpackId;
                while (currentId != null && !currentId.equals("none") && !visited.contains(currentId)) {
                    if (!currentId.startsWith("@Pos:")) {
                        return currentId;
                    }
                    VirtualQuantumChest chest = VirtualQuantumChest.getChest(world, currentId);
                    if (chest == null || !chest.canStrictlyUse(world, player)) {
                        return null;
                    }
                    visited.add(currentId);
                    currentId = chest.backpackId;
                }
                return null;
            }
            return this.backpackId;
        }

        public String getBackpackId(EntityPlayer player) {
            if (this.backpackId == null || this.backpackId.equals("none")) {
                QuantumBackpack.error_chestEmpty.log(player);
                return null;
            }
            if (this.backpackId.startsWith("@Pos:")) {
                HashSet<String> visited = new HashSet<String>();
                visited.add(this.chestId);
                String currentId = this.backpackId;
                while (currentId != null && !currentId.equals("none") && !visited.contains(currentId)) {
                    if (!currentId.startsWith("@Pos:")) {
                        return currentId;
                    }
                    VirtualQuantumChest chest = VirtualQuantumChest.getChest(player.field_70170_p, currentId);
                    if (chest == null || !chest.canPlayerUse(player)) {
                        UniqueItemData.permissionError("use", QuantumChest.name).log(player);
                        return null;
                    }
                    visited.add(currentId);
                    currentId = chest.backpackId;
                }
                new Translatable("problem.infinitequantumloop", new Object[0]).log(player);
                return null;
            }
            return this.backpackId;
        }
    }
}

