/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryScanner {
    public static String getUUID(EntityPlayer player, ItemStack stack) {
        QuantumChestTileEntity.VirtualQuantumChest chest;
        if (stack.func_77973_b() instanceof QuantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(stack))) != null && chest.canStrictlyUse(player.field_70170_p, player.func_70005_c_())) {
            return chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
        }
        return UniqueItem.getIdentifier(stack);
    }

    public static boolean backpackCanAccept(NBTTagCompound tag, ItemStack item) {
        boolean inverse;
        if (tag == null) {
            return false;
        }
        if (item == null) {
            return true;
        }
        if (!tag.func_150297_b("filtered", 99) || !tag.func_74767_n("filtered")) {
            return true;
        }
        if (!tag.func_150297_b("collect", 10)) {
            return false;
        }
        tag = tag.func_74775_l("collect");
        String id = UniqueItem.getDescriptor(item.func_77973_b()).replace(":", "+");
        boolean bl = inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        if (tag.func_74764_b(id) || tag.func_74764_b(id + "@" + item.func_77960_j())) {
            return !inverse;
        }
        return inverse;
    }

    public static int scanInventory(EntityPlayer player, UniqueItemData data, IInventory inventory, ItemStack accepts, int pos, boolean adding, HashSet<String> visited) {
        String key = adding ? "collect" : "replenish";
        for (int i = pos; i < inventory.func_70302_i_(); ++i) {
            NBTTagCompound tag;
            ItemStack stack = inventory.func_70301_a(i);
            String uuid = null;
            if (stack == null || !(stack.func_77973_b() instanceof Backpack) && !(stack.func_77973_b() instanceof QuantumBackpack) || (uuid = InventoryScanner.getUUID(player, stack)) == null || uuid.equals("none") || !data.strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), uuid, 2) || visited.contains(uuid)) continue;
            visited.add(uuid);
            UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
            if (inv != null) {
                InventoryScanner.scanInventory(data, player, inv, accepts, adding, visited);
            }
            if ((tag = data.getItemData(uuid, false)) == null || !tag.func_150297_b(key, 10) || !InventoryScanner.backpackAccepts(tag = tag.func_74775_l(key), accepts)) continue;
            if (!adding) {
                if (inv == null || !InventoryScanner.canReplenishItem(player, inv, UniqueItem.getDescriptor(accepts.func_77973_b()), accepts.func_77960_j()) && (!tag.func_74764_b(UniqueItem.getDescriptor(accepts.func_77973_b()).replace(":", "+")) || !InventoryScanner.canReplenishItem(player, inv, UniqueItem.getDescriptor(accepts.func_77973_b()), Short.MAX_VALUE))) continue;
                inv.saveInventory();
            }
            return i;
        }
        return -1;
    }

    public static void loadFromInventory(EntityPlayer player, IInventory inventory) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack;
            if (inventory instanceof InventoryPlayer) {
                InventoryPlayer cfr_ignored_0 = (InventoryPlayer)inventory;
                if (i < InventoryPlayer.func_70451_h()) continue;
            }
            if ((stack = inventory.func_70301_a(i)) == null || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) continue;
            InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, true, new HashSet<String>());
            if (stack.field_77994_a != 0) continue;
            inventory.func_70299_a(i, null);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        ItemStack stack = event.item.func_92059_d();
        EntityPlayer player = event.entityPlayer;
        if (event.item.field_145804_b > 0 || stack.field_77994_a < 1) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, true, new HashSet<String>());
        if (stack.field_77994_a == 0) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(PlayerDestroyItemEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        ItemStack stack = event.original;
        EntityPlayer player = event.entityPlayer;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (player.func_71045_bC() != null && player.func_71045_bC().field_77994_a == 0) {
            player.func_70062_b(0, null);
        }
        try {
            player.field_71069_bz.func_75142_b();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (player.func_71045_bC() != null) {
            return;
        }
        InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, false, new HashSet<String>());
    }

    public static void scanInventory(UniqueItemData data, EntityPlayer player, IInventory inventory, ItemStack stack, boolean adding, HashSet<String> visited) {
        int i = 0;
        while (i != -1 && (adding && stack.field_77994_a > 0 || !adding && player.func_71045_bC() == null)) {
            if ((i = InventoryScanner.scanInventory(player, data, inventory, stack, i, adding, visited)) == -1) continue;
            String uuid = InventoryScanner.getUUID(player, inventory.func_70301_a(i));
            UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
            if (adding && inv != null && InventoryScanner.addItemStackToInventory(inv, stack, true)) {
                inv.saveInventory();
            }
            ++i;
        }
        if (adding && stack.field_77994_a > 0 && inventory instanceof UniqueItemInventory) {
            String desc;
            NBTTagCompound tag = data.getItemData(((UniqueItemInventory)inventory).getIdentifier(), false);
            if (tag == null || !tag.func_74767_n("fillExisting")) {
                return;
            }
            if (!(tag = tag.func_74775_l("collect")).func_74764_b(desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+")) && !tag.func_74764_b(desc + "@" + stack.func_77960_j()) && InventoryScanner.addItemStackToInventory((UniqueItemInventory)inventory, stack, false)) {
                ((UniqueItemInventory)inventory).saveInventory();
            }
        }
    }

    public static boolean addItemStackToInventory(UniqueItemInventory inventory, ItemStack par1ItemStack, boolean fillEmptySlots) {
        if (par1ItemStack != null && par1ItemStack.field_77994_a != 0 && par1ItemStack.func_77973_b() != null) {
            int i;
            if (par1ItemStack.func_77951_h()) {
                int i2 = InventoryScanner.getFirstEmptyStack(inventory);
                if (i2 >= 0 && fillEmptySlots) {
                    inventory.func_70299_a(i2, ItemStack.func_77944_b((ItemStack)par1ItemStack));
                    par1ItemStack.field_77994_a = 0;
                    return true;
                }
                return false;
            }
            do {
                i = par1ItemStack.field_77994_a;
                par1ItemStack.field_77994_a = InventoryScanner.storePartialItemStack(inventory, par1ItemStack, fillEmptySlots);
            } while (par1ItemStack.field_77994_a > 0 && par1ItemStack.field_77994_a < i);
            return par1ItemStack.field_77994_a < i;
        }
        return false;
    }

    public static boolean canReplenishItem(EntityPlayer player, UniqueItemInventory inventory, String id, int metadata) {
        if (player.func_71045_bC() != null) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !UniqueItem.getDescriptor(stack.func_77973_b()).equals(id) || metadata != Short.MAX_VALUE && metadata != stack.func_77960_j()) continue;
            player.func_70062_b(0, stack);
            inventory.func_70299_a(i, null);
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean backpackAccepts(NBTTagCompound tag, ItemStack stack) {
        if (tag == null || stack == null) {
            return false;
        }
        boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        if (tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + stack.func_77960_j())) {
            return !inverse;
        }
        return inverse;
    }

    public static int getFirstEmptyStack(UniqueItemInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static int storePartialItemStack(UniqueItemInventory inventory, ItemStack par1ItemStack, boolean fillEmptySlots) {
        Item item = par1ItemStack.func_77973_b();
        int i = par1ItemStack.field_77994_a;
        if (par1ItemStack.func_77976_d() == 1) {
            int j = InventoryScanner.getFirstEmptyStack(inventory);
            if (j < 0 || !fillEmptySlots) {
                return i;
            }
            if (inventory.func_70301_a(j) == null) {
                inventory.func_70299_a(j, ItemStack.func_77944_b((ItemStack)par1ItemStack));
            }
            return 0;
        }
        int j = -1;
        for (int t = 0; t < inventory.func_70302_i_(); ++t) {
            ItemStack is = inventory.func_70301_a(t);
            if (is == null || is.func_77973_b() != par1ItemStack.func_77973_b() || !is.func_77985_e() || is.field_77994_a >= is.func_77976_d() || is.field_77994_a >= inventory.func_70297_j_() || is.func_77981_g() && is.func_77960_j() != par1ItemStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)par1ItemStack)) continue;
            j = t;
            break;
        }
        if (j < 0 && fillEmptySlots) {
            j = InventoryScanner.getFirstEmptyStack(inventory);
        }
        if (j < 0) {
            return i;
        }
        if (inventory.func_70301_a(j) == null) {
            ItemStack stack = new ItemStack(item, 0, par1ItemStack.func_77960_j());
            if (par1ItemStack.func_77942_o()) {
                stack.func_77982_d((NBTTagCompound)par1ItemStack.func_77978_p().func_74737_b());
            }
            inventory.func_70299_a(j, stack);
        }
        ItemStack stack = inventory.func_70301_a(j);
        int k = i;
        int stackSize = stack.field_77994_a;
        if (k > stack.func_77976_d() - stackSize) {
            k = stack.func_77976_d() - stackSize;
        }
        if (k > inventory.func_70297_j_() - stackSize) {
            k = inventory.func_70297_j_() - stackSize;
        }
        if (k == 0) {
            return i;
        }
        stack.field_77994_a += k;
        return i -= k;
    }
}

