/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.Proxy;
import brad16840.backpacks.blocks.BackpackBlock;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.LoaderEditor;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.BackpackRestorer;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.DynamicRecipes;
import brad16840.common.EntityBlock164;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ChestContainer;
import brad16840.common.gui.PlayerContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="backpacks16840", name="Backpacks!", version="2.7.0", dependencies="required-after:bcmod")
public class Backpacks
implements Common.RecipeInstantiator {
    public static final String modId = "backpacks16840";
    @Mod.Instance(value="backpacks16840")
    public static Backpacks instance;
    public static String fileVersion;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding loaderKeyBinding;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler openFirstKeyBinding;
    @SidedProxy(clientSide="brad16840.backpacks.ClientProxy", serverSide="brad16840.backpacks.Proxy")
    public static Proxy proxy;
    public static final MessageChannel channel;
    public static Backpack backpack;
    public static BackpackBlock backpackBlock;
    public static QuantumBackpack quantumBackpack;
    public static Backpack.BackpackResizer backpackResizer;
    public static BackpackRestorer backpackRestorer;
    public static BackpackPouchUpgrade backpackUpgrade;
    public static QuantumChest quantumChest;
    public static boolean _preventQuantumChestCreation;
    public static boolean preventQuantumChestCreation;
    public static boolean _disableBackpackBlocks;
    public static boolean disableBackpackBlocks;
    public static boolean _requirePermissionToDestroyQuantumChest;
    public static boolean requirePermissionToDestroyQuantumChest;
    public static boolean disableAutoLoader;
    public static boolean renderBackpacksIn3D;
    public static boolean animatedQuantumBackpacks;
    public static boolean displayPlacedBackpackNames;
    public static boolean _disableNesting;
    public static boolean disableNesting;

    private void updateIntList(Property p, int[] list) {
        String[] values = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            values[i] = Integer.toString(list[i]);
        }
        p.set(values);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Common.ensureCompatibleWith("Backpacks!", "1.7.10 - 2.6");
        Common.recipeInstantiators.add(this);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        String configVersion = config.get("general", "internal_config_version", "pre", "Used to update existing config values when a mod update requires a change").getString();
        if (configVersion.equals("pre")) {
            this.updateIntList(config.get("general", "backpack_widths", Backpack._widths, "How many columns of storage a backpack with X pouches will have"), Backpack._widths);
            this.updateIntList(config.get("general", "backpack_heights", Backpack._heights, "How many rows of storage a backpack with X pouches will have"), Backpack._heights);
            config.get("general", "animate_quantum_backpacks", animatedQuantumBackpacks, "If this is true the 3d model for quantum backpacks will use its animated texture").set(animatedQuantumBackpacks);
        }
        config.get("general", "internal_config_version", "pre", "Used to update existing config values when a mod update requires a change").set("2.7");
        Backpack._widths = config.get("general", "backpack_widths", Backpack._widths, "How many columns of storage a backpack with X pouches will have").getIntList();
        Backpack._heights = config.get("general", "backpack_heights", Backpack._heights, "How many rows of storage a backpack with X pouches will have").getIntList();
        if (Backpack._widths.length < 1) {
            Backpack._widths = new int[]{3};
        }
        if (Backpack._heights.length < 1) {
            Backpack._heights = new int[]{3};
        }
        if (Backpack._widths.length != Backpack._heights.length) {
            int[] w = Backpack._widths;
            int[] h = Backpack._heights;
            int min = w.length < h.length ? w.length : h.length;
            Backpack._widths = new int[min];
            Backpack._heights = new int[min];
            for (int i = 0; i < min; ++i) {
                Backpack._widths[i] = w[i];
                Backpack._heights[i] = h[i];
            }
            FMLLog.warning((String)"The list of backpack widths was a different size to the list of backpack heights, so unpaired values are being ignored", (Object[])new Object[0]);
        }
        Backpack.widths = Backpack._widths;
        Backpack.heights = Backpack._heights;
        Backpack.forceDefaults = Backpack._forceDefaults = config.get("general", "restrict_backpack_size_to_presets", Backpack._forceDefaults, "If this is true the size of every backpack will be forced to be one of the sizes defined by backpack_widths and backpack_heights, otherwise backpack resizers can be used to freely change the size of individual backpacks").getBoolean(Backpack._forceDefaults);
        BackpackBlock.canDuplicate = BackpackBlock._canDuplicate = config.get("general", "ender_eyes_can_duplicate_backpacks", BackpackBlock._canDuplicate, "If this is true you can 'use' an ender eye on a placed backpack to duplicate it. Any change made to a duplicated backpack will be present in all duplicates (like an ender chest)").getBoolean(BackpackBlock._canDuplicate);
        preventQuantumChestCreation = _preventQuantumChestCreation = config.get("general", "prevent_quantum_chest_placement", _preventQuantumChestCreation, "Setting this to true will prevent new quantum chests being placed in the world, existing chests won't be affected").getBoolean(_preventQuantumChestCreation);
        animatedQuantumBackpacks = config.get("general", "animate_quantum_backpacks", animatedQuantumBackpacks, "If this is true the 3d model for quantum backpacks will use its animated texture").getBoolean(animatedQuantumBackpacks);
        displayPlacedBackpackNames = config.get("general", "show_names_of_placed_backpacks", displayPlacedBackpackNames, "If this is true you will be able to see the name of a placed backpack by looking at it").getBoolean(displayPlacedBackpackNames);
        disableNesting = _disableNesting = config.get("general", "disable_backpack_nesting", _disableNesting, "If this is true you won't be able to put backpacks inside other backpacks :(").getBoolean(_disableNesting);
        renderBackpacksIn3D = config.get("general", "render_backpacks_in_3d", renderBackpacksIn3D, "If this is true backpacks will be rendered in 3d when dropped or in your hand").getBoolean(renderBackpacksIn3D);
        requirePermissionToDestroyQuantumChest = _requirePermissionToDestroyQuantumChest = config.get("general", "require_permission_to_destroy_quantum_chests", _requirePermissionToDestroyQuantumChest, "If this is true, only players with permission to edit a quantum chest will be able to destroy it").getBoolean(_requirePermissionToDestroyQuantumChest);
        disableBackpackBlocks = _disableBackpackBlocks = config.get("general", "disable_backpack_blocks", _disableBackpackBlocks, "If this is true backpacks will not be placeable").getBoolean(_disableBackpackBlocks);
        disableAutoLoader = config.get("general", "disable_backpack_auto_loader", disableAutoLoader, "This will disable the automatic loading and unloading of designated items from backpacks (it won't affect the piping of items to/from placed backpacks)").getBoolean(disableAutoLoader);
        config.save();
        backpack = new Backpack("backpack");
        GameRegistry.registerItem((Item)backpack, (String)Backpacks.backpack.field_77774_bZ);
        quantumBackpack = new QuantumBackpack("quantum_backpack");
        GameRegistry.registerItem((Item)quantumBackpack, (String)Backpacks.quantumBackpack.field_77774_bZ);
        backpackResizer = new Backpack.BackpackResizer("backpack_resizer");
        GameRegistry.registerItem((Item)backpackResizer, (String)Backpacks.backpackResizer.field_77774_bZ);
        backpackRestorer = new BackpackRestorer("backpack_restorer");
        GameRegistry.registerItem((Item)backpackRestorer, (String)Backpacks.backpackRestorer.field_77774_bZ);
        backpackUpgrade = new BackpackPouchUpgrade("backpack_pouch");
        GameRegistry.registerItem((Item)backpackUpgrade, (String)Backpacks.backpackUpgrade.field_77774_bZ);
        backpackBlock = new BackpackBlock("backpack_block");
        GameRegistry.registerBlock((Block)backpackBlock, (String)Backpacks.backpackBlock.field_149770_b);
        GameRegistry.registerBlock((Block)new EntityBlock164((Block)backpackBlock), (String)(Backpacks.backpackBlock.field_149770_b + "164"));
        quantumChest = new QuantumChest("quantum_chest");
        GameRegistry.registerBlock((Block)quantumChest, (String)Backpacks.quantumChest.field_149770_b);
        GameRegistry.registerBlock((Block)new EntityBlock164((Block)quantumChest), (String)(Backpacks.quantumChest.field_149770_b + "164"));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init(this);
        UniqueItem.registerContainerItem(backpack);
        UniqueItem.registerProtectedBlockType(quantumChest);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        channel.initialize(modId);
        PacketHandler.registerMessages(channel);
        GameRegistry.registerTileEntity(BackpackBlockTileEntity.class, (String)Backpacks.backpackBlock.field_149770_b);
        GameRegistry.registerTileEntity(QuantumChestTileEntity.class, (String)"quantumChest");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Logger.register();
        FMLCommonHandler.instance().bus().register((Object)this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ContainerStackGui.customMouseClickHandlers.add(new ContainerStackGui.CustomMouseClickHandler(){

                @Override
                public boolean handle(EntityPlayer player, ItemStack stack, boolean holdingShift) {
                    if ((stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) && !holdingShift) {
                        Backpack.openingStandalone = true;
                        ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
                        return true;
                    }
                    return false;
                }
            });
        }
        MinecraftForge.EVENT_BUS.register((Object)new InventoryScanner());
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loader");
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loadbackpack");
        PacketHandler.OpenEditorWindow.editors.add(new PacketHandler.OpenEditorWindow.CustomEditor(){

            public boolean load(ContainerStack container, int stackId, EntityPlayer player) {
                StackableContainer stack;
                if (container.stacks.length > stackId && (stack = container.getContainer(stackId)) instanceof ContainerStack.LoadableContainer) {
                    String uuid = stack.getId();
                    NBTTagCompound tag = UniqueItemData.get(player.field_70170_p).getItemData(uuid, false);
                    if (tag == null) {
                        return false;
                    }
                    container.addContainers(player, new StackableContainer[]{new BlockSelector(), new LoaderEditor(uuid, tag, ((ContainerStack.LoadableContainer)((Object)stack)).getName())});
                    return true;
                }
                return false;
            }

            @Override
            public boolean loadEditor(String type, int stackId, ContainerStack container, EntityPlayer player) {
                block7: {
                    block10: {
                        block8: {
                            block9: {
                                if (!type.equals("loadbackpack")) break block7;
                                if (disableAutoLoader) {
                                    new Translatable("problem.autoloaddisabled", new Object[0]).send(player);
                                    return true;
                                }
                                if (container != null) break block8;
                                if (!(player.field_71070_bA instanceof ContainerChest)) break block9;
                                InventoryScanner.loadFromInventory(player, ((ContainerChest)player.field_71070_bA).func_85151_d());
                                player.field_71070_bA.func_75142_b();
                                break block10;
                            }
                            if (!(player.field_71070_bA instanceof ContainerPlayer)) break block10;
                            InventoryScanner.loadFromInventory(player, (IInventory)player.field_71071_by);
                            player.field_71070_bA.func_75142_b();
                            break block10;
                        }
                        for (int i = 0; i < container.stacks.length; ++i) {
                            StackableContainer c = container.getContainer(i);
                            if (c instanceof ChestContainer) {
                                InventoryScanner.loadFromInventory(player, ((ChestContainer)c).inventory);
                                container.func_75142_b();
                                continue;
                            }
                            if (!(c instanceof PlayerContainer)) continue;
                            InventoryScanner.loadFromInventory(player, (IInventory)((PlayerContainer)c).inventory);
                            container.func_75142_b();
                        }
                    }
                    return true;
                }
                if (type.equals("loader") && container.stacks.length > stackId) {
                    int i;
                    if (this.load(container, stackId, player)) {
                        return true;
                    }
                    for (i = stackId; i < container.stacks.length; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                    for (i = 0; i < stackId; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        channel.sendToPlayer(event.player, new PacketHandler.InitializePlayer());
    }

    @Override
    public void instantiateRecipes(ArrayList<String> files) {
        Iterator<String> iterator = files.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (!name.toLowerCase().startsWith("backpacks")) continue;
            iterator.remove();
        }
        final ArrayList<String> recipes = new ArrayList<String>();
        if (!Common.loadDynamicRecipes("backpacks " + fileVersion + ".drd", false)) {
            try {
                ItemStack craftedBackpack = new ItemStack((Item)backpack, 1, 3);
                DynamicRecipes.buildRecipe(recipes, (Object)craftedBackpack, "111101121", Items.field_151116_aA, Blocks.field_150445_bS);
                DynamicRecipes.buildRecipe(recipes, (Object)backpackUpgrade, "112102112", Items.field_151116_aA, Items.field_151007_F);
                DynamicRecipes.buildRecipe(recipes, (Object)backpackRestorer, "111121131", Items.field_151043_k, Items.field_151061_bv, Blocks.field_150445_bS);
                DynamicRecipes.buildRecipe(recipes, (Object)quantumChest, "121232121", Items.field_151045_i, Items.field_151061_bv, Blocks.field_150343_Z);
            }
            catch (DynamicRecipes.DynamicRecipeException e) {
                throw new RuntimeException("Backpacks' default recipes couldn't be processed! " + e.getMessage(), e);
            }
            if (!Common.drdExists("backpacks " + fileVersion + ".drd")) {
                FMLLog.warning((String)("Backpacks: 'backpacks " + fileVersion + ".drd' did not exist, so has been created using the default recipe definitions"), (Object[])new Object[0]);
                Common.saveDynamicRecipes("backpacks " + fileVersion, new Common.DRDFilter(){

                    @Override
                    public boolean includeRecipe(DynamicRecipes.Recipe recipe, boolean disabled) {
                        return !disabled && recipes.contains(recipe.getRepresentation());
                    }
                }, false);
            } else {
                FMLLog.warning((String)("Backpacks: Couldn't load 'backpacks " + fileVersion + ".drd', so using default recipes definitions"), (Object[])new Object[0]);
            }
        }
    }

    static {
        fileVersion = "1.7.2 - 2.6";
        channel = new MessageChannel();
        _preventQuantumChestCreation = false;
        _disableBackpackBlocks = false;
        _requirePermissionToDestroyQuantumChest = true;
        disableAutoLoader = false;
        renderBackpacksIn3D = true;
        animatedQuantumBackpacks = true;
        displayPlacedBackpackNames = true;
        _disableNesting = false;
    }
}

