/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaBlock;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.cbcore.Layout;
import mcp.mobius.waila.network.Message0x01TERequest;
import mcp.mobius.waila.network.Message0x03EntRequest;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class MetaDataProvider {
    private ArrayList<IWailaDataProvider> headBlockProviders = new ArrayList();
    private ArrayList<IWailaDataProvider> bodyBlockProviders = new ArrayList();
    private ArrayList<IWailaDataProvider> tailBlockProviders = new ArrayList();
    private ArrayList<IWailaEntityProvider> headEntityProviders = new ArrayList();
    private ArrayList<IWailaEntityProvider> bodyEntityProviders = new ArrayList();
    private ArrayList<IWailaEntityProvider> tailEntityProviders = new ArrayList();
    private Class prevBlock = null;
    private Class prevTile = null;

    public ItemStack identifyBlockHighlight(World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor) {
        Block block = accessor.getBlock();
        int blockID = accessor.getBlockID();
        if (IWailaBlock.class.isInstance(block)) {
            try {
                return ((IWailaBlock)block).getWailaStack(accessor, ConfigHandler.instance());
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, block.getClass().toString(), null);
            }
        }
        if (ModuleRegistrar.instance().hasStackProviders(block)) {
            for (IWailaDataProvider dataProvider : ModuleRegistrar.instance().getStackProviders(block)) {
                try {
                    ItemStack retval = dataProvider.getWailaStack(accessor, ConfigHandler.instance());
                    if (retval == null) continue;
                    return retval;
                }
                catch (Throwable e) {
                    WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), null);
                }
            }
        }
        return null;
    }

    public List<String> handleBlockTextData(ItemStack itemStack, World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        Block block = accessor.getBlock();
        if (accessor.getTileEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(block)) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(block));
            }
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getTileEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getTileEntity()));
            }
            if (keys.size() != 0 || ModuleRegistrar.instance().hasNBTProviders(block) || ModuleRegistrar.instance().hasNBTProviders(accessor.getTileEntity())) {
                WailaPacketHandler.INSTANCE.sendToServer(new Message0x01TERequest(accessor.getTileEntity(), keys));
            }
        } else if (accessor.getTileEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getTileEntity().func_145841_b(tag);
                accessor.setNBTData(tag);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
            }
        }
        if (IWailaBlock.class.isInstance(block)) {
            TileEntity entity = world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (layout == Layout.HEADER) {
                try {
                    return ((IWailaBlock)block).getWailaHead(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.BODY) {
                try {
                    return ((IWailaBlock)block).getWailaBody(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.FOOTER) {
                try {
                    return ((IWailaBlock)block).getWailaTail(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
        }
        this.headBlockProviders.clear();
        this.bodyBlockProviders.clear();
        this.tailBlockProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(block)) {
            this.headBlockProviders.addAll(ModuleRegistrar.instance().getHeadProviders(block));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(block)) {
            this.bodyBlockProviders.addAll(ModuleRegistrar.instance().getBodyProviders(block));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(block)) {
            this.tailBlockProviders.addAll(ModuleRegistrar.instance().getTailProviders(block));
        }
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(accessor.getTileEntity())) {
            this.headBlockProviders.addAll(ModuleRegistrar.instance().getHeadProviders(accessor.getTileEntity()));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(accessor.getTileEntity())) {
            this.bodyBlockProviders.addAll(ModuleRegistrar.instance().getBodyProviders(accessor.getTileEntity()));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(accessor.getTileEntity())) {
            this.tailBlockProviders.addAll(ModuleRegistrar.instance().getTailProviders(accessor.getTileEntity()));
        }
        if (layout == Layout.HEADER) {
            for (IWailaDataProvider dataProvider : this.headBlockProviders) {
                try {
                    currenttip = dataProvider.getWailaHead(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        if (layout == Layout.BODY) {
            for (IWailaDataProvider dataProvider : this.bodyBlockProviders) {
                try {
                    currenttip = dataProvider.getWailaBody(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (IWailaDataProvider dataProvider : this.tailBlockProviders) {
                try {
                    currenttip = dataProvider.getWailaTail(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        return currenttip;
    }

    public List<String> handleEntityTextData(Entity entity, World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        if (accessor.getEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getEntity()));
            }
            if (keys.size() != 0 || ModuleRegistrar.instance().hasNBTEntityProviders(accessor.getEntity())) {
                WailaPacketHandler.INSTANCE.sendToServer(new Message0x03EntRequest(accessor.getEntity(), keys));
            }
        } else if (accessor.getEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getEntity().func_70109_d(tag);
                accessor.remoteNbt = tag;
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
            }
        }
        this.headEntityProviders.clear();
        this.bodyEntityProviders.clear();
        this.tailEntityProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadEntityProviders(entity)) {
            this.headEntityProviders.addAll(ModuleRegistrar.instance().getHeadEntityProviders(entity));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyEntityProviders(entity)) {
            this.bodyEntityProviders.addAll(ModuleRegistrar.instance().getBodyEntityProviders(entity));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailEntityProviders(entity)) {
            this.tailEntityProviders.addAll(ModuleRegistrar.instance().getTailEntityProviders(entity));
        }
        if (layout == Layout.HEADER) {
            for (IWailaEntityProvider dataProvider : this.headEntityProviders) {
                try {
                    currenttip = dataProvider.getWailaHead(entity, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        if (layout == Layout.BODY) {
            for (IWailaEntityProvider dataProvider : this.bodyEntityProviders) {
                try {
                    currenttip = dataProvider.getWailaBody(entity, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (IWailaEntityProvider dataProvider : this.tailEntityProviders) {
                try {
                    currenttip = dataProvider.getWailaTail(entity, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable e) {
                    currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                }
            }
        }
        return currenttip;
    }
}

