/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.TabTracker;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.Rectangle4i;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class TabBase
extends ElementBase {
    public static int tabExpandSpeed = 8;
    public static int LEFT = 0;
    public static int RIGHT = 1;
    public boolean open;
    public boolean fullyOpen;
    public int side = RIGHT;
    public int headerColor = 14797103;
    public int subheaderColor = 11186104;
    public int textColor = 0;
    public int backgroundColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh:textures/gui/elements/Tab_Left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh:textures/gui/elements/Tab_Right.png");

    public TabBase(GuiBase guiBase) {
        super(guiBase, 0, 0);
        this.texture = DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase(GuiBase guiBase, int n) {
        super(guiBase, 0, 0);
        this.side = n;
        this.texture = n == LEFT ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    public void draw(int n, int n2) {
        this.posX = n;
        this.posY = n2;
        this.draw();
    }

    public void draw() {
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
    }

    @Override
    public void drawForeground(int n, int n2) {
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (!this.fullyOpen && this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    protected void drawBackground() {
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        int n = this.posX();
        this.gui.func_73729_b(n, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
        this.gui.func_73729_b(n + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.gui.func_73729_b(n, this.posY, 0, 0, 4, 4);
        this.gui.func_73729_b(n + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawTabIcon(String string) {
        this.gui.drawIcon(string, this.posXOffset(), this.posY + 3, 1);
    }

    protected int posX() {
        if (this.side == LEFT) {
            return this.posX - this.currentWidth;
        }
        return this.posX;
    }

    protected int posXOffset() {
        return this.posX() + this.offset();
    }

    protected int offset() {
        return this.side == LEFT ? 4 : 2;
    }

    public boolean intersectsWith(int n, int n2, int n3, int n4) {
        return this.side == LEFT ? n <= n3 && n >= n3 - this.currentWidth && n2 >= n4 && n2 <= n4 + this.currentHeight : n >= n3 && n <= n3 + this.currentWidth && n2 >= n4 && n2 <= n4 + this.currentHeight;
    }

    public boolean isFullyOpened() {
        return this.fullyOpen;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
        this.fullyOpen = true;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == LEFT) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
            this.fullyOpen = false;
        } else {
            this.open = true;
            if (this.side == LEFT) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
    }

    public Rectangle4i getBounds() {
        return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), this.currentWidth, this.currentHeight);
    }
}

